/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.gui.container;

import cool.furry.mc.forge.projectexpansion.net.PacketHandler;
import cool.furry.mc.forge.projectexpansion.net.packets.IPacket;
import cool.furry.mc.forge.projectexpansion.net.packets.to_client.PacketUpdateWindowBigInteger;
import cool.furry.mc.forge.projectexpansion.net.packets.to_client.PacketUpdateWindowInt;
import cool.furry.mc.forge.projectexpansion.net.packets.to_client.PacketUpdateWindowLong;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import moze_intel.projecte.gameObjs.container.PEContainer;
import moze_intel.projecte.gameObjs.container.slots.HotBarSlot;
import moze_intel.projecte.gameObjs.container.slots.IInsertableSlot;
import moze_intel.projecte.gameObjs.container.slots.InventoryContainerSlot;
import moze_intel.projecte.gameObjs.container.slots.MainInventorySlot;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerBase
extends AbstractContainerMenu {
    protected final List<InventoryContainerSlot> inventoryContainerSlots = new ArrayList<InventoryContainerSlot>();
    protected final List<MainInventorySlot> mainInventorySlots = new ArrayList<MainInventorySlot>();
    protected final List<HotBarSlot> hotBarSlots = new ArrayList<HotBarSlot>();
    private final List<DataSlot> intFields = new ArrayList<DataSlot>();
    protected final List<PEContainer.BoxedLong> longFields = new ArrayList<PEContainer.BoxedLong>();
    protected final List<BoxedBigInteger> bigIntegerFields = new ArrayList<BoxedBigInteger>();
    protected final Inventory playerInv;

    public ContainerBase(MenuType<?> type, int windowId, Inventory playerInv) {
        super(type, windowId);
        this.playerInv = playerInv;
    }

    protected void addPlayerInventory(int xStart, int yStart) {
        int i;
        int slotSize = 18;
        int rows = 3;
        for (i = 0; i < rows; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_((Slot)this.createMainInventorySlot(this.playerInv, j + i * 9 + 9, xStart + j * slotSize, yStart + i * slotSize));
            }
        }
        yStart = yStart + slotSize * rows + 4;
        for (i = 0; i < Inventory.m_36059_(); ++i) {
            this.m_38897_((Slot)this.createHotBarSlot(this.playerInv, i, xStart + i * slotSize, yStart));
        }
    }

    protected MainInventorySlot createMainInventorySlot(Inventory inv, int index, int x, int y) {
        return new MainInventorySlot((Container)inv, index, x, y);
    }

    protected HotBarSlot createHotBarSlot(Inventory inv, int index, int x, int y) {
        return new HotBarSlot((Container)inv, index, x, y);
    }

    protected Slot m_38897_(Slot slot) {
        super.m_38897_(slot);
        if (slot instanceof InventoryContainerSlot) {
            InventoryContainerSlot containerSlot = (InventoryContainerSlot)slot;
            this.inventoryContainerSlots.add(containerSlot);
        } else if (slot instanceof MainInventorySlot) {
            MainInventorySlot inventorySlot = (MainInventorySlot)slot;
            this.mainInventorySlots.add(inventorySlot);
        } else if (slot instanceof HotBarSlot) {
            HotBarSlot hotBarSlot = (HotBarSlot)slot;
            this.hotBarSlots.add(hotBarSlot);
        }
        return slot;
    }

    @Nullable
    public Slot tryGetSlot(int slotId) {
        if (slotId >= 0 && slotId < this.f_38839_.size()) {
            return this.m_38853_(slotId);
        }
        return null;
    }

    public ItemStack m_7648_(Player player, int slotID) {
        ItemStack slotStack;
        Slot currentSlot = this.tryGetSlot(slotID);
        if (currentSlot == null || !currentSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stackToInsert = slotStack = currentSlot.m_7993_();
        if (currentSlot instanceof InventoryContainerSlot) {
            stackToInsert = ContainerBase.insertItem(this.hotBarSlots, stackToInsert, true);
            stackToInsert = ContainerBase.insertItem(this.mainInventorySlots, stackToInsert, true);
            stackToInsert = ContainerBase.insertItem(this.hotBarSlots, stackToInsert, false);
            stackToInsert = ContainerBase.insertItem(this.mainInventorySlots, stackToInsert, false);
        } else {
            stackToInsert = ContainerBase.insertItem(this.inventoryContainerSlots, stackToInsert, true);
            if (slotStack.m_41613_() == stackToInsert.m_41613_()) {
                stackToInsert = ContainerBase.insertItem(this.inventoryContainerSlots, stackToInsert, false);
                if (slotStack.m_41613_() == stackToInsert.m_41613_()) {
                    if (currentSlot instanceof MainInventorySlot) {
                        stackToInsert = ContainerBase.insertItem(this.hotBarSlots, stackToInsert, true);
                        stackToInsert = ContainerBase.insertItem(this.hotBarSlots, stackToInsert, false);
                    } else if (currentSlot instanceof HotBarSlot) {
                        stackToInsert = ContainerBase.insertItem(this.mainInventorySlots, stackToInsert, true);
                        stackToInsert = ContainerBase.insertItem(this.mainInventorySlots, stackToInsert, false);
                    }
                }
            }
        }
        if (stackToInsert.m_41613_() == slotStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        return this.transferSuccess(currentSlot, player, slotStack, stackToInsert);
    }

    protected ItemStack transferSuccess(Slot currentSlot, Player player, ItemStack slotStack, ItemStack stackToInsert) {
        int difference = slotStack.m_41613_() - stackToInsert.m_41613_();
        ItemStack newStack = currentSlot.m_6201_(difference);
        currentSlot.m_142406_(player, newStack);
        return newStack;
    }

    public static <SLOT extends Slot> ItemStack insertItem(List<SLOT> slots, ItemStack stack, boolean ignoreEmpty) {
        Slot slot;
        if (stack.m_41619_()) {
            return stack;
        }
        Iterator<SLOT> iterator = slots.iterator();
        while (iterator.hasNext() && (ignoreEmpty != (slot = (Slot)iterator.next()).m_6657_() || !(stack = ((IInsertableSlot)slot).insertItem(stack, false)).m_41619_())) {
        }
        return stack;
    }

    protected static boolean stillValid(Player player, BlockEntity blockEntity, Supplier<Block> block) {
        BlockPos pos = blockEntity.m_58899_();
        return player.m_9236_().m_8055_(pos).m_60734_() == block.get() && player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0;
    }

    public final void updateProgressBarLong(int idx, long data) {
        this.longFields.get(idx).set(data);
    }

    public final void updateProgressBarBigInteger(int idx, BigInteger data) {
        this.bigIntegerFields.get(idx).set(data);
    }

    public final void updateProgressBarInt(int idx, int data) {
        this.intFields.get(idx).m_6422_(data);
    }

    protected DataSlot m_38895_(DataSlot referenceHolder) {
        this.intFields.add(referenceHolder);
        return referenceHolder;
    }

    protected void broadcastPX(boolean all) {
        int i;
        for (i = 0; i < this.longFields.size(); ++i) {
            PEContainer.BoxedLong boxedLong = this.longFields.get(i);
            if (!boxedLong.isDirty() && !all) continue;
            this.syncDataChange(new PacketUpdateWindowLong((short)this.f_38840_, (short)i, boxedLong.get()));
        }
        for (i = 0; i < this.intFields.size(); ++i) {
            DataSlot referenceHolder = this.intFields.get(i);
            if (!referenceHolder.m_39409_() && !all) continue;
            this.syncDataChange(new PacketUpdateWindowInt((short)this.f_38840_, (short)i, referenceHolder.m_6501_()));
        }
        for (i = 0; i < this.bigIntegerFields.size(); ++i) {
            BoxedBigInteger boxedBigInteger = this.bigIntegerFields.get(i);
            if (!boxedBigInteger.isDirty() && !all) continue;
            this.syncDataChange(new PacketUpdateWindowBigInteger((short)this.f_38840_, (short)i, boxedBigInteger.get()));
        }
    }

    public void m_38946_() {
        super.m_38946_();
        this.broadcastPX(false);
    }

    public void m_150429_() {
        super.m_150429_();
        this.broadcastPX(true);
    }

    protected void syncDataChange(IPacket packet) {
        Player player = this.playerInv.f_35978_;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketHandler.sendTo(packet, player2);
        }
    }

    public static class BoxedBigInteger {
        private BigInteger inner = BigInteger.ZERO;
        private boolean dirty = false;

        public BigInteger get() {
            return this.inner;
        }

        public void set(BigInteger v) {
            if (!v.equals(this.inner)) {
                this.inner = v;
                this.dirty = true;
            }
        }

        public boolean isDirty() {
            boolean ret = this.dirty;
            this.dirty = false;
            return ret;
        }
    }
}

