/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.gui;

import cool.furry.mc.forge.projectexpansion.capability.CapabilityAlchemicalBookLocations;
import cool.furry.mc.forge.projectexpansion.item.ItemAlchemicalBook;
import cool.furry.mc.forge.projectexpansion.net.PacketHandler;
import cool.furry.mc.forge.projectexpansion.net.packets.to_server.PacketCreateTeleportDestination;
import cool.furry.mc.forge.projectexpansion.net.packets.to_server.PacketDeleteTeleportDestination;
import cool.furry.mc.forge.projectexpansion.net.packets.to_server.PacketTeleportBack;
import cool.furry.mc.forge.projectexpansion.net.packets.to_server.PacketTeleportToDestination;
import cool.furry.mc.forge.projectexpansion.util.EMCFormat;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public class GUIAlchemicalBook
extends Screen {
    private final List<CapabilityAlchemicalBookLocations.TeleportLocation> locations = new ArrayList<CapabilityAlchemicalBookLocations.TeleportLocation>();
    @Nullable
    private CapabilityAlchemicalBookLocations.TeleportLocation backLocation = null;
    ButtonCreate buttonCreate;
    ButtonBack buttonBack;
    ButtonClose buttonClose;
    @Nullable
    ButtonPrev buttonPrev = null;
    @Nullable
    ButtonNext buttonNext = null;
    EditBox createName;
    LocalPlayer player;
    InteractionHand hand;
    ArrayList<ButtonTeleport> teleportButtons = new ArrayList();
    ArrayList<ButtonDelete> deleteButtons = new ArrayList();
    @Nullable
    private IKnowledgeProvider knowledgeProvider = null;
    private boolean canEdit;
    private final boolean acrossDimensions;
    private int page = 1;
    private int maxPages = 1;
    private final int w = 90;
    private final int h = 20;

    public GUIAlchemicalBook(LocalPlayer player, InteractionHand hand, List<CapabilityAlchemicalBookLocations.TeleportLocation> locations, boolean canEdit) {
        super((Component)Lang.ALCHEMICAL_BOOK.translate(new Object[0]));
        this.player = player;
        this.hand = hand;
        this.locations.addAll(locations);
        this.canEdit = canEdit;
        this.acrossDimensions = this.getTier().isAcrossDimensions();
        this.extractBackLocation();
    }

    private IKnowledgeProvider getKnowledgeCapability() {
        if (this.knowledgeProvider == null) {
            LazyOptional lazyOptional = this.player.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY);
            this.knowledgeProvider = (IKnowledgeProvider)lazyOptional.orElseThrow(() -> new IllegalStateException("Player does not have knowledge capability"));
            lazyOptional.addListener(optional -> {
                this.knowledgeProvider = null;
            });
        }
        return this.knowledgeProvider;
    }

    private ItemStack getItemStack() {
        return this.player.m_21120_(this.hand);
    }

    private ItemAlchemicalBook.Tier getTier() {
        return ((ItemAlchemicalBook)this.getItemStack().m_41720_()).getTier();
    }

    private boolean canTeleport(CapabilityAlchemicalBookLocations.TeleportLocation location) {
        return this.getKnowledgeCapability().getEmc().compareTo(BigInteger.valueOf(location.getCost(this.getItemStack(), (Player)this.player))) >= 0;
    }

    protected void m_7856_() {
        this.buttonCreate = new ButtonCreate(this.f_96543_ / 2 - 90, 20, 90, 20);
        this.m_142416_((GuiEventListener)this.buttonCreate);
        this.buttonClose = new ButtonClose(this.f_96543_ / 2 - 90 - 50, 20);
        this.m_142416_((GuiEventListener)this.buttonClose);
        this.createName = new EditBox(this.f_96547_, this.buttonCreate.m_252754_() + this.buttonCreate.m_5711_() + 10, this.buttonCreate.m_252907_(), 90, 20, (Component)Lang.ALCHEMICAL_BOOK_CREATE.translate(new Object[0]));
        this.createName.m_94199_(20);
        this.createName.m_93692_(true);
        if (!this.canEdit) {
            this.buttonCreate.f_93623_ = false;
            this.createName.m_94186_(false);
        } else {
            this.createName.m_94151_(str -> {
                this.buttonCreate.f_93623_ = !str.isEmpty();
                this.buttonCreate.setName((String)str);
            });
        }
        String biomeName = Objects.requireNonNull(this.player.m_9236_().m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)((Biome)this.player.m_9236_().m_204166_(this.player.m_20097_()).get()))).m_135815_();
        this.createName.m_94144_(Arrays.stream(biomeName.split("_")).map(StringUtils::capitalize).reduce("", (a, b) -> a + " " + b).trim());
        this.buttonBack = new ButtonBack(this.createName.m_252754_() + this.createName.m_5711_() + 8, this.buttonClose.m_252907_(), 45, 20);
        this.m_142416_((GuiEventListener)this.buttonBack);
        this.m_142416_((GuiEventListener)this.createName);
        this.drawLocations();
    }

    public void drawLocations() {
        int xStart;
        int boxTop;
        int rowpad = 1;
        int delete_w = 20;
        int delpad = 2;
        int colpad = 8;
        this.teleportButtons.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.teleportButtons.clear();
        this.deleteButtons.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.deleteButtons.clear();
        if (this.buttonPrev != null) {
            this.m_169411_((GuiEventListener)this.buttonPrev);
            this.buttonPrev = null;
        }
        if (this.buttonNext != null) {
            this.m_169411_((GuiEventListener)this.buttonNext);
            this.buttonNext = null;
        }
        int midHeight = (int)Math.floor((double)this.f_96544_ * 0.7);
        int midWidth = (int)Math.floor((double)this.f_96543_ * 0.85);
        int maxRows = midHeight / (20 + rowpad);
        int maxColumns = midWidth / (90 + colpad + delpad + delete_w);
        int boxLeft = (this.f_96543_ - ((delete_w + delpad + 90) * maxColumns + colpad * 2)) / 2;
        int yStart = boxTop = 46;
        int x = xStart = boxLeft + (delete_w + delpad);
        int y = yStart;
        int xIndex = 1;
        int yIndex = 1;
        int perPage = maxRows * maxColumns;
        this.maxPages = (int)Math.ceil((double)this.locations.size() / (double)perPage);
        for (CapabilityAlchemicalBookLocations.TeleportLocation loc : this.locations.subList(perPage * (this.page - 1), Math.min(this.locations.size(), perPage * this.page))) {
            if (xIndex > maxColumns) {
                x = xStart;
                xIndex = 2;
                ++yIndex;
                y += 20 + rowpad;
            } else {
                if (xIndex > 1) {
                    x += 90 + delete_w + colpad;
                }
                ++xIndex;
            }
            if (yIndex > maxRows) break;
            ButtonTeleport teleportButton = new ButtonTeleport(x, y, 90, 20, loc);
            ButtonDelete deleteButton = new ButtonDelete(x - delete_w - delpad, y, delete_w, 20, loc.name());
            deleteButton.f_93623_ = this.canEdit;
            this.m_142416_((GuiEventListener)teleportButton);
            this.m_142416_((GuiEventListener)deleteButton);
            this.teleportButtons.add(teleportButton);
            this.deleteButtons.add(deleteButton);
        }
        int prevY = boxTop + (20 + rowpad) * yIndex;
        int prevX = boxLeft;
        int nextY = boxTop + (20 + rowpad) * yIndex;
        int nextX = boxLeft + (90 + colpad + delete_w + delpad) * maxColumns - 90 + colpad;
        if (this.maxPages > 1) {
            this.buttonPrev = new ButtonPrev(prevX, prevY, 90 - delete_w, 20, this.page > 1);
            this.buttonNext = new ButtonNext(nextX, nextY, 90 - delete_w, 20, this.page < this.maxPages);
            this.m_142416_((GuiEventListener)this.buttonPrev);
            this.m_142416_((GuiEventListener)this.buttonNext);
        }
        if (this.backLocation != null) {
            this.buttonBack.updateLocation(this.backLocation);
        }
    }

    public void setLocations(List<CapabilityAlchemicalBookLocations.TeleportLocation> locations, boolean canEdit) {
        this.locations.clear();
        this.locations.addAll(locations);
        this.extractBackLocation();
        if (canEdit != this.canEdit) {
            this.canEdit = canEdit;
            this.m_232761_();
        } else {
            this.drawLocations();
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private void extractBackLocation() {
        this.backLocation = this.locations.stream().filter(CapabilityAlchemicalBookLocations.TeleportLocation::isBack).findFirst().orElse(null);
        if (this.backLocation != null) {
            this.locations.remove(this.backLocation);
        }
    }

    public void previousPage() {
        this.setPage(this.page - 1);
    }

    public void nextPage() {
        this.setPage(this.page + 1);
    }

    public void setPage(int page) {
        this.page = Math.max(1, Math.min(this.maxPages, page));
        this.drawLocations();
    }

    public Component getTeleportationTooltip(CapabilityAlchemicalBookLocations.TeleportLocation location, boolean canTeleport) {
        ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
        if (canTeleport) {
            int cost;
            tooltips.add(Component.m_237113_((String)String.format("%d, %d, %d", location.x(), location.y(), location.z())));
            int distance = (int)location.distanceFrom(this.player.m_20097_());
            if (distance > 0) {
                tooltips.add(Lang.ALCHEMICAL_BOOK_DISTANCE.translate(new Object[]{distance}));
            }
            if ((cost = location.getCost(this.getItemStack(), (Player)this.player)) > 0) {
                tooltips.add(Lang.ALCHEMICAL_BOOK_COST.translate(new Object[]{EMCFormat.getComponent(cost).m_130940_(ChatFormatting.YELLOW)}));
            }
        } else {
            tooltips.add(Lang.ALCHEMICAL_BOOK_DIMENSION.translate(new Object[]{Component.m_237115_((String)location.dimension().m_135782_().toString())}));
        }
        MutableComponent tooltip = Component.m_237119_();
        for (int i = 0; i < tooltips.size(); ++i) {
            tooltip = tooltip.m_7220_((Component)tooltips.get(i));
            if (i >= tooltips.size() - 1) continue;
            tooltip = tooltip.m_7220_((Component)Component.m_237113_((String)"\n"));
        }
        return tooltip;
    }

    private class ButtonPrev
    extends Button {
        public ButtonPrev(int x, int y, int w, int h, boolean active) {
            super(Button.m_253074_((Component)Lang.ALCHEMICAL_BOOK_PREV.translate(new Object[0]), button -> GUIAlchemicalBook.this.previousPage()).m_252794_(x, y).m_253046_(w, h));
            this.f_93623_ = active;
        }
    }

    private class ButtonNext
    extends Button {
        public ButtonNext(int x, int y, int w, int h, boolean active) {
            super(Button.m_253074_((Component)Lang.ALCHEMICAL_BOOK_NEXT.translate(new Object[0]), button -> GUIAlchemicalBook.this.nextPage()).m_252794_(x, y).m_253046_(w, h));
            this.f_93623_ = active;
        }
    }

    private class ButtonCreate
    extends Button {
        String name;

        public ButtonCreate(int x, int y, int w, int h) {
            super(Button.m_253074_((Component)Lang.ALCHEMICAL_BOOK_CREATE.translate(new Object[0]), button -> {}).m_252794_(x, y).m_253046_(w, h));
        }

        public void m_5716_(double p_93371_, double p_93372_) {
            if (this.name == null) {
                return;
            }
            PacketHandler.sendToServer(new PacketCreateTeleportDestination(this.name, (Player)GUIAlchemicalBook.this.player, GUIAlchemicalBook.this.hand));
        }

        private void setName(String name) {
            this.name = name;
        }
    }

    private class ButtonClose
    extends Button {
        public ButtonClose(int x, int y) {
            super(Button.m_253074_((Component)Lang.ALCHEMICAL_BOOK_CLOSE.translate(new Object[0]), button -> cool$furry$mc$forge$projectexpansion$gui$GUIAlchemicalBook$this.player.m_6915_()).m_252794_(x, y).m_253046_(40, 20));
        }
    }

    private class ButtonBack
    extends Button {
        @Nullable
        private CapabilityAlchemicalBookLocations.TeleportLocation location;
        private boolean canTeleport;

        public ButtonBack(int x, int y, int w, int h) {
            super(Button.m_253074_((Component)Lang.ALCHEMICAL_BOOK_BACK.translate(new Object[0]), button -> PacketHandler.sendToServer(new PacketTeleportBack((Player)cool$furry$mc$forge$projectexpansion$gui$GUIAlchemicalBook$this.player, cool$furry$mc$forge$projectexpansion$gui$GUIAlchemicalBook$this.hand))).m_252794_(x, y).m_253046_(w, h));
        }

        protected void m_87963_(GuiGraphics graphics, int pMouseX, int pMouseY, float unknown) {
            if (this.m_198029_()) {
                if (this.location == null) {
                    GUIAlchemicalBook.this.m_257404_((Component)Lang.ALCHEMICAL_BOOK_NO_BACK_LOCATION.translate(new Object[0]));
                    super.m_87963_(graphics, pMouseX, pMouseY, unknown);
                    return;
                }
                GUIAlchemicalBook.this.m_257404_(GUIAlchemicalBook.this.getTeleportationTooltip(this.location, this.canTeleport));
            }
            super.m_87963_(graphics, pMouseX, pMouseY, unknown);
        }

        public void updateLocation(@Nullable CapabilityAlchemicalBookLocations.TeleportLocation location) {
            if (location == null) {
                this.f_93623_ = false;
                this.location = null;
                this.canTeleport = false;
            } else {
                this.f_93623_ = true;
                this.location = location;
                this.canTeleport = GUIAlchemicalBook.this.acrossDimensions || location.dimension().equals((Object)GUIAlchemicalBook.this.player.m_9236_().m_46472_());
            }
        }
    }

    private class ButtonTeleport
    extends Button {
        CapabilityAlchemicalBookLocations.TeleportLocation location;
        boolean canTeleport;
        boolean hasEnoughEMC;

        public ButtonTeleport(int x, int y, int w, int h, CapabilityAlchemicalBookLocations.TeleportLocation location) {
            super(Button.m_253074_((Component)Component.m_237113_((String)location.name()), button -> {
                PacketHandler.sendToServer(new PacketTeleportToDestination(location.name(), (Player)cool$furry$mc$forge$projectexpansion$gui$GUIAlchemicalBook$this.player, cool$furry$mc$forge$projectexpansion$gui$GUIAlchemicalBook$this.hand));
                cool$furry$mc$forge$projectexpansion$gui$GUIAlchemicalBook$this.player.m_6915_();
            }).m_252794_(x, y).m_253046_(w, h));
            this.location = location;
            this.hasEnoughEMC = GUIAlchemicalBook.this.canTeleport(location);
            this.canTeleport = GUIAlchemicalBook.this.acrossDimensions || location.dimension().equals((Object)GUIAlchemicalBook.this.player.m_9236_().m_46472_());
            this.f_93623_ = this.canTeleport && this.hasEnoughEMC;
        }

        protected void m_87963_(GuiGraphics graphics, int pMouseX, int pMouseY, float unknown) {
            if (this.m_198029_()) {
                GUIAlchemicalBook.this.m_257404_(GUIAlchemicalBook.this.getTeleportationTooltip(this.location, this.canTeleport));
            }
            super.m_87963_(graphics, pMouseX, pMouseY, unknown);
        }
    }

    private class ButtonDelete
    extends Button {
        public ButtonDelete(int x, int y, int w, int h, String name) {
            super(Button.m_253074_((Component)Component.m_237113_((String)"X"), button -> PacketHandler.sendToServer(new PacketDeleteTeleportDestination(name, (Player)cool$furry$mc$forge$projectexpansion$gui$GUIAlchemicalBook$this.player, cool$furry$mc$forge$projectexpansion$gui$GUIAlchemicalBook$this.hand))).m_252794_(x, y).m_253046_(w, h));
        }
    }
}

