/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.gui;

import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.util.EMCFormat;
import java.math.BigInteger;
import javax.annotation.Nullable;
import moze_intel.projecte.api.capabilities.PECapabilities;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="projectexpansion", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class EMCDisplay {
    private static BigInteger emc = BigInteger.ZERO;
    private static final BigInteger[] history = new BigInteger[]{BigInteger.ZERO, BigInteger.ZERO};
    private static BigInteger lastEMC = BigInteger.ZERO;
    private static int tick = 0;

    @Nullable
    private static LocalPlayer getPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (!((Boolean)Config.emcDisplay.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = EMCDisplay.getPlayer();
        if (event.phase == TickEvent.Phase.END && player != null && ++tick >= 20) {
            tick = 0;
            player.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY).ifPresent(provider -> {
                emc = provider.getEmc();
                EMCDisplay.history[1] = history[0];
                EMCDisplay.history[0] = emc.subtract(lastEMC);
                lastEMC = emc;
            });
        }
    }

    private static void reset() {
        emc = lastEMC = BigInteger.ZERO;
        tick = 0;
    }

    @SubscribeEvent
    public static void clientDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        if (!((Boolean)Config.emcDisplay.get()).booleanValue()) {
            return;
        }
        EMCDisplay.reset();
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        if (!((Boolean)Config.emcDisplay.get()).booleanValue()) {
            return;
        }
        EMCDisplay.reset();
    }

    @SubscribeEvent
    public static void onRenderGUI(CustomizeGuiOverlayEvent.DebugText event) {
        if (!((Boolean)Config.emcDisplay.get()).booleanValue()) {
            return;
        }
        BigInteger avg = history[0].add(history[1]);
        Object str = EMCFormat.format(emc);
        if (!avg.equals(BigInteger.ZERO)) {
            str = (String)str + " " + (avg.compareTo(BigInteger.ZERO) > 0 ? ChatFormatting.GREEN + "+" : ChatFormatting.RED + "-") + EMCFormat.format(avg.abs()) + "/s";
        }
        event.getLeft().add(String.format("EMC: %s", str));
    }
}

