/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.events;

import cool.furry.mc.forge.projectexpansion.Main;
import cool.furry.mc.forge.projectexpansion.block.BlockCompactSun;
import cool.furry.mc.forge.projectexpansion.registries.DamageSources;
import cool.furry.mc.forge.projectexpansion.registries.Items;
import cool.furry.mc.forge.projectexpansion.util.EffectHelper;
import cool.furry.mc.forge.projectexpansion.util.SunExposureHelper;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.advancements.Advancement;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="projectexpansion")
public class ServerEvents {
    static ArrayList<SunExposureTimer> timers = new ArrayList();
    private static final ResourceLocation BLINDED_BY_THE_LIGHT = Main.rl("blinded_by_the_light");

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
            ServerEvents.handleSunExposure(event, player);
            ServerEvents.handleWeighedDown(event, player);
        }
    }

    private static void handleWeighedDown(TickEvent.ServerTickEvent event, ServerPlayer player) {
        if (SunExposureHelper.wearingAllProtectiveArmor(player)) {
            return;
        }
        int protectionLevel = SunExposureHelper.getProtectionAmount(player);
        boolean hasCompactSun = player.m_21055_((Item)Items.COMPACT_SUN.get());
        if (!hasCompactSun) {
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (stack.m_41720_() != Items.COMPACT_SUN.get()) continue;
                hasCompactSun = true;
                break;
            }
        }
        if (hasCompactSun) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 3 - protectionLevel, false, false));
        }
    }

    private static int getFireTime(ServerPlayer player) {
        int time = 10;
        int protectionLevel = SunExposureHelper.getProtectionAmount(player);
        if (protectionLevel > 0) {
            time -= 2 + 2 * protectionLevel;
        }
        return time;
    }

    private static void handleSunExposure(TickEvent.ServerTickEvent event, ServerPlayer player) {
        HashSet<SunExposureTimer> toRemove = new HashSet<SunExposureTimer>();
        HitResult result = player.m_19907_(10.0, 0.0f, false);
        DamageSources damage = DamageSources.fromServer(event.getServer());
        if (result instanceof BlockHitResult) {
            BlockHitResult hit = (BlockHitResult)result;
            Block block = player.m_9236_().m_8055_(hit.m_82425_()).m_60734_();
            if (block instanceof BlockCompactSun) {
                SunExposureTimer timer = SunExposureTimer.addOrIncrement(player, block);
                if (timer.over() && !SunExposureHelper.wearingAllProtectiveArmor(player)) {
                    Advancement advancement;
                    player.m_7292_(EffectHelper.create(MobEffects.f_216964_, 50, 0, false, false));
                    player.m_7292_(EffectHelper.create(MobEffects.f_19607_, 2, 0, false, false));
                    player.m_7311_(2);
                    if (timer.time() % 15 == 0) {
                        float playerMaxHealth = player.m_21233_();
                        player.m_6469_(damage.stareAtSun(), playerMaxHealth * 0.4f);
                    }
                    if ((advancement = event.getServer().m_129889_().m_136041_(BLINDED_BY_THE_LIGHT)) != null) {
                        player.m_8960_().m_135988_(advancement, "blinded_by_the_light");
                    }
                }
            } else {
                for (SunExposureTimer timer : timers) {
                    if (timer.player != player) continue;
                    toRemove.add(timer);
                }
            }
        } else {
            for (SunExposureTimer timer : timers) {
                if (timer.player != player) continue;
                toRemove.add(timer);
            }
        }
        if (!toRemove.isEmpty()) {
            boolean applyEffects = toRemove.stream().anyMatch(SunExposureTimer::over);
            timers.removeAll(toRemove);
            if (applyEffects) {
                int fireTime = ServerEvents.getFireTime(player);
                player.m_20254_(fireTime);
            }
        }
    }

    public record SunExposureTimer(int time, ServerPlayer player, Block block) {
        public void increment() {
            SunExposureTimer newTimer = new SunExposureTimer(this.time + 1, this.player, this.block);
            timers.remove(this);
            timers.add(newTimer);
        }

        public void reset() {
            timers.remove(this);
        }

        public boolean over() {
            return this.time >= 60;
        }

        public static SunExposureTimer addOrIncrement(ServerPlayer player, Block block) {
            for (SunExposureTimer timer : timers) {
                if (timer.player != player || timer.block != block) continue;
                timer.increment();
                return timer;
            }
            SunExposureTimer newTimer = new SunExposureTimer(1, player, block);
            timers.add(newTimer);
            return newTimer;
        }
    }
}

