/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.events;

import cool.furry.mc.forge.projectexpansion.capability.CapabilityAlchemicalBookLocations;
import cool.furry.mc.forge.projectexpansion.item.ItemAlchemicalBook;
import cool.furry.mc.forge.projectexpansion.registries.Capabilities;
import moze_intel.projecte.capability.managing.ICapabilityResolver;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="projectexpansion")
public class PlayerEvents {
    @SubscribeEvent
    public static void cloneEvent(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        original.reviveCaps();
        original.getCapability(Capabilities.ALCHEMICAL_BOOK_LOCATIONS).ifPresent(old -> {
            CompoundTag tag = (CompoundTag)old.serializeNBT();
            event.getEntity().getCapability(Capabilities.ALCHEMICAL_BOOK_LOCATIONS).ifPresent(newCap -> newCap.deserializeNBT((Tag)tag));
        });
        original.invalidateCaps();
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<?> event) {
        ItemStack stack;
        Object object = event.getObject();
        if (object instanceof ItemStack && (stack = (ItemStack)object).m_41720_() instanceof ItemAlchemicalBook) {
            PlayerEvents.attachCapability(event, CapabilityAlchemicalBookLocations.Provider.NAME, new CapabilityAlchemicalBookLocations.Provider(ItemAlchemicalBook.Mode.STACK, null, stack));
        } else {
            object = event.getObject();
            if (object instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)object;
                PlayerEvents.attachCapability(event, CapabilityAlchemicalBookLocations.Provider.NAME, new CapabilityAlchemicalBookLocations.Provider(ItemAlchemicalBook.Mode.PLAYER, player, null));
            }
        }
    }

    private static void attachCapability(AttachCapabilitiesEvent<?> event, ResourceLocation name, ICapabilityResolver<?> provider) {
        event.addCapability(name, provider);
        event.addListener(() -> provider.invalidateAll());
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        event.getEntity().getCapability(Capabilities.ALCHEMICAL_BOOK_LOCATIONS).ifPresent(cap -> cap.sync((ServerPlayer)event.getEntity()));
    }

    @SubscribeEvent
    public static void respawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        event.getEntity().getCapability(Capabilities.ALCHEMICAL_BOOK_LOCATIONS).ifPresent(cap -> cap.sync((ServerPlayer)event.getEntity()));
    }
}

