/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.commands;

import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.events.PermissionGatherEvent;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContextKey;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import net.minecraftforge.server.permission.nodes.PermissionType;
import net.minecraftforge.server.permission.nodes.PermissionTypes;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Permissions {
    private static final ArrayList<PermissionNode<?>> NODES = new ArrayList();
    private static final PermissionNode.PermissionResolver<Boolean> PLAYER_IS_OP = (player, uuid, context) -> player != null && player.m_20310_(2);
    public static final CommandPermissionNode EMC = Permissions.nodeOpCommand("emc");
    public static final CommandPermissionNode EMC_ADD = Permissions.nodeOpCommand("emc.add");
    public static final CommandPermissionNode EMC_GET = Permissions.nodeOpCommand("emc.get");
    public static final CommandPermissionNode EMC_REMOVE = Permissions.nodeOpCommand("emc.remove");
    public static final CommandPermissionNode EMC_SET = Permissions.nodeOpCommand("emc.set");
    public static final CommandPermissionNode EMC_TEST = Permissions.nodeOpCommand("emc.test");
    public static final CommandPermissionNode KNOWLEDGE = Permissions.nodeOpCommand("knowledge");
    public static final CommandPermissionNode KNOWLEDGE_CLEAR = Permissions.nodeOpCommand("knowledge.clear");
    public static final CommandPermissionNode KNOWLEDGE_LEARN = Permissions.nodeOpCommand("knowledge.learn");
    public static final CommandPermissionNode KNOWLEDGE_TEST = Permissions.nodeOpCommand("knowledge.test");
    public static final CommandPermissionNode KNOWLEDGE_UNLEARN = Permissions.nodeOpCommand("knowledge.unlearn");
    public static final CommandPermissionNode BOOK = Permissions.nodeOpCommand("book");
    public static final CommandPermissionNode BOOK_ADD = Permissions.nodeOpCommand("book.add");
    public static final CommandPermissionNode BOOK_ADD_HAND = Permissions.nodeOpCommand("book.add.hand");
    public static final CommandPermissionNode BOOK_ADD_PLAYER = Permissions.nodeOpCommand("book.add.player");
    public static final CommandPermissionNode BOOK_CLEAR = Permissions.nodeOpCommand("book.clear");
    public static final CommandPermissionNode BOOK_CLEAR_HAND = Permissions.nodeOpCommand("book.clear.hand");
    public static final CommandPermissionNode BOOK_CLEAR_PLAYER = Permissions.nodeOpCommand("book.clear.player");
    public static final CommandPermissionNode BOOK_DUMP = Permissions.nodeOpCommand("book.dump");
    public static final CommandPermissionNode BOOK_DUMP_HAND = Permissions.nodeOpCommand("book.dump.hand");
    public static final CommandPermissionNode BOOK_DUMP_PLAYER = Permissions.nodeOpCommand("book.dump.player");
    public static final CommandPermissionNode BOOK_LIST = Permissions.nodeOpCommand("book.list");
    public static final CommandPermissionNode BOOK_LIST_HAND = Permissions.nodeOpCommand("book.list.hand");
    public static final CommandPermissionNode BOOK_LIST_PLAYER = Permissions.nodeOpCommand("book.list.player");
    public static final CommandPermissionNode BOOK_REMOVE = Permissions.nodeOpCommand("book.remove");
    public static final CommandPermissionNode BOOK_REMOVE_HAND = Permissions.nodeOpCommand("book.remove.hand");
    public static final CommandPermissionNode BOOK_REMOVE_PLAYER = Permissions.nodeOpCommand("book.remove.player");

    private static CommandPermissionNode nodeOpCommand(String nodeName) {
        PermissionNode<Boolean> node = Permissions.node("command." + nodeName, PermissionTypes.BOOLEAN, PLAYER_IS_OP, new PermissionDynamicContextKey[0]);
        return new CommandPermissionNode(node, 2);
    }

    @SafeVarargs
    private static <T> PermissionNode<T> node(String nodeName, PermissionType<T> type, PermissionNode.PermissionResolver<T> defaultResolver, PermissionDynamicContextKey<T> ... dynamics) {
        PermissionNode node = new PermissionNode("projectexpansion", nodeName, type, defaultResolver, dynamics);
        NODES.add(node);
        return node;
    }

    @SubscribeEvent
    public static void registerPermissionNodes(PermissionGatherEvent.Nodes event) {
        event.addNodes(NODES);
    }

    public record CommandPermissionNode(PermissionNode<Boolean> node, int fallbackLevel) implements Predicate<CommandSourceStack>
    {
        @Override
        public boolean test(CommandSourceStack source) {
            boolean bl;
            CommandSource commandSource = source.f_81288_;
            if (commandSource instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)commandSource;
                bl = (Boolean)PermissionAPI.getPermission((ServerPlayer)player, this.node, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
            } else {
                bl = source.m_6761_(this.fallbackLevel);
            }
            return bl;
        }
    }
}

