/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import cool.furry.mc.forge.projectexpansion.commands.Permissions;
import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.util.function.Predicate;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.emc.nbt.NBTManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CommandKnowledge {
    public static LiteralArgumentBuilder<CommandSourceStack> getArguments(CommandBuildContext buildContext) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"knowledge").requires((Predicate)Permissions.KNOWLEDGE)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").requires((Predicate)Permissions.KNOWLEDGE_CLEAR)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> CommandKnowledge.handle((CommandContext<CommandSourceStack>)ctx, ActionType.CLEAR))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"learn").requires((Predicate)Permissions.KNOWLEDGE_LEARN)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)buildContext)).executes(ctx -> CommandKnowledge.handle((CommandContext<CommandSourceStack>)ctx, ActionType.LEARN)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"unlearn").requires((Predicate)Permissions.KNOWLEDGE_UNLEARN)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)buildContext)).executes(ctx -> CommandKnowledge.handle((CommandContext<CommandSourceStack>)ctx, ActionType.UNLEARN)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"test").requires((Predicate)Permissions.KNOWLEDGE_TEST)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)buildContext)).executes(ctx -> CommandKnowledge.handle((CommandContext<CommandSourceStack>)ctx, ActionType.TEST)))));
    }

    private static Component getSourceName(CommandSourceStack source) {
        try {
            return source.m_81375_().m_5446_();
        }
        catch (CommandSyntaxException e) {
            return Lang.Commands.CONSOLE.translateColored(ChatFormatting.RED, new Object[0]);
        }
    }

    private static boolean compareUUID(CommandSourceStack source, ServerPlayer player) {
        try {
            return source.m_81375_().m_20148_().equals(player.m_20148_());
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }

    private static void sendSuccess(CommandSourceStack source, Component message, boolean notify) {
        source.m_288197_(() -> message, notify);
    }

    private static int handle(CommandContext<CommandSourceStack> ctx, ActionType action) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(ctx, (String)"player");
        boolean isSelf = CommandKnowledge.compareUUID((CommandSourceStack)ctx.getSource(), player);
        if (action == ActionType.CLEAR) {
            IKnowledgeProvider provider = Util.getKnowledgeProvider((Player)player);
            if (provider == null) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Lang.FAILED_TO_GET_KNOWLEDGE_PROVIDER.translateColored(ChatFormatting.RED, new Object[]{player.m_5446_()}));
                return 0;
            }
            if (provider.getKnowledge().isEmpty()) {
                if (isSelf) {
                    ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Lang.Commands.KNOWLEDGE_CLEAR_FAIL_SELF.translateColored(ChatFormatting.RED, new Object[0]));
                } else {
                    ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Lang.Commands.KNOWLEDGE_CLEAR_FAIL.translateColored(ChatFormatting.RED, new Object[]{player.m_5446_()}));
                }
                return 0;
            }
            provider.clearKnowledge();
            provider.sync(player);
            if (CommandKnowledge.compareUUID((CommandSourceStack)ctx.getSource(), player)) {
                CommandKnowledge.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.KNOWLEDGE_CLEAR_SUCCESS_SELF.translateColored(ChatFormatting.GREEN, new Object[0]), false);
            } else {
                CommandKnowledge.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.KNOWLEDGE_CLEAR_SUCCESS.translateColored(ChatFormatting.GREEN, new Object[]{player.m_5446_()}), true);
                if (((Boolean)Config.notifyCommandChanges.get()).booleanValue()) {
                    player.m_213846_((Component)Lang.Commands.KNOWLEDGE_CLEAR_NOTIFICATION.translate(new Object[]{CommandKnowledge.getSourceName((CommandSourceStack)ctx.getSource())}));
                }
            }
            return 1;
        }
        Item item = ItemArgument.m_120963_(ctx, (String)"item").m_120979_();
        IKnowledgeProvider provider = Util.getKnowledgeProvider((Player)player);
        if (provider == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Lang.FAILED_TO_GET_KNOWLEDGE_PROVIDER.translateColored(ChatFormatting.RED, new Object[]{player.m_5446_()}));
            return 0;
        }
        IEMCProxy proxy = IEMCProxy.INSTANCE;
        if (!proxy.hasValue(item)) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Lang.Commands.KNOWLEDGE_INVALID.translate(new Object[0]));
            return 0;
        }
        int response = 1;
        switch (action) {
            case LEARN: {
                if (!provider.addKnowledge(ItemInfo.fromItem((ItemLike)item))) {
                    response = 0;
                    if (isSelf) {
                        ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Lang.Commands.KNOWLEDGE_LEARN_FAIL_SELF.translateColored(ChatFormatting.RED, new Object[]{new ItemStack((ItemLike)item).m_41611_()}));
                        break;
                    }
                    ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Lang.Commands.KNOWLEDGE_LEARN_FAIL.translateColored(ChatFormatting.RED, new Object[]{player.m_5446_(), new ItemStack((ItemLike)item).m_41611_()}));
                    break;
                }
                if (isSelf) {
                    CommandKnowledge.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.KNOWLEDGE_LEARN_SUCCESS_SELF.translateColored(ChatFormatting.GREEN, new Object[]{new ItemStack((ItemLike)item).m_41611_()}), false);
                    break;
                }
                CommandKnowledge.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.KNOWLEDGE_LEARN_SUCCESS.translateColored(ChatFormatting.GRAY, new Object[]{player.m_5446_(), new ItemStack((ItemLike)item).m_41611_()}), true);
                if (!((Boolean)Config.notifyCommandChanges.get()).booleanValue()) break;
                player.m_213846_((Component)Lang.Commands.KNOWLEDGE_LEARN_NOTIFICATION.translateColored(ChatFormatting.GRAY, new Object[]{new ItemStack((ItemLike)item).m_41611_(), CommandKnowledge.getSourceName((CommandSourceStack)ctx.getSource())}));
                break;
            }
            case UNLEARN: {
                if (!provider.removeKnowledge(ItemInfo.fromItem((ItemLike)item))) {
                    response = 0;
                    if (isSelf) {
                        ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Lang.Commands.KNOWLEDGE_UNLEARN_FAIL_SELF.translateColored(ChatFormatting.RED, new Object[]{new ItemStack((ItemLike)item).m_41611_()}));
                        break;
                    }
                    ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Lang.Commands.KNOWLEDGE_UNLEARN_FAIL.translateColored(ChatFormatting.RED, new Object[]{player.m_5446_(), new ItemStack((ItemLike)item).m_41611_()}));
                    break;
                }
                if (isSelf) {
                    CommandKnowledge.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.KNOWLEDGE_UNLEARN_SUCCESS_SELF.translateColored(ChatFormatting.GREEN, new Object[]{new ItemStack((ItemLike)item).m_41611_()}), false);
                    break;
                }
                CommandKnowledge.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.KNOWLEDGE_UNLEARN_SUCCESS.translateColored(ChatFormatting.GREEN, new Object[]{player.m_5446_(), new ItemStack((ItemLike)item).m_41611_()}), true);
                if (!((Boolean)Config.notifyCommandChanges.get()).booleanValue()) break;
                player.m_213846_((Component)Lang.Commands.KNOWLEDGE_UNLEARN_NOTIFICATION.translateColored(ChatFormatting.GRAY, new Object[]{new ItemStack((ItemLike)item).m_41611_(), CommandKnowledge.getSourceName((CommandSourceStack)ctx.getSource())}));
                break;
            }
            case TEST: {
                if (!provider.hasKnowledge(ItemInfo.fromItem((ItemLike)item))) {
                    response = 0;
                    if (isSelf) {
                        ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Lang.Commands.KNOWLEDGE_TEST_FAIL_SELF.translateColored(ChatFormatting.RED, new Object[]{new ItemStack((ItemLike)item).m_41611_()}));
                        break;
                    }
                    ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Lang.Commands.KNOWLEDGE_TEST_FAIL.translateColored(ChatFormatting.RED, new Object[]{player.m_5446_(), new ItemStack((ItemLike)item).m_41611_()}));
                    break;
                }
                if (isSelf) {
                    CommandKnowledge.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.KNOWLEDGE_TEST_SUCCESS_SELF.translateColored(ChatFormatting.GREEN, new Object[]{new ItemStack((ItemLike)item).m_41611_()}), false);
                    break;
                }
                CommandKnowledge.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.KNOWLEDGE_TEST_SUCCESS.translateColored(ChatFormatting.GREEN, new Object[]{player.m_5446_(), new ItemStack((ItemLike)item).m_41611_()}), false);
            }
        }
        if (response == 1 && action != ActionType.TEST) {
            provider.syncKnowledgeChange(player, NBTManager.getPersistentInfo((ItemInfo)ItemInfo.fromItem((ItemLike)item)), true);
        }
        return response;
    }

    private static enum ActionType {
        LEARN,
        UNLEARN,
        CLEAR,
        TEST;

    }
}

