/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import cool.furry.mc.forge.projectexpansion.commands.Permissions;
import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.util.ColorStyle;
import cool.furry.mc.forge.projectexpansion.util.EMCFormat;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.math.BigInteger;
import java.util.function.Predicate;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CommandEMC {
    public static LiteralArgumentBuilder<CommandSourceStack> getArguments() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"emc").requires((Predicate)Permissions.EMC)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").requires((Predicate)Permissions.EMC_ADD)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandEMC.handle((CommandContext<CommandSourceStack>)ctx, ActionType.ADD)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires((Predicate)Permissions.EMC_REMOVE)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandEMC.handle((CommandContext<CommandSourceStack>)ctx, ActionType.REMOVE)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").requires((Predicate)Permissions.EMC_SET)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandEMC.handle((CommandContext<CommandSourceStack>)ctx, ActionType.SET)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"test").requires((Predicate)Permissions.EMC_TEST)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandEMC.handle((CommandContext<CommandSourceStack>)ctx, ActionType.TEST)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get").requires((Predicate)Permissions.EMC_GET)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> CommandEMC.handle((CommandContext<CommandSourceStack>)ctx, ActionType.GET))));
    }

    private static Component getSourceName(CommandSourceStack source) {
        try {
            return source.m_81375_().m_5446_();
        }
        catch (CommandSyntaxException e) {
            return Lang.Commands.CONSOLE.translateColored(ChatFormatting.RED, new Object[0]);
        }
    }

    private static Component formatEMC(BigInteger value) {
        return Component.m_237115_((String)EMCFormat.formatForceShort(value)).m_6270_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)EMCFormat.formatForceLong(value))))).m_6270_(ColorStyle.GRAY);
    }

    private static boolean compareUUID(CommandSourceStack source, ServerPlayer player) {
        try {
            return source.m_81375_().m_20148_().equals(player.m_20148_());
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }

    private static void sendSuccess(CommandSourceStack source, Component message, boolean notify) {
        source.m_288197_(() -> message, notify);
    }

    private static int handle(CommandContext<CommandSourceStack> ctx, ActionType action) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(ctx, (String)"player");
        if (action == ActionType.GET) {
            IKnowledgeProvider provider = Util.getKnowledgeProvider((Player)player);
            if (provider == null) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Lang.FAILED_TO_GET_KNOWLEDGE_PROVIDER.translateColored(ChatFormatting.RED, new Object[]{player.m_5446_()}));
                return 0;
            }
            if (CommandEMC.compareUUID((CommandSourceStack)ctx.getSource(), player)) {
                CommandEMC.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.EMC_GET_SUCCESS_SELF.translate(new Object[]{CommandEMC.formatEMC(provider.getEmc())}), false);
            } else {
                CommandEMC.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.EMC_GET_SUCCESS.translate(new Object[]{CommandEMC.formatEMC(provider.getEmc())}), true);
            }
            return 1;
        }
        String val = StringArgumentType.getString(ctx, (String)"value");
        BigInteger value = null;
        try {
            value = new BigInteger(val);
            switch (action) {
                case ADD: {
                    if (value.compareTo(BigInteger.ZERO) >= 0) break;
                    action = ActionType.REMOVE;
                    value = value.abs();
                    break;
                }
                case REMOVE: {
                    if (value.compareTo(BigInteger.ZERO) >= 0) break;
                    action = ActionType.ADD;
                    value = value.abs();
                    break;
                }
                case SET: 
                case TEST: {
                    if (value.compareTo(BigInteger.ZERO) >= 0) break;
                    value = null;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (value == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Lang.Commands.EMC_INVALID.translateColored(ChatFormatting.RED, new Object[0]));
            return 0;
        }
        int response = 1;
        IKnowledgeProvider provider = Util.getKnowledgeProvider((Player)player);
        if (provider == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Lang.FAILED_TO_GET_KNOWLEDGE_PROVIDER.translateColored(ChatFormatting.RED, new Object[]{player.m_5446_()}));
            return 0;
        }
        BigInteger newEMC = provider.getEmc();
        switch (action) {
            case ADD: {
                newEMC = newEMC.add(value);
                if (CommandEMC.compareUUID((CommandSourceStack)ctx.getSource(), player)) {
                    CommandEMC.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.EMC_ADD_SUCCESS_SELF.translateColored(ChatFormatting.GREEN, new Object[]{CommandEMC.formatEMC(value), CommandEMC.formatEMC(newEMC)}), false);
                    break;
                }
                CommandEMC.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.EMC_ADD_SUCCESS.translateColored(ChatFormatting.GREEN, new Object[]{CommandEMC.formatEMC(value), player.m_5446_(), CommandEMC.formatEMC(newEMC)}), true);
                if (!((Boolean)Config.notifyCommandChanges.get()).booleanValue()) break;
                player.m_213846_((Component)Lang.Commands.EMC_ADD_NOTIFICATION.translate(new Object[]{CommandEMC.formatEMC(value), CommandEMC.getSourceName((CommandSourceStack)ctx.getSource()), CommandEMC.formatEMC(newEMC)}));
                break;
            }
            case REMOVE: {
                newEMC = newEMC.subtract(value);
                if (newEMC.compareTo(BigInteger.ZERO) < 0) {
                    ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Lang.Commands.EMC_REMOVE_NEGATIVE.translateColored(ChatFormatting.RED, new Object[]{CommandEMC.formatEMC(value), player.m_6302_()}));
                    return 0;
                }
                if (CommandEMC.compareUUID((CommandSourceStack)ctx.getSource(), player)) {
                    CommandEMC.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.EMC_REMOVE_SUCCESS_SELF.translateColored(ChatFormatting.GREEN, new Object[]{CommandEMC.formatEMC(value), CommandEMC.formatEMC(newEMC)}), false);
                    break;
                }
                CommandEMC.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.EMC_REMOVE_SUCCESS.translateColored(ChatFormatting.GREEN, new Object[]{CommandEMC.formatEMC(value), player.m_6302_(), CommandEMC.formatEMC(newEMC)}), true);
                if (!((Boolean)Config.notifyCommandChanges.get()).booleanValue()) break;
                player.m_213846_((Component)Lang.Commands.EMC_REMOVE_NOTIFICATION.translate(new Object[]{CommandEMC.formatEMC(value), CommandEMC.getSourceName((CommandSourceStack)ctx.getSource()), CommandEMC.formatEMC(newEMC)}));
                break;
            }
            case SET: {
                newEMC = value;
                if (CommandEMC.compareUUID((CommandSourceStack)ctx.getSource(), player)) {
                    CommandEMC.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.EMC_SET_SUCCESS_SELF.translateColored(ChatFormatting.GREEN, new Object[]{CommandEMC.formatEMC(value), CommandEMC.formatEMC(newEMC)}), false);
                    break;
                }
                CommandEMC.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.EMC_SET_SUCCESS.translateColored(ChatFormatting.GREEN, new Object[]{player.m_5446_(), CommandEMC.formatEMC(newEMC)}), true);
                if (!((Boolean)Config.notifyCommandChanges.get()).booleanValue()) break;
                player.m_213846_((Component)Lang.Commands.EMC_REMOVE_SUCCESS.translate(new Object[]{CommandEMC.formatEMC(newEMC), CommandEMC.getSourceName((CommandSourceStack)ctx.getSource())}));
                break;
            }
            case TEST: {
                boolean canTake;
                boolean bl = canTake = newEMC.compareTo(value) > -1;
                if (CommandEMC.compareUUID((CommandSourceStack)ctx.getSource(), player)) {
                    if (canTake) {
                        CommandEMC.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.EMC_TEST_SUCCESS_SELF.translateColored(ChatFormatting.GREEN, new Object[]{CommandEMC.formatEMC(value)}), false);
                        break;
                    }
                    response = 0;
                    ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Lang.Commands.EMC_TEST_FAIL_SELF.translateColored(ChatFormatting.RED, new Object[]{CommandEMC.formatEMC(value)}));
                    break;
                }
                if (canTake) {
                    CommandEMC.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.EMC_TEST_SUCCESS.translateColored(ChatFormatting.GREEN, new Object[]{player.m_6302_(), CommandEMC.formatEMC(value)}), false);
                    break;
                }
                response = 0;
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Lang.Commands.KNOWLEDGE_TEST_FAIL_SELF.translateColored(ChatFormatting.RED, new Object[]{player.m_6302_(), CommandEMC.formatEMC(value)}));
            }
        }
        if (response == 1 && action != ActionType.TEST) {
            provider.setEmc(newEMC);
            provider.syncEmc(player);
        }
        return response;
    }

    private static enum ActionType {
        ADD,
        REMOVE,
        SET,
        GET,
        TEST;

    }
}

