/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import cool.furry.mc.forge.projectexpansion.Main;
import cool.furry.mc.forge.projectexpansion.capability.CapabilityAlchemicalBookLocations;
import cool.furry.mc.forge.projectexpansion.capability.IAlchemicalBookLocationsProvider;
import cool.furry.mc.forge.projectexpansion.commands.CommandRegistry;
import cool.furry.mc.forge.projectexpansion.commands.Permissions;
import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.item.ItemAlchemicalBook;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.TagNames;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CommandBook {
    public static LiteralArgumentBuilder<CommandSourceStack> getArguments() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"book").requires((Predicate)Permissions.BOOK)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"add").requires((Predicate)Permissions.BOOK_ADD)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"player").requires((Predicate)Permissions.BOOK_ADD_PLAYER)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> CommandBook.handleAdd((CommandContext<CommandSourceStack>)ctx, new BookTarget((CommandContext<CommandSourceStack>)ctx))))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"hand").requires((Predicate)Permissions.BOOK_ADD_HAND)).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> CommandBook.handleAdd((CommandContext<CommandSourceStack>)ctx, new BookTarget((CommandContext<CommandSourceStack>)ctx))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").requires((Predicate)Permissions.BOOK_CLEAR)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"player").requires((Predicate)Permissions.BOOK_CLEAR_PLAYER)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> CommandBook.handleClear((CommandContext<CommandSourceStack>)ctx, new BookTarget((CommandContext<CommandSourceStack>)ctx)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"hand").requires((Predicate)Permissions.BOOK_CLEAR_HAND)).executes(ctx -> CommandBook.handleClear((CommandContext<CommandSourceStack>)ctx, new BookTarget((CommandContext<CommandSourceStack>)ctx)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dump").requires((Predicate)Permissions.BOOK_DUMP)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"player").requires((Predicate)Permissions.BOOK_DUMP_PLAYER)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> CommandBook.handleDump((CommandContext<CommandSourceStack>)ctx, new BookTarget((CommandContext<CommandSourceStack>)ctx)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"hand").requires((Predicate)Permissions.BOOK_DUMP_HAND)).executes(ctx -> CommandBook.handleDump((CommandContext<CommandSourceStack>)ctx, new BookTarget((CommandContext<CommandSourceStack>)ctx)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"list").requires((Predicate)Permissions.BOOK_LIST)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"player").requires((Predicate)Permissions.BOOK_LIST_PLAYER)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> CommandBook.handleList((CommandContext<CommandSourceStack>)ctx, new BookTarget((CommandContext<CommandSourceStack>)ctx)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"hand").requires((Predicate)Permissions.BOOK_LIST_HAND)).executes(ctx -> CommandBook.handleList((CommandContext<CommandSourceStack>)ctx, new BookTarget((CommandContext<CommandSourceStack>)ctx)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires((Predicate)Permissions.BOOK_REMOVE)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"player").requires((Predicate)Permissions.BOOK_REMOVE_PLAYER)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"location", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandBook.handleRemove((CommandContext<CommandSourceStack>)ctx, new BookTarget((CommandContext<CommandSourceStack>)ctx))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"hand").requires((Predicate)Permissions.BOOK_REMOVE_HAND)).then(Commands.m_82129_((String)"location", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandBook.handleRemove((CommandContext<CommandSourceStack>)ctx, new BookTarget((CommandContext<CommandSourceStack>)ctx))))));
    }

    @Nullable
    private static IAlchemicalBookLocationsProvider getCapability(CommandContext<CommandSourceStack> ctx, BookTarget target, String commandSource) throws CommandSyntaxException {
        IAlchemicalBookLocationsProvider provider;
        try {
            if (target.isPlayer()) {
                provider = CapabilityAlchemicalBookLocations.fromPlayer((Player)target.playerOrException());
            } else {
                ItemAlchemicalBook book;
                ItemStack stack = target.itemStackOrException();
                provider = CapabilityAlchemicalBookLocations.fromItemStack(stack);
                Item item = stack.m_41720_();
                if (item instanceof ItemAlchemicalBook && (book = (ItemAlchemicalBook)item).getMode(stack) == ItemAlchemicalBook.Mode.PLAYER) {
                    ServerPlayer player = book.getPlayer(target.itemStackOrException());
                    MutableComponent playerDisplay = player == null ? Component.m_237113_((String)target.itemStackOrException().m_41784_().m_128461_(TagNames.OWNER_NAME)).m_130940_(ChatFormatting.DARK_AQUA) : player.m_5446_().m_6881_().m_130940_(ChatFormatting.DARK_AQUA);
                    MutableComponent command = Component.m_237113_((String)String.format("/%s book %s player %s", CommandRegistry.COMMAND_BASE, commandSource, playerDisplay.getString())).m_130938_(arg_0 -> CommandBook.lambda$getCapability$10(commandSource, (Component)playerDisplay, arg_0));
                    ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Lang.Commands.BOOK_BOUND_TO_PLAYER.extendColored(commandSource, ChatFormatting.RED, playerDisplay, command));
                }
            }
        }
        catch (IllegalStateException e) {
            ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Lang.Commands.BOOK_FAILED_TO_GET_CAPABILITY.translateColored(ChatFormatting.RED, new Object[0]));
            Main.Logger.error("Failed to get capability:");
            Main.Logger.error((Object)e);
            return null;
        }
        return provider;
    }

    private static Component getSourceName(CommandSourceStack source) {
        try {
            return source.m_81375_().m_5446_();
        }
        catch (CommandSyntaxException e) {
            return Lang.Commands.CONSOLE.translateColored(ChatFormatting.RED, new Object[0]);
        }
    }

    private static void sendSuccess(CommandSourceStack source, Component message, boolean notify) {
        source.m_288197_(() -> message, notify);
    }

    private static int handleDump(CommandContext<CommandSourceStack> ctx, BookTarget target) throws CommandSyntaxException {
        IAlchemicalBookLocationsProvider provider = CommandBook.getCapability(ctx, target, "dump");
        if (provider == null) {
            return 0;
        }
        if (provider.getLocations().isEmpty()) {
            CommandBook.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.BOOK_EMPTY.translateColored(ChatFormatting.GREEN, new Object[0]), false);
            return 0;
        }
        String content = ((CompoundTag)provider.serializeNBT()).toString();
        CommandBook.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Component.m_237113_((String)content).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, content)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Lang.Commands.BOOK_CLICK_TO_COPY.translateColored(ChatFormatting.AQUA, new Object[0])))).m_130940_(ChatFormatting.GRAY), false);
        return 1;
    }

    private static Style suggestTeleportPos(CommandContext<CommandSourceStack> ctx, Style style, CapabilityAlchemicalBookLocations.TeleportLocation location) {
        boolean isSameDimension = Objects.requireNonNull(((CommandSourceStack)ctx.getSource()).m_230896_()).m_9236_().m_46472_().equals(location.dimension());
        if (isSameDimension) {
            return Util.suggestCommand(style, String.format("/tp %s %s %s", location.x(), location.y(), location.z())).m_131162_(Boolean.valueOf(true));
        }
        return Util.suggestCommand(style, String.format("/execute in %s run tp %s %s %s", location.dimension().m_135782_(), location.x(), location.y(), location.z())).m_131162_(Boolean.valueOf(true));
    }

    private static Style suggestTeleportDimension(CommandContext<CommandSourceStack> ctx, Style style, CapabilityAlchemicalBookLocations.TeleportLocation location) {
        boolean isSameDimension = Objects.requireNonNull(((CommandSourceStack)ctx.getSource()).m_230896_()).m_9236_().m_46472_().equals(location.dimension());
        if (!isSameDimension) {
            return Util.suggestCommand(style, String.format("/execute in %s run tp ~ ~ ~", location.dimension().m_135782_())).m_131162_(Boolean.valueOf(true));
        }
        return style;
    }

    private static Component formatLocation(CommandContext<CommandSourceStack> ctx, CapabilityAlchemicalBookLocations.TeleportLocation location) {
        boolean shouldSuggestCommand = ((CommandSourceStack)ctx.getSource()).m_230896_() != null;
        MutableComponent pos = Component.m_237113_((String)String.format("%s %s %s", location.x(), location.y(), location.z())).m_130938_(style -> shouldSuggestCommand ? CommandBook.suggestTeleportPos(ctx, style, location) : style).m_130940_(ChatFormatting.DARK_AQUA);
        MutableComponent dimension = Component.m_237113_((String)location.dimension().m_135782_().toString()).m_130938_(style -> shouldSuggestCommand ? CommandBook.suggestTeleportDimension(ctx, style, location) : style).m_130940_(ChatFormatting.DARK_AQUA);
        return Lang.Commands.BOOK_LIST_LOCATION.translateColored(ChatFormatting.AQUA, new Object[]{Component.m_237113_((String)location.name()).m_130940_(ChatFormatting.DARK_AQUA), pos, dimension});
    }

    private static int handleList(CommandContext<CommandSourceStack> ctx, BookTarget target) throws CommandSyntaxException {
        IAlchemicalBookLocationsProvider provider = CommandBook.getCapability(ctx, target, "list");
        if (provider == null) {
            return 0;
        }
        if (provider.getLocations().isEmpty()) {
            CommandBook.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.BOOK_EMPTY.translateColored(ChatFormatting.GREEN, new Object[0]), false);
            return 0;
        }
        for (CapabilityAlchemicalBookLocations.TeleportLocation location : provider.getLocations()) {
            ((CommandSourceStack)ctx.getSource()).m_243053_(CommandBook.formatLocation(ctx, location));
        }
        return 1;
    }

    private static int handleClear(CommandContext<CommandSourceStack> ctx, BookTarget target) throws CommandSyntaxException {
        IAlchemicalBookLocationsProvider provider = CommandBook.getCapability(ctx, target, "clear");
        if (provider == null) {
            return 0;
        }
        List locations = provider.getLocations().stream().toList();
        if (locations.isEmpty()) {
            CommandBook.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.BOOK_EMPTY.translateColored(ChatFormatting.RED, new Object[0]), false);
            return 0;
        }
        provider.resetLocations();
        if (provider.getMode() == ItemAlchemicalBook.Mode.PLAYER) {
            provider.syncToOtherPlayers();
            ServerPlayer sourcePlayer = ((CommandSourceStack)ctx.getSource()).m_230896_();
            ServerPlayer targetPlayer = target.playerOrException();
            if (sourcePlayer != null && sourcePlayer.m_20148_().equals(targetPlayer.m_20148_())) {
                ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Lang.Commands.BOOK_CLEAR_PLAYER_SUCCESS_SELF.translateColored(ChatFormatting.GREEN, new Object[0]));
                return 1;
            }
            if (((Boolean)Config.notifyCommandChanges.get()).booleanValue()) {
                target.playerOrException().m_240418_((Component)Lang.Commands.BOOK_CLEAR_PLAYER_NOTIFICATION.translate(new Object[]{CommandBook.getSourceName((CommandSourceStack)ctx.getSource())}), false);
            }
            ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Lang.Commands.BOOK_CLEAR_PLAYER_SUCCESS.translateColored(ChatFormatting.GREEN, new Object[]{targetPlayer.m_5446_().m_6881_().m_130940_(ChatFormatting.DARK_AQUA)}));
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Lang.Commands.BOOK_CLEAR_ITEMSTACK_SUCCESS.translateColored(ChatFormatting.GREEN, new Object[0]));
        return 1;
    }

    private static int handleRemove(CommandContext<CommandSourceStack> ctx, BookTarget target) throws CommandSyntaxException {
        CapabilityAlchemicalBookLocations.TeleportLocation location;
        IAlchemicalBookLocationsProvider provider = CommandBook.getCapability(ctx, target, "remove");
        if (provider == null) {
            return 0;
        }
        String name = StringArgumentType.getString(ctx, (String)"location");
        try {
            location = provider.getLocationOrThrow(name);
            if (location.isBack()) {
                CommandBook.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.BOOK_REMOVE_INTERNAL_LOCATION.translateColored(ChatFormatting.RED, new Object[0]), false);
                return 0;
            }
            provider.removeLocation(name);
        }
        catch (CapabilityAlchemicalBookLocations.BookError.NameNotFoundError ignore) {
            CommandBook.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.BOOK_REMOVE_INVALID_LOCATION.translateColored(ChatFormatting.RED, new Object[0]), false);
            return 0;
        }
        ((CommandSourceStack)ctx.getSource()).m_243053_(CommandBook.formatLocation(ctx, location));
        if (provider.getMode() == ItemAlchemicalBook.Mode.PLAYER) {
            provider.syncToOtherPlayers();
            ServerPlayer sourcePlayer = ((CommandSourceStack)ctx.getSource()).m_230896_();
            ServerPlayer targetPlayer = target.playerOrException();
            if (sourcePlayer != null && sourcePlayer.m_20148_().equals(targetPlayer.m_20148_())) {
                ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Lang.Commands.BOOK_REMOVE_PLAYER_SUCCESS_SELF.translateColored(ChatFormatting.GREEN, new Object[0]));
                return 1;
            }
            if (((Boolean)Config.notifyCommandChanges.get()).booleanValue()) {
                target.playerOrException().m_240418_((Component)Lang.Commands.BOOK_REMOVE_PLAYER_NOTIFICATION.translate(new Object[]{name, CommandBook.getSourceName((CommandSourceStack)ctx.getSource())}), false);
            }
            ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Lang.Commands.BOOK_REMOVE_PLAYER_SUCCESS.translateColored(ChatFormatting.GREEN, new Object[]{targetPlayer.m_5446_().m_6881_().m_130940_(ChatFormatting.DARK_AQUA)}));
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Lang.Commands.BOOK_REMOVE_ITEMSTACK_SUCCESS.translateColored(ChatFormatting.GREEN, new Object[0]));
        return 1;
    }

    private static int handleAdd(CommandContext<CommandSourceStack> ctx, BookTarget target) throws CommandSyntaxException {
        IAlchemicalBookLocationsProvider provider = CommandBook.getCapability(ctx, target, "remove");
        if (provider == null) {
            return 0;
        }
        BlockPos pos = BlockPosArgument.m_174395_(ctx, (String)"pos");
        ServerLevel dimension = DimensionArgument.m_88808_(ctx, (String)"dimension");
        String name = StringArgumentType.getString(ctx, (String)"name");
        if (CapabilityAlchemicalBookLocations.isForbiddenName(name)) {
            CommandBook.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.BOOK_ADD_INVALID_NAME.translateColored(ChatFormatting.RED, new Object[0]), false);
            return 0;
        }
        try {
            provider.addLocation(name, GlobalPos.m_122643_((ResourceKey)dimension.m_46472_(), (BlockPos)pos));
        }
        catch (CapabilityAlchemicalBookLocations.BookError.DuplicateNameError e) {
            CommandBook.sendSuccess((CommandSourceStack)ctx.getSource(), (Component)Lang.Commands.BOOK_ADD_DUPLICATE_NAME.translateColored(ChatFormatting.RED, new Object[0]), false);
            return 0;
        }
        if (provider.getMode() == ItemAlchemicalBook.Mode.PLAYER) {
            provider.syncToOtherPlayers();
            ServerPlayer sourcePlayer = ((CommandSourceStack)ctx.getSource()).m_230896_();
            ServerPlayer targetPlayer = target.playerOrException();
            if (sourcePlayer != null && sourcePlayer.m_20148_().equals(targetPlayer.m_20148_())) {
                ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Lang.Commands.BOOK_ADD_PLAYER_SUCCESS_SELF.translateColored(ChatFormatting.GREEN, new Object[0]));
                return 1;
            }
            if (((Boolean)Config.notifyCommandChanges.get()).booleanValue()) {
                target.playerOrException().m_240418_((Component)Lang.Commands.BOOK_ADD_PLAYER_NOTIFICATION.translateColored(ChatFormatting.GREEN, new Object[]{name, CommandBook.getSourceName((CommandSourceStack)ctx.getSource())}), false);
            }
            ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Lang.Commands.BOOK_ADD_PLAYER_SUCCESS.translateColored(ChatFormatting.GREEN, new Object[]{targetPlayer.m_5446_().m_6881_().m_130940_(ChatFormatting.DARK_AQUA)}));
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Lang.Commands.BOOK_ADD_ITEMSTACK_SUCCESS.translateColored(ChatFormatting.GREEN, new Object[0]));
        return 1;
    }

    private static /* synthetic */ Style lambda$getCapability$10(String commandSource, Component playerDisplay, Style style) {
        return style.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, String.format("/%s book %s player %s", CommandRegistry.COMMAND_BASE, commandSource, playerDisplay.getString()))).m_131140_(ChatFormatting.RED);
    }

    public static class BookTarget {
        private final CommandContext<CommandSourceStack> ctx;
        @Nullable
        private final ServerPlayer player;

        public BookTarget(CommandContext<CommandSourceStack> ctx) {
            ServerPlayer playerArg;
            try {
                playerArg = EntityArgument.m_91474_(ctx, (String)"player");
            }
            catch (CommandSyntaxException | IllegalArgumentException e) {
                playerArg = null;
            }
            this.ctx = ctx;
            this.player = playerArg;
        }

        public boolean isItemStack() {
            return this.player == null;
        }

        public boolean isPlayer() {
            return this.player != null;
        }

        @Nullable
        public ServerPlayer player() {
            return this.player;
        }

        public ServerPlayer playerOrException() {
            if (this.player == null) {
                throw new NullPointerException("Player is null");
            }
            return this.player;
        }

        @Nullable
        public ItemStack itemStack() {
            ServerPlayer executor;
            try {
                executor = ((CommandSourceStack)this.ctx.getSource()).m_81375_();
            }
            catch (CommandSyntaxException e) {
                return null;
            }
            ItemStack stack = executor.m_21205_();
            if (stack.m_41619_() || !(stack.m_41720_() instanceof ItemAlchemicalBook)) {
                return null;
            }
            return stack;
        }

        public ItemStack itemStackOrException() throws CommandSyntaxException {
            ServerPlayer executor;
            try {
                executor = ((CommandSourceStack)this.ctx.getSource()).m_81375_();
            }
            catch (CommandSyntaxException e) {
                throw new SimpleCommandExceptionType((Message)Lang.Commands.PLAYER_ONLY.translate(new Object[0])).create();
            }
            ItemStack stack = executor.m_21205_();
            if (stack.m_41619_() || !(stack.m_41720_() instanceof ItemAlchemicalBook)) {
                throw new SimpleCommandExceptionType((Message)Lang.Commands.BOOK_INVALID_HAND_ITEM.translate(new Object[0])).create();
            }
            return stack;
        }
    }
}

