/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.capability;

import com.google.common.collect.ImmutableList;
import cool.furry.mc.forge.projectexpansion.Main;
import cool.furry.mc.forge.projectexpansion.capability.IAlchemicalBookLocationsProvider;
import cool.furry.mc.forge.projectexpansion.item.ItemAlchemicalBook;
import cool.furry.mc.forge.projectexpansion.net.PacketHandler;
import cool.furry.mc.forge.projectexpansion.net.packets.to_client.PacketSyncAlchemicalBookLocations;
import cool.furry.mc.forge.projectexpansion.registries.Capabilities;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.TagNames;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import moze_intel.projecte.capability.managing.ICapabilityResolver;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapabilityAlchemicalBookLocations
implements IAlchemicalBookLocationsProvider {
    public static final int BASIC_DISTANCE_RATIO = 1000;
    public static final int ADVANCED_DISTANCE_RATIO = 500;
    public static final int MASTER_DISTANCE_RATIO = 100;
    public static final int ARCANE_DISTANCE_RATIO = 0;
    private final ItemAlchemicalBook.Mode mode;
    @Nullable
    private final ServerPlayer player;
    @Nullable
    private final ItemStack itemStack;
    private final HashMap<String, TeleportLocation> locations = new HashMap();
    private static final String BACK_KEY = "@back";

    private CapabilityAlchemicalBookLocations(ItemAlchemicalBook.Mode mode, @Nullable ServerPlayer player, @Nullable ItemStack itemStack) {
        this.mode = mode;
        this.player = player;
        this.itemStack = itemStack;
    }

    public static IAlchemicalBookLocationsProvider fromPlayer(Player player) {
        return (IAlchemicalBookLocationsProvider)player.getCapability(Capabilities.ALCHEMICAL_BOOK_LOCATIONS).orElseThrow(() -> new IllegalStateException("Player does not have expected capability"));
    }

    public static IAlchemicalBookLocationsProvider fromItemStack(ItemStack stack) {
        return (IAlchemicalBookLocationsProvider)stack.getCapability(Capabilities.ALCHEMICAL_BOOK_LOCATIONS).orElseThrow(() -> new IllegalStateException("ItemStack does not have expected capability"));
    }

    public static IAlchemicalBookLocationsProvider from(ItemStack stack) throws BookError.OwnerOfflineError {
        Item item = stack.m_41720_();
        if (!(item instanceof ItemAlchemicalBook)) {
            throw new IllegalArgumentException("ItemStack is not an alchemical book");
        }
        ItemAlchemicalBook book = (ItemAlchemicalBook)item;
        if (book.getMode(stack) == ItemAlchemicalBook.Mode.PLAYER) {
            ServerPlayer owner = book.getPlayer(stack);
            if (owner == null) {
                throw new BookError.OwnerOfflineError(stack.m_41784_().m_128461_(TagNames.OWNER_NAME));
            }
            return CapabilityAlchemicalBookLocations.fromPlayer((Player)owner);
        }
        return CapabilityAlchemicalBookLocations.fromItemStack(stack);
    }

    public static boolean isForbiddenName(String name) {
        return name.equalsIgnoreCase(BACK_KEY);
    }

    public static IAlchemicalBookLocationsProvider getDefault(ItemAlchemicalBook.Mode mode, @Nullable ServerPlayer player, @Nullable ItemStack itemStack) {
        return new CapabilityAlchemicalBookLocations(mode, player, itemStack);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.locations.forEach((name, location) -> nbt.m_128365_(name, (Tag)location.serialize()));
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.locations.clear();
        nbt.m_128431_().forEach(name -> this.locations.put((String)name, TeleportLocation.deserialize(nbt.m_128469_(name))));
    }

    @Override
    public ImmutableList<TeleportLocation> getLocations() {
        return (ImmutableList)this.locations.values().stream().sorted(Comparator.comparingInt(TeleportLocation::index)).collect(ImmutableList.toImmutableList());
    }

    @Override
    public void addLocation(String name, GlobalPos pos) throws BookError.DuplicateNameError {
        if (this.locations.containsKey(name) && !name.equals(BACK_KEY)) {
            throw new BookError.DuplicateNameError(name);
        }
        int index = this.locations.size();
        if (name.equals(BACK_KEY)) {
            index = -1;
        } else if (this.locations.containsKey(BACK_KEY)) {
            --index;
        }
        TeleportLocation location = TeleportLocation.from(name, pos, index);
        this.locations.put(name, location);
    }

    @Override
    public void addLocation(Player player, String name) throws BookError.DuplicateNameError {
        this.addLocation(name, GlobalPos.m_122643_((ResourceKey)player.m_9236_().m_46472_(), (BlockPos)player.m_20183_()));
    }

    @Override
    public void removeLocation(String name) throws BookError.NameNotFoundError {
        if (!this.locations.containsKey(name)) {
            throw new BookError.NameNotFoundError(name);
        }
        int index = this.locations.get(name).index();
        this.locations.remove(name);
        if (index < 0 || name.equals(BACK_KEY)) {
            return;
        }
        this.locations.forEach((loc, location) -> {
            if (location.index() < index) {
                return;
            }
            this.locations.replace((String)loc, location.withIndex(location.index() - 1));
        });
    }

    @Override
    public void saveBackLocation(Player player, GlobalPos pos) {
        try {
            if (this.locations.containsKey(BACK_KEY)) {
                this.removeLocation(BACK_KEY);
            }
            this.addLocation(BACK_KEY, pos);
            this.sync((ServerPlayer)player);
        }
        catch (BookError.DuplicateNameError | BookError.NameNotFoundError e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void saveBackLocation(Player player) {
        this.saveBackLocation(player, GlobalPos.m_122643_((ResourceKey)player.m_9236_().m_46472_(), (BlockPos)player.m_20183_()));
    }

    @Override
    @Nullable
    public TeleportLocation getBackLocation() {
        if (!this.locations.containsKey(BACK_KEY)) {
            return null;
        }
        return this.locations.get(BACK_KEY);
    }

    @Override
    public TeleportLocation getBackLocationOrThrow() throws BookError.NoBackLocationError {
        TeleportLocation location = this.getBackLocation();
        if (location == null) {
            throw new BookError.NoBackLocationError();
        }
        return location;
    }

    @Override
    public void teleportBack(ServerPlayer player, boolean acrossDimensions) throws BookError.NoBackLocationError, BookError.WrongDimensionError, BookError.DimensionNotFoundError {
        @Nullable TeleportLocation backLocation = this.getBackLocation();
        if (backLocation == null) {
            throw new BookError.NoBackLocationError();
        }
        ResourceKey dim = player.m_9236_().m_46472_();
        ServerLevel level = Util.getDimension(backLocation.dimension());
        if (level == null) {
            throw new BookError.DimensionNotFoundError(backLocation.dimension());
        }
        if (!dim.equals(backLocation.dimension()) && !acrossDimensions) {
            throw new BookError.WrongDimensionError();
        }
        try {
            this.removeLocation(BACK_KEY);
        }
        catch (BookError.NameNotFoundError e) {
            throw new RuntimeException(e);
        }
        this.sync(player);
        backLocation.teleportTo(player, acrossDimensions);
    }

    @Override
    public void teleportTo(String name, ServerPlayer player, boolean acrossDimensions) throws BookError.NameNotFoundError, BookError.WrongDimensionError, BookError.DimensionNotFoundError {
        GlobalPos pos = GlobalPos.m_122643_((ResourceKey)player.m_9236_().m_46472_(), (BlockPos)player.m_20183_());
        this.getLocationOrThrow(name).teleportTo(player, acrossDimensions);
        this.saveBackLocation((Player)player, pos);
    }

    @Override
    @Nullable
    public TeleportLocation getLocation(String name) {
        return this.locations.get(name);
    }

    @Override
    public TeleportLocation getLocationOrThrow(String name) throws BookError.NameNotFoundError {
        @Nullable TeleportLocation location = this.getLocation(name);
        if (location == null) {
            throw new BookError.NameNotFoundError(name);
        }
        return location;
    }

    @Override
    public void resetLocations() {
        this.locations.clear();
    }

    @Override
    public void sync(ServerPlayer player) {
        boolean canEdit = false;
        if (this.player != null) {
            canEdit = ItemAlchemicalBook.canEdit(player, this.player);
        } else if (this.itemStack != null) {
            canEdit = ItemAlchemicalBook.canEdit(this.itemStack, player);
        }
        PacketHandler.sendTo(new PacketSyncAlchemicalBookLocations((List<TeleportLocation>)this.getLocations(), canEdit), player);
    }

    @Override
    public ItemAlchemicalBook.Mode getMode() {
        return this.mode;
    }

    @Override
    @Nullable
    public ServerPlayer getPlayer() {
        return this.player;
    }

    @Override
    public ServerPlayer getPlayerOrException() {
        if (this.player == null) {
            throw new NullPointerException("Player is null");
        }
        return this.player;
    }

    @Override
    @Nullable
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Override
    public ItemStack getItemStackOrException() {
        if (this.itemStack == null) {
            throw new NullPointerException("ItemStack is null");
        }
        return this.itemStack;
    }

    @Override
    public void syncToOtherPlayers() {
        if (this.player == null) {
            return;
        }
        for (String playerName : ServerLifecycleHooks.getCurrentServer().m_7641_()) {
            ServerPlayer target = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(playerName);
            if (target == null) continue;
            this.syncToPlayer(target);
        }
    }

    @Override
    public void syncToPlayer(ServerPlayer target) {
        ServerPlayer stackOwner;
        ItemAlchemicalBook book;
        if (this.player == null) {
            return;
        }
        ItemStack stack = target.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof ItemAlchemicalBook && (book = (ItemAlchemicalBook)item).getMode(stack) == ItemAlchemicalBook.Mode.PLAYER && this.player.equals((Object)(stackOwner = book.getPlayer(stack)))) {
            CapabilityAlchemicalBookLocations.fromPlayer((Player)this.player).sync(target);
        }
    }

    @Override
    public void ensureEditable(ServerPlayer editor) throws BookError.EditNotAllowedError {
        if (this.player != null && !ItemAlchemicalBook.canEdit(editor, this.player)) {
            throw new BookError.EditNotAllowedError();
        }
    }

    public static class BookError
    extends Exception {
        private final Type type;

        public BookError(Type type) {
            super("Book error: " + type.name());
            this.type = type;
        }

        protected String getKey() {
            return this.type.name().toLowerCase();
        }

        public Type getType() {
            return this.type;
        }

        public MutableComponent getComponent() {
            return Lang.Items.ALCHEMICAL_BOOK_ERROR.extendColored(this.getKey(), ChatFormatting.RED, new Object[0]);
        }

        public static enum Type {
            WRONG_DIMENSION,
            DIMENSION_NOT_FOUND,
            NO_BACK_LOCATION,
            NOT_ENOUGH_EMC,
            DUPLICATE_NAME,
            NAME_NOT_FOUND,
            OWNER_OFFLINE,
            EDIT_NOT_ALLOWED;

        }

        public static class EditNotAllowedError
        extends BookError {
            public EditNotAllowedError() {
                super(Type.EDIT_NOT_ALLOWED);
            }
        }

        public static class NotEnoughEMCError
        extends BookError {
            private final String emc;

            public NotEnoughEMCError(String emc) {
                super(Type.NOT_ENOUGH_EMC);
                this.emc = emc;
            }

            @Override
            public MutableComponent getComponent() {
                return Lang.Items.ALCHEMICAL_BOOK_ERROR.extendColored(this.getKey(), ChatFormatting.RED, this.emc);
            }
        }

        public static class OwnerOfflineError
        extends BookError {
            private final Component player;

            public OwnerOfflineError(Component name) {
                super(Type.OWNER_OFFLINE);
                this.player = name;
            }

            public OwnerOfflineError(String name) {
                this((Component)Component.m_237113_((String)name));
            }

            @Override
            public MutableComponent getComponent() {
                return Lang.Items.ALCHEMICAL_BOOK_ERROR.extendColored(this.getKey(), ChatFormatting.RED, this.player);
            }
        }

        public static class NameNotFoundError
        extends BookError {
            private final Component name;

            public NameNotFoundError(Component name) {
                super(Type.NAME_NOT_FOUND);
                this.name = name;
            }

            public NameNotFoundError(String name) {
                this((Component)Component.m_237113_((String)name));
            }

            @Override
            public MutableComponent getComponent() {
                return Lang.Items.ALCHEMICAL_BOOK_ERROR.extendColored(this.getKey(), ChatFormatting.RED, this.name);
            }
        }

        public static class DuplicateNameError
        extends BookError {
            private final Component name;

            public DuplicateNameError(Component name) {
                super(Type.DUPLICATE_NAME);
                this.name = name;
            }

            public DuplicateNameError(String name) {
                this((Component)Component.m_237113_((String)name));
            }

            @Override
            public MutableComponent getComponent() {
                return Lang.Items.ALCHEMICAL_BOOK_ERROR.extendColored(this.getKey(), ChatFormatting.RED, this.name);
            }
        }

        public static class NoBackLocationError
        extends BookError {
            public NoBackLocationError() {
                super(Type.NO_BACK_LOCATION);
            }
        }

        public static class DimensionNotFoundError
        extends BookError {
            private final Component name;

            public DimensionNotFoundError(Component name) {
                super(Type.DIMENSION_NOT_FOUND);
                this.name = name;
            }

            public DimensionNotFoundError(ResourceKey<Level> level) {
                this((Component)Component.m_237115_((String)level.m_135782_().m_214298_()));
            }

            public DimensionNotFoundError(String name) {
                this((Component)Component.m_237113_((String)name));
            }

            @Override
            public MutableComponent getComponent() {
                return Lang.Items.ALCHEMICAL_BOOK_ERROR.extendColored(this.getKey(), ChatFormatting.RED, this.name);
            }
        }

        public static class WrongDimensionError
        extends BookError {
            public WrongDimensionError() {
                super(Type.WRONG_DIMENSION);
            }
        }
    }

    public record TeleportLocation(String name, int x, int y, int z, ResourceKey<Level> dimension, int index) {
        public void teleportTo(ServerPlayer player, boolean acrossDimensions) throws BookError.DimensionNotFoundError, BookError.WrongDimensionError {
            ResourceKey dim = player.m_9236_().m_46472_();
            ServerLevel level = Util.getDimension(this.dimension);
            if (level == null) {
                throw new BookError.DimensionNotFoundError(this.dimension);
            }
            if (!dim.equals(this.dimension) && !acrossDimensions) {
                throw new BookError.WrongDimensionError();
            }
            player.m_8999_(level, (double)this.x, (double)this.y, (double)this.z, player.m_146908_(), player.m_146909_());
        }

        public double distanceFrom(BlockPos pos) {
            return Math.sqrt(Math.pow(pos.m_123341_() - this.x, 2.0) + Math.pow(pos.m_123342_() - this.y, 2.0) + Math.pow(pos.m_123343_() - this.z, 2.0));
        }

        public int getCost(ItemStack stack, Player player) {
            if (player.m_7500_()) {
                return 0;
            }
            return this.getCost(stack, player.m_20097_());
        }

        public int getCost(ItemStack stack, BlockPos pos) {
            Item item = stack.m_41720_();
            if (!(item instanceof ItemAlchemicalBook)) {
                return (int)Math.ceil(this.distanceFrom(pos) * 1000.0);
            }
            ItemAlchemicalBook book = (ItemAlchemicalBook)item;
            return (int)Math.ceil(this.distanceFrom(pos) * (double)book.getTier().distanceRatio());
        }

        public TeleportLocation withIndex(int index) {
            return TeleportLocation.from(this.name, new BlockPos(this.x, this.y, this.z), this.dimension, index);
        }

        public boolean isBack() {
            return this.name.equals(CapabilityAlchemicalBookLocations.BACK_KEY);
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_(TagNames.NAME, this.name);
            tag.m_128405_(TagNames.X, this.x);
            tag.m_128405_(TagNames.Y, this.y);
            tag.m_128405_(TagNames.Z, this.z);
            tag.m_128405_(TagNames.INDEX, this.index);
            tag.m_128359_(TagNames.DIMENSION, this.dimension.m_135782_().toString());
            return tag;
        }

        public static TeleportLocation deserialize(CompoundTag tag) {
            String name = tag.m_128461_(TagNames.NAME);
            int x = tag.m_128451_(TagNames.X);
            int y = tag.m_128451_(TagNames.Y);
            int z = tag.m_128451_(TagNames.Z);
            int index = tag.m_128451_(TagNames.INDEX);
            ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_(TagNames.DIMENSION)));
            return new TeleportLocation(name, x, y, z, (ResourceKey<Level>)dimension, index);
        }

        public static TeleportLocation from(String name, GlobalPos pos, int index) {
            return TeleportLocation.from(name, pos.m_122646_(), (ResourceKey<Level>)pos.m_122640_(), index);
        }

        public static TeleportLocation from(String name, BlockPos pos, ResourceKey<Level> dimension, int index) {
            return new TeleportLocation(name, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), dimension, index);
        }
    }

    public static class Provider
    implements ICapabilityResolver<IAlchemicalBookLocationsProvider>,
    ICapabilitySerializable<CompoundTag> {
        @Nullable
        private LazyOptional<IAlchemicalBookLocationsProvider> cached;
        public static final ResourceLocation NAME = Main.rl("alchemical_book_locations");
        private final IAlchemicalBookLocationsProvider defaultImpl;
        @Nullable
        private final ServerPlayer player;
        @Nullable
        private final ItemStack itemStack;

        public Provider(ItemAlchemicalBook.Mode mode, @Nullable ServerPlayer player, @Nullable ItemStack itemStack) {
            this.defaultImpl = CapabilityAlchemicalBookLocations.getDefault(mode, player, itemStack);
            this.player = player;
            this.itemStack = itemStack;
        }

        @NotNull
        public Capability<IAlchemicalBookLocationsProvider> getMatchingCapability() {
            return Capabilities.ALCHEMICAL_BOOK_LOCATIONS;
        }

        @NotNull
        public <T> LazyOptional<T> getCapabilityUnchecked(@NotNull Capability<T> capability, @Nullable Direction direction) {
            if (this.cached == null || !this.cached.isPresent()) {
                this.cached = LazyOptional.of(() -> this.defaultImpl).cast();
            }
            return this.cached.cast();
        }

        public void invalidate(@NotNull Capability<?> capability, @Nullable Direction side) {
            this.invalidateAll();
        }

        public void invalidateAll() {
            if (this.cached != null && this.cached.isPresent()) {
                this.cached.invalidate();
                this.cached = null;
            }
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)this.defaultImpl.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.defaultImpl.deserializeNBT((Tag)nbt);
        }
    }
}

