/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.block.entity;

import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityNBTFilterable;
import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.registries.BlockEntityTypes;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.emc.nbt.NBTManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockEntityTransmutationInterface
extends BlockEntityNBTFilterable {
    private final LazyOptional<IItemHandler> itemHandlerCapability = LazyOptional.of(() -> new ItemHandler());
    private ItemInfo[] info;

    public BlockEntityTransmutationInterface(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityTypes.TRANSMUTATION_INTERFACE.get(), pos, state);
    }

    private ItemInfo[] fetchKnowledge() {
        if (this.info != null) {
            return this.info;
        }
        IKnowledgeProvider provider = Util.getKnowledgeProvider(this.owner);
        if (provider == null) {
            return new ItemInfo[0];
        }
        this.info = provider.getKnowledge().toArray(new ItemInfo[0]);
        return this.info;
    }

    private int getMaxCount(int slot) {
        IKnowledgeProvider provider = Util.getKnowledgeProvider(this.owner);
        if (provider == null) {
            return 0;
        }
        BigInteger playerEmc = provider.getEmc();
        if (playerEmc.compareTo(BigInteger.ZERO) < 1) {
            return 0;
        }
        BigInteger targetItemEmc = BigInteger.valueOf(IEMCProxy.INSTANCE.getValue(this.fetchKnowledge()[slot]));
        if (targetItemEmc.compareTo(BigInteger.ZERO) < 1) {
            return 0;
        }
        return playerEmc.divide(targetItemEmc).min(BigInteger.valueOf(Math.max(1, (Integer)Config.transmutationInterfaceItemCount.get()))).intValue();
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof BlockEntityTransmutationInterface) {
            BlockEntityTransmutationInterface be = (BlockEntityTransmutationInterface)blockEntity;
            be.tickServer(level, pos, state, be);
        }
    }

    public void tickServer(Level level, BlockPos pos, BlockState state, BlockEntityTransmutationInterface blockEntity) {
        this.info = null;
    }

    ItemHandler getItemHandlerCapability() {
        return (ItemHandler)this.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseThrow(NullPointerException::new);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == ForgeCapabilities.ITEM_HANDLER ? this.itemHandlerCapability.cast() : super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.itemHandlerCapability.invalidate();
    }

    private class ItemHandler
    implements IItemHandler {
        private ItemHandler() {
        }

        public int getSlots() {
            return BlockEntityTransmutationInterface.this.fetchKnowledge().length + 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            if (BlockEntityTransmutationInterface.this.owner == null || Util.getPlayer(BlockEntityTransmutationInterface.this.owner) == null) {
                return ItemStack.f_41583_;
            }
            BlockEntityTransmutationInterface.this.fetchKnowledge();
            if (slot <= 0 || BlockEntityTransmutationInterface.this.info.length < slot) {
                return ItemStack.f_41583_;
            }
            int maxCount = BlockEntityTransmutationInterface.this.getMaxCount(slot - 1);
            if (maxCount <= 0) {
                return ItemStack.f_41583_;
            }
            ItemStack item = BlockEntityTransmutationInterface.this.fetchKnowledge()[slot - 1].createStack();
            item.m_41764_(maxCount);
            return item;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (slot != 0 || BlockEntityTransmutationInterface.this.owner == null || !this.isItemValid(slot, stack) || stack.m_41619_() || Util.getPlayer(BlockEntityTransmutationInterface.this.owner) == null) {
                return stack;
            }
            ItemInfo info = ItemInfo.fromStack((ItemStack)stack);
            int count = stack.m_41613_();
            if (count <= 0) {
                return stack;
            }
            stack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
            if (BlockEntityTransmutationInterface.this.getFilterStatus() && !NBTManager.getPersistentInfo((ItemInfo)info).equals((Object)info)) {
                return stack;
            }
            if (simulate) {
                return ItemStack.f_41583_;
            }
            long emcValue = IEMCProxy.INSTANCE.getSellValue(stack);
            IKnowledgeProvider provider = Util.getKnowledgeProvider(BlockEntityTransmutationInterface.this.owner);
            if (provider == null) {
                return stack;
            }
            BigInteger totalEmcValue = BigInteger.valueOf(emcValue).multiply(BigInteger.valueOf(count));
            provider.setEmc(provider.getEmc().add(totalEmcValue));
            ServerPlayer player = Util.getPlayer(BlockEntityTransmutationInterface.this.f_58857_, BlockEntityTransmutationInterface.this.owner);
            if (player != null) {
                if (provider.addKnowledge(stack)) {
                    provider.syncKnowledgeChange(player, NBTManager.getPersistentInfo((ItemInfo)info), true);
                }
                provider.syncEmc(player);
            }
            return ItemStack.f_41583_;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot <= 0 || BlockEntityTransmutationInterface.this.owner == null || BlockEntityTransmutationInterface.this.fetchKnowledge().length < slot || Util.getPlayer(BlockEntityTransmutationInterface.this.owner) == null) {
                return ItemStack.f_41583_;
            }
            BlockEntityTransmutationInterface.this.fetchKnowledge();
            amount = Math.min(amount, BlockEntityTransmutationInterface.this.getMaxCount(slot - 1));
            if (amount <= 0) {
                return ItemStack.f_41583_;
            }
            ItemStack item = BlockEntityTransmutationInterface.this.fetchKnowledge()[slot - 1].createStack();
            item.m_41764_(amount);
            if (simulate) {
                return item;
            }
            long emcValue = IEMCProxy.INSTANCE.getValue(BlockEntityTransmutationInterface.this.fetchKnowledge()[slot - 1]);
            BigInteger totalEmcCost = BigInteger.valueOf(emcValue).multiply(BigInteger.valueOf(amount));
            IKnowledgeProvider provider = Util.getKnowledgeProvider(BlockEntityTransmutationInterface.this.owner);
            if (provider == null) {
                return ItemStack.f_41583_;
            }
            provider.setEmc(provider.getEmc().subtract(totalEmcCost));
            ServerPlayer player = Util.getPlayer(BlockEntityTransmutationInterface.this.f_58857_, BlockEntityTransmutationInterface.this.owner);
            if (player != null) {
                provider.syncEmc(player);
            }
            return item;
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0 && IEMCProxy.INSTANCE.hasValue(stack);
        }
    }
}

