/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.block.entity;

import cool.furry.mc.forge.projectexpansion.block.BlockCompactSun;
import cool.furry.mc.forge.projectexpansion.block.BlockPowerFlower;
import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityOwnable;
import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.registries.BlockEntityTypes;
import cool.furry.mc.forge.projectexpansion.util.IEmcStorageBigInteger;
import cool.furry.mc.forge.projectexpansion.util.IGeneratesEMC;
import cool.furry.mc.forge.projectexpansion.util.IHasMatter;
import cool.furry.mc.forge.projectexpansion.util.IHasSunBonus;
import cool.furry.mc.forge.projectexpansion.util.Matter;
import cool.furry.mc.forge.projectexpansion.util.PowerFlowerCollector;
import cool.furry.mc.forge.projectexpansion.util.TagNames;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.math.BigInteger;
import java.util.Objects;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BlockEntityPowerFlower
extends BlockEntityOwnable
implements IHasMatter,
IHasSunBonus,
IEmcStorageBigInteger,
IGeneratesEMC {
    public BigInteger emc = BigInteger.ZERO;

    public BlockEntityPowerFlower(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityTypes.POWER_FLOWER.get(), pos, state);
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_(TagNames.STORED_EMC, 8)) {
            this.emc = new BigInteger(tag.m_128461_(TagNames.STORED_EMC));
        }
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_(TagNames.STORED_EMC, this.emc.toString());
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof BlockEntityPowerFlower) {
            BlockEntityPowerFlower be = (BlockEntityPowerFlower)blockEntity;
            be.tickServer(level, pos, state, be);
        }
    }

    public void tickServer(Level level, BlockPos pos, BlockState state, BlockEntityPowerFlower blockEntity) {
        ServerPlayer player;
        if (level.f_46443_ || level.m_46467_() % (long)((Integer)Config.tickDelay.get()).intValue() != (long)Util.mod(this.hashCode(), (Integer)Config.tickDelay.get())) {
            return;
        }
        BigInteger res = this.getMatter().getPowerFlowerOutputForTicks((Integer)Config.tickDelay.get());
        if (this.hasSunBonus() && this.getSunBonus() != null) {
            res = res.multiply(BigInteger.valueOf(this.getSunBonus().intValue()));
        }
        if ((player = Util.getPlayer(level, this.owner)) != null) {
            PowerFlowerCollector.add(player, this.emc.add(res));
            this.emc = BigInteger.ZERO;
            this.markDirty();
        } else {
            this.emc = this.emc.add(res);
            this.markDirty();
        }
    }

    @Override
    @NotNull
    public Matter getMatter() {
        return ((BlockPowerFlower)this.m_58900_().m_60734_()).getMatter();
    }

    @Override
    public boolean hasSunBonus() {
        return BlockCompactSun.adjacent((BlockGetter)this.f_58857_, this.f_58858_, Direction.DOWN);
    }

    @Override
    public BigInteger getStoredEmcBigInteger() {
        return this.emc;
    }

    @Override
    public BigInteger getMaximumEmcBigInteger() {
        BigInteger max = BigInteger.valueOf(Long.MAX_VALUE);
        if (this.hasSunBonus()) {
            max = max.multiply(BigInteger.valueOf(Objects.requireNonNull(this.getSunBonus()).intValue()));
        }
        return max;
    }

    @Override
    public BigInteger extractEmcBigInteger(BigInteger toExtract, IEmcStorage.EmcAction action) {
        if (toExtract.compareTo(BigInteger.ZERO) < 0) {
            return this.insertEmcBigInteger(toExtract.negate(), action);
        }
        return BigInteger.ZERO;
    }

    @Override
    public BigInteger insertEmcBigInteger(BigInteger toAccept, IEmcStorage.EmcAction action) {
        if (toAccept.compareTo(BigInteger.ZERO) < 0) {
            return this.extractEmcBigInteger(toAccept.negate(), action);
        }
        return BigInteger.ZERO;
    }

    @Override
    public BigInteger getGeneratedEMC() {
        BigInteger generated = this.getMatter().getPowerFlowerOutput();
        if (this.hasSunBonus() && this.getSunBonus() != null) {
            generated = generated.multiply(BigInteger.valueOf(this.getSunBonus().intValue()));
        }
        return generated;
    }
}

