/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.block.entity;

import cool.furry.mc.forge.projectexpansion.util.ColorStyle;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.TagNames;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityOwnable
extends BlockEntity {
    public UUID owner = new UUID(0L, 0L);
    public String ownerName = "";

    public BlockEntityOwnable(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128403_(TagNames.OWNER)) {
            this.owner = tag.m_128342_(TagNames.OWNER);
        }
        if (tag.m_128425_(TagNames.OWNER_NAME, 8)) {
            this.ownerName = tag.m_128461_(TagNames.OWNER_NAME);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128362_(TagNames.OWNER, this.owner);
        tag.m_128359_(TagNames.OWNER_NAME, this.ownerName);
    }

    public void setOwner(Player player) {
        this.owner = player.m_20148_();
        this.ownerName = player.m_6302_();
        Util.markDirty(this);
    }

    public boolean handleActivation(Player player, ActivationType activationType) {
        switch (activationType) {
            case DISPLAY_NAME: {
                player.m_5661_((Component)Component.m_237113_((String)this.ownerName), true);
                break;
            }
            case CHECK_OWNERSHIP: {
                if (this.owner.equals(player.m_20148_())) break;
                player.m_5661_((Component)Lang.NOT_OWNER.translateColored(ChatFormatting.RED, new Object[]{Component.m_237113_((String)this.ownerName).m_6270_(ColorStyle.RED)}), true);
                return false;
            }
        }
        return true;
    }

    public void handlePlace(@Nullable LivingEntity livingEntity, ItemStack stack) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.setOwner(player);
        }
    }

    public void markDirty() {
        if (this.f_58857_ != null && this.f_58857_.m_46805_(this.f_58858_)) {
            this.f_58857_.m_46745_(this.f_58858_).m_8092_(true);
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public final CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static enum ActivationType {
        DISPLAY_NAME,
        CHECK_OWNERSHIP;

    }
}

