/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.block.entity;

import cool.furry.mc.forge.projectexpansion.block.BlockEMCLink;
import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityNBTFilterable;
import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityOwnable;
import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.registries.BlockEntityTypes;
import cool.furry.mc.forge.projectexpansion.util.ColorStyle;
import cool.furry.mc.forge.projectexpansion.util.EMCFormat;
import cool.furry.mc.forge.projectexpansion.util.IHasMatter;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.Matter;
import cool.furry.mc.forge.projectexpansion.util.TagNames;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.emc.nbt.NBTManager;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class BlockEntityEMCLink
extends BlockEntityNBTFilterable
implements IHasMatter {
    private final LazyOptional<IEmcStorage> emcStorageCapability = LazyOptional.of(() -> new EMCHandler());
    private final LazyOptional<IItemHandler> itemHandlerCapability = LazyOptional.of(() -> new ItemHandler());
    private final LazyOptional<IFluidHandler> fluidHandlerCapability = LazyOptional.of(() -> new FluidHandler());
    public BigInteger emc = BigInteger.ZERO;
    public ItemStack itemStack;
    public Matter matter;
    public BigInteger remainingEMC = BigInteger.ZERO;
    public int remainingImport = 0;
    public int remainingExport = 0;
    public int remainingFluid = 0;

    public BlockEntityEMCLink(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityTypes.EMC_LINK.get(), pos, state);
        this.itemStack = ItemStack.f_41583_;
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_(TagNames.STORED_EMC, 8)) {
            this.emc = new BigInteger(tag.m_128461_(TagNames.STORED_EMC));
        }
        if (tag.m_128425_(TagNames.ITEM, 10)) {
            this.itemStack = NBTManager.getPersistentInfo((ItemInfo)ItemInfo.fromStack((ItemStack)ItemStack.m_41712_((CompoundTag)tag.m_128469_(TagNames.ITEM)))).createStack();
        }
        if (tag.m_128425_(TagNames.REMAINING_EMC, 8)) {
            this.remainingEMC = new BigInteger(tag.m_128461_(TagNames.REMAINING_EMC));
        }
        if (tag.m_128425_(TagNames.REMAINING_IMPORT, 3)) {
            this.remainingImport = tag.m_128451_(TagNames.REMAINING_IMPORT);
        }
        if (tag.m_128425_(TagNames.REMAINING_EXPORT, 3)) {
            this.remainingExport = tag.m_128451_(TagNames.REMAINING_EXPORT);
        }
        if (tag.m_128425_(TagNames.REMAINING_FLUID, 3)) {
            this.remainingFluid = tag.m_128451_(TagNames.REMAINING_FLUID);
        }
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_(TagNames.STORED_EMC, this.emc.toString());
        tag.m_128365_(TagNames.ITEM, (Tag)this.itemStack.serializeNBT());
        tag.m_128359_(TagNames.REMAINING_EMC, this.remainingEMC.toString());
        tag.m_128405_(TagNames.REMAINING_IMPORT, this.remainingImport);
        tag.m_128405_(TagNames.REMAINING_EXPORT, this.remainingExport);
        tag.m_128405_(TagNames.REMAINING_FLUID, this.remainingFluid);
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof BlockEntityEMCLink) {
            BlockEntityEMCLink be = (BlockEntityEMCLink)blockEntity;
            be.tickServer(level, pos, state, be);
        }
    }

    public void tickServer(Level level, BlockPos pos, BlockState state, BlockEntityEMCLink blockEntity) {
        if (level.f_46443_ || level.m_46467_() % 20L != (long)Util.mod(this.hashCode(), 20)) {
            return;
        }
        this.resetLimits();
        if (this.emc.equals(BigInteger.ZERO)) {
            return;
        }
        ServerPlayer player = Util.getPlayer(level, this.owner);
        IKnowledgeProvider provider = Util.getKnowledgeProvider(this.owner);
        if (provider == null) {
            return;
        }
        BigInteger toAdd = this.getMatter() == Matter.FINAL ? this.emc : this.remainingEMC.min(this.emc);
        provider.setEmc(provider.getEmc().add(toAdd));
        this.emc = this.emc.subtract(toAdd).max(BigInteger.ZERO);
        if (player != null) {
            provider.syncEmc(player);
        }
        this.markDirty();
        this.emc = BigInteger.ZERO;
    }

    private void resetLimits() {
        Matter m = this.getMatter();
        this.remainingEMC = m.getEMCLinkEMCLimit();
        this.remainingImport = this.remainingExport = m.getEMCLinkItemLimit();
        this.remainingFluid = m.getEMCLinkFluidLimit();
    }

    private void setInternalItem(ItemStack stack) {
        this.itemStack = NBTManager.getPersistentInfo((ItemInfo)ItemInfo.fromStack((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1))).createStack();
        this.markDirty();
    }

    @Override
    public void handlePlace(@Nullable LivingEntity livingEntity, ItemStack stack) {
        super.handlePlace(livingEntity, stack);
        this.resetLimits();
    }

    @Override
    @NotNull
    public Matter getMatter() {
        if (this.f_58857_ != null) {
            BlockEMCLink block = (BlockEMCLink)this.m_58900_().m_60734_();
            if (block.getMatter() != this.matter) {
                this.setMatter(block.getMatter());
            }
            return this.matter;
        }
        return Matter.BASIC;
    }

    private void setMatter(Matter matter) {
        this.matter = matter;
    }

    public InteractionResult handleActivation(Player player, InteractionHand hand) {
        Item item;
        ItemStack inHand = player.m_21120_(hand);
        ItemHandler itemHandler = this.getItemHandlerCapability();
        FluidHandler fluidHandler = this.getFluidHandlerCapability();
        if (!super.handleActivation(player, BlockEntityOwnable.ActivationType.CHECK_OWNERSHIP)) {
            return InteractionResult.CONSUME;
        }
        if (player.m_6047_()) {
            if (this.itemStack.m_41619_()) {
                player.m_5661_((Component)Lang.Blocks.EMC_LINK_NOT_SET.translateColored(ChatFormatting.RED, new Object[0]), true);
                return InteractionResult.CONSUME;
            }
            if (inHand.m_41619_()) {
                this.setInternalItem(ItemStack.f_41583_);
                player.m_5661_((Component)Lang.Blocks.EMC_LINK_CLEARED.translateColored(ChatFormatting.RED, new Object[0]), true);
                return InteractionResult.SUCCESS;
            }
        }
        if (this.itemStack.m_41619_()) {
            if (inHand.m_41619_()) {
                player.m_5661_((Component)Lang.Blocks.EMC_LINK_NOT_SET.translateColored(ChatFormatting.RED, new Object[0]), true);
                return InteractionResult.CONSUME;
            }
            if (!itemHandler.isItemValid(0, inHand)) {
                player.m_5661_((Component)Lang.Blocks.EMC_LINK_EMPTY_HAND.translateColored(ChatFormatting.RED, new Object[]{Component.m_237115_((String)this.itemStack.m_41720_().toString()).m_6270_(ColorStyle.BLUE)}), true);
                return InteractionResult.CONSUME;
            }
            this.setInternalItem(inHand);
            player.m_5661_((Component)Lang.Blocks.EMC_LINK_SET.translateColored(ChatFormatting.GREEN, new Object[]{Component.m_237113_((String)this.itemStack.m_41720_().toString()).m_6270_(ColorStyle.BLUE)}), true);
            return InteractionResult.SUCCESS;
        }
        Fluid fluid = fluidHandler.getFluid();
        if (fluid != null && fluidHandler.isValid() && (item = inHand.m_41720_()) instanceof BucketItem) {
            BucketItem bucketItem = (BucketItem)item;
            if (((BucketItem)inHand.m_41720_()).getFluid() == Fluids.f_76191_) {
                if (((Boolean)Config.limitEmcLinkVendor.get()).booleanValue() && this.remainingFluid < 1000) {
                    player.m_5661_((Component)Lang.Blocks.EMC_LINK_NO_EXPORT_REMAINING.translateColored(ChatFormatting.RED, new Object[0]), true);
                    return InteractionResult.CONSUME;
                }
                long cost = fluidHandler.getFluidCost(1000.0);
                IKnowledgeProvider provider = Util.getKnowledgeProvider(this.owner);
                if (provider == null) {
                    player.m_5661_((Component)Lang.FAILED_TO_GET_KNOWLEDGE_PROVIDER.translateColored(ChatFormatting.RED, new Object[]{Util.getPlayer(this.owner) == null ? this.owner : Objects.requireNonNull(Util.getPlayer(this.owner)).m_5446_()}), true);
                    return InteractionResult.FAIL;
                }
                BigInteger emc = provider.getEmc();
                if (emc.compareTo(BigInteger.valueOf(cost)) < 0) {
                    player.m_5661_((Component)Lang.Blocks.EMC_LINK_NOT_ENOUGH_EMC.translateColored(ChatFormatting.RED, new Object[]{Component.m_237113_((String)EMCFormat.format(BigInteger.valueOf(IEMCProxy.INSTANCE.getValue(this.itemStack)))).m_6270_(ColorStyle.GREEN)}), true);
                    return InteractionResult.CONSUME;
                }
                FluidActionResult fillResult = FluidUtil.tryFillContainer((ItemStack)inHand, (IFluidHandler)fluidHandler, (int)1000, (Player)player, (boolean)true);
                if (!fillResult.isSuccess()) {
                    return InteractionResult.FAIL;
                }
                player.m_150109_().m_7407_(player.m_150109_().f_35977_, 1);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)fillResult.getResult());
                provider.setEmc(emc.subtract(BigInteger.valueOf(cost)));
                this.remainingFluid -= 1000;
                this.markDirty();
                if (player instanceof ServerPlayer) {
                    provider.syncEmc((ServerPlayer)player);
                }
                return InteractionResult.CONSUME;
            }
        }
        if (inHand.m_41619_() || this.itemStack.m_150930_(inHand.m_41720_())) {
            if (((Boolean)Config.limitEmcLinkVendor.get()).booleanValue() && this.remainingExport <= 0) {
                player.m_5661_((Component)Lang.Blocks.EMC_LINK_NO_EXPORT_REMAINING.translateColored(ChatFormatting.RED, new Object[0]), true);
                return InteractionResult.CONSUME;
            }
            ItemStack extract = itemHandler.extractItemInternal(0, this.itemStack.m_41741_(), false, (Boolean)Config.limitEmcLinkVendor.get());
            if (extract.m_41619_()) {
                player.m_5661_((Component)Lang.Blocks.EMC_LINK_NOT_ENOUGH_EMC.translateColored(ChatFormatting.RED, new Object[]{Component.m_237113_((String)EMCFormat.format(BigInteger.valueOf(IEMCProxy.INSTANCE.getValue(this.itemStack)))).m_6270_(ColorStyle.GREEN)}), true);
                return InteractionResult.CONSUME;
            }
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)extract);
            return InteractionResult.SUCCESS;
        }
        player.m_5661_((Component)Lang.Blocks.EMC_LINK_EMPTY_HAND.translateColored(ChatFormatting.RED, new Object[0]), true);
        return InteractionResult.CONSUME;
    }

    EMCHandler getEMCHandlerCapability() {
        return (EMCHandler)this.getCapability(PECapabilities.EMC_STORAGE_CAPABILITY).orElseThrow(NullPointerException::new);
    }

    ItemHandler getItemHandlerCapability() {
        return (ItemHandler)this.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseThrow(NullPointerException::new);
    }

    FluidHandler getFluidHandlerCapability() {
        return (FluidHandler)this.getCapability(ForgeCapabilities.FLUID_HANDLER).orElseThrow(NullPointerException::new);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == PECapabilities.EMC_STORAGE_CAPABILITY ? this.emcStorageCapability.cast() : (cap == ForgeCapabilities.ITEM_HANDLER ? this.itemHandlerCapability.cast() : (cap == ForgeCapabilities.FLUID_HANDLER ? this.fluidHandlerCapability.cast() : super.getCapability(cap, side)));
    }

    public void invalidateCaps() {
        this.emcStorageCapability.invalidate();
        this.itemHandlerCapability.invalidate();
        this.fluidHandlerCapability.invalidate();
    }

    private class ItemHandler
    implements IItemHandler {
        private ItemHandler() {
        }

        public int getSlots() {
            return BlockEntityEMCLink.this.getMatter().getEMCLinkInventorySize();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            if (slot != 0 || BlockEntityEMCLink.this.itemStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            IKnowledgeProvider provider = Util.getKnowledgeProvider(BlockEntityEMCLink.this.owner);
            if (provider == null) {
                return ItemStack.f_41583_;
            }
            BigInteger val = BigInteger.valueOf(IEMCProxy.INSTANCE.getValue(BlockEntityEMCLink.this.itemStack));
            if (val.equals(BigInteger.ZERO)) {
                return ItemStack.f_41583_;
            }
            BigInteger maxCount = provider.getEmc().divide(val).min(BigInteger.valueOf(Integer.MAX_VALUE));
            int count = maxCount.intValueExact();
            if (count <= 0) {
                return ItemStack.f_41583_;
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)BlockEntityEMCLink.this.itemStack, (int)count);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            int insertCount;
            boolean isFinal;
            boolean bl = isFinal = BlockEntityEMCLink.this.getMatter() == Matter.FINAL;
            if (slot == 0 || !isFinal && BlockEntityEMCLink.this.remainingImport <= 0 || BlockEntityEMCLink.this.owner == null || stack.m_41619_() || !this.isItemValid(slot, stack) || Util.getPlayer(BlockEntityEMCLink.this.owner) == null) {
                return stack;
            }
            int count = stack.m_41613_();
            stack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
            if (count <= 0) {
                return stack;
            }
            ItemInfo info = ItemInfo.fromStack((ItemStack)stack);
            if (BlockEntityEMCLink.this.getFilterStatus() && !NBTManager.getPersistentInfo((ItemInfo)info).equals((Object)info)) {
                return stack;
            }
            int n = insertCount = isFinal ? count : Math.min(count, BlockEntityEMCLink.this.remainingImport);
            if (!simulate) {
                long itemValue = IEMCProxy.INSTANCE.getSellValue(stack);
                IKnowledgeProvider provider = Util.getKnowledgeProvider(BlockEntityEMCLink.this.owner);
                if (provider == null) {
                    return stack;
                }
                BigInteger totalValue = BigInteger.valueOf(itemValue).multiply(BigInteger.valueOf(insertCount));
                provider.setEmc(provider.getEmc().add(totalValue));
                ServerPlayer player = Util.getPlayer(BlockEntityEMCLink.this.owner);
                if (player != null) {
                    if (provider.addKnowledge(stack)) {
                        provider.syncKnowledgeChange(player, NBTManager.getPersistentInfo((ItemInfo)info), true);
                    }
                    provider.syncEmc(player);
                }
                if (!isFinal) {
                    BlockEntityEMCLink.this.remainingImport -= insertCount;
                }
                BlockEntityEMCLink.this.markDirty();
            }
            if (insertCount == count) {
                return ItemStack.f_41583_;
            }
            stack.m_41764_(count - insertCount);
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.extractItemInternal(slot, amount, simulate, true);
        }

        public ItemStack extractItemInternal(int slot, int amount, boolean simulate, boolean limit) {
            boolean isFinal;
            boolean bl = isFinal = BlockEntityEMCLink.this.getMatter() == Matter.FINAL;
            if (slot != 0 || !isFinal && BlockEntityEMCLink.this.remainingExport <= 0 || BlockEntityEMCLink.this.owner == null || BlockEntityEMCLink.this.itemStack.m_41619_() || Util.getPlayer(BlockEntityEMCLink.this.owner) == null) {
                return ItemStack.f_41583_;
            }
            BigInteger itemValue = BigInteger.valueOf(IEMCProxy.INSTANCE.getValue(BlockEntityEMCLink.this.itemStack));
            if (itemValue.equals(BigInteger.ZERO)) {
                return ItemStack.f_41583_;
            }
            IKnowledgeProvider provider = Util.getKnowledgeProvider(BlockEntityEMCLink.this.owner);
            if (provider == null) {
                return ItemStack.f_41583_;
            }
            BigInteger maxCount = provider.getEmc().divide(itemValue).min(BigInteger.valueOf(Integer.MAX_VALUE));
            int extractCount = Math.min(amount, limit && !isFinal ? Math.min(maxCount.intValueExact(), BlockEntityEMCLink.this.remainingExport) : maxCount.intValueExact());
            if (extractCount <= 0) {
                return ItemStack.f_41583_;
            }
            ItemStack r = NBTManager.getPersistentInfo((ItemInfo)ItemInfo.fromStack((ItemStack)BlockEntityEMCLink.this.itemStack.m_41777_())).createStack();
            r.m_41764_(extractCount);
            if (simulate) {
                return r;
            }
            BigInteger totalPrice = itemValue.multiply(BigInteger.valueOf(extractCount));
            provider.setEmc(provider.getEmc().subtract(totalPrice));
            ServerPlayer player = Util.getPlayer(BlockEntityEMCLink.this.owner);
            if (player != null) {
                provider.syncEmc(player);
            }
            if (limit && !isFinal) {
                BlockEntityEMCLink.this.remainingExport -= extractCount;
            }
            BlockEntityEMCLink.this.markDirty();
            return r;
        }

        public int getSlotLimit(int slot) {
            return BlockEntityEMCLink.this.getMatter().getEMCLinkItemLimit();
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return IEMCProxy.INSTANCE.hasValue(stack);
        }
    }

    private class FluidHandler
    implements IFluidHandler {
        private FluidHandler() {
        }

        @Nullable
        public Fluid getFluid() {
            Item item;
            if (!BlockEntityEMCLink.this.itemStack.m_41619_() && (item = BlockEntityEMCLink.this.itemStack.m_41720_()) instanceof BucketItem) {
                BucketItem bucketItem = (BucketItem)item;
                return bucketItem.getFluid();
            }
            return null;
        }

        private double getFluidCostPer() {
            try {
                long fullCost = IEMCProxy.INSTANCE.getValue(BlockEntityEMCLink.this.itemStack);
                long bucketCost = IEMCProxy.INSTANCE.getValue(Items.f_42446_);
                if (bucketCost == 0L && fullCost == 0L) {
                    return 0.0;
                }
                return (double)((float)fullCost - (float)(bucketCost * (long)BlockEntityEMCLink.this.getMatter().getFluidEfficiencyPercentage()) / 100.0f) / 1000.0;
            }
            catch (ArithmeticException ignore) {
                return 9.223372036854776E18;
            }
        }

        private boolean isFreeFluid() {
            return this.getFluidCostPer() == 0.0 && (Boolean)Config.zeroEmcFluidsAreFree.get() != false;
        }

        private boolean isValid() {
            return this.getFluid() != null && (this.getFluidCostPer() != 0.0 || this.isFreeFluid());
        }

        private long getFluidCost(double amount) {
            try {
                double cost = this.getFluidCostPer();
                return (long)Math.ceil(cost * amount);
            }
            catch (ArithmeticException ignore) {
                return Long.MAX_VALUE;
            }
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            if (tank != 0) {
                return FluidStack.EMPTY;
            }
            Fluid fluid = this.getFluid();
            if (fluid == null || !this.isValid()) {
                return FluidStack.EMPTY;
            }
            return new FluidStack(fluid, BlockEntityEMCLink.this.remainingFluid);
        }

        public int getTankCapacity(int tank) {
            if (tank != 0) {
                return 0;
            }
            return BlockEntityEMCLink.this.remainingFluid;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            Fluid fluid = this.getFluid();
            if (fluid == null || !this.isValid() || !resource.getFluid().equals(fluid)) {
                return FluidStack.EMPTY;
            }
            return this.drain(resource.getAmount(), action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            boolean isFinal = BlockEntityEMCLink.this.getMatter() == Matter.FINAL;
            Fluid fluid = this.getFluid();
            if (fluid == null || !this.isValid() || Util.getPlayer(BlockEntityEMCLink.this.owner) == null) {
                return FluidStack.EMPTY;
            }
            if (!isFinal && maxDrain > BlockEntityEMCLink.this.remainingFluid) {
                maxDrain = BlockEntityEMCLink.this.remainingFluid;
            }
            if (maxDrain > BlockEntityEMCLink.this.remainingFluid) {
                maxDrain = BlockEntityEMCLink.this.remainingFluid;
            }
            long cost = this.getFluidCost(maxDrain);
            IKnowledgeProvider provider = Util.getKnowledgeProvider(BlockEntityEMCLink.this.owner);
            if (provider == null) {
                return FluidStack.EMPTY;
            }
            BigInteger emc = provider.getEmc();
            BigDecimal dEMC = new BigDecimal(emc);
            if (dEMC.compareTo(BigDecimal.valueOf(this.getFluidCostPer())) < 0) {
                return FluidStack.EMPTY;
            }
            if (emc.compareTo(BigInteger.valueOf(cost)) < 0) {
                BigDecimal max = dEMC.divide(BigDecimal.valueOf(this.getFluidCostPer()), RoundingMode.FLOOR);
                maxDrain = Util.safeIntValue(max);
                if (!isFinal && maxDrain > BlockEntityEMCLink.this.remainingFluid) {
                    maxDrain = BlockEntityEMCLink.this.remainingFluid;
                }
                if (maxDrain < 1) {
                    return FluidStack.EMPTY;
                }
                cost = this.getFluidCost(maxDrain);
            }
            if (action.execute()) {
                if (!isFinal) {
                    BlockEntityEMCLink.this.remainingFluid -= maxDrain;
                }
                BlockEntityEMCLink.this.markDirty();
                if (!this.isFreeFluid()) {
                    provider.setEmc(emc.subtract(BigInteger.valueOf(cost)));
                    provider.syncEmc(Objects.requireNonNull(Util.getPlayer(BlockEntityEMCLink.this.owner)));
                }
            }
            return new FluidStack(fluid, maxDrain);
        }
    }

    private class EMCHandler
    implements IEmcStorage {
        private EMCHandler() {
        }

        public long getStoredEmc() {
            return 0L;
        }

        public long getMaximumEmc() {
            return Util.safeLongValue(BlockEntityEMCLink.this.getMatter().getEMCLinkEMCLimit());
        }

        public long extractEmc(long emc, IEmcStorage.EmcAction action) {
            return emc < 0L ? this.insertEmc(-emc, action) : 0L;
        }

        public long insertEmc(long emc, IEmcStorage.EmcAction action) {
            long v;
            boolean isFinal = BlockEntityEMCLink.this.getMatter() == Matter.FINAL;
            long l = v = isFinal ? emc : Math.min(Util.safeLongValue(BlockEntityEMCLink.this.remainingEMC), emc);
            if (emc <= 0L) {
                return 0L;
            }
            if (action.execute()) {
                if (!isFinal) {
                    BlockEntityEMCLink.this.remainingEMC = BlockEntityEMCLink.this.remainingEMC.subtract(BigInteger.valueOf(v));
                }
                BlockEntityEMCLink.this.emc = BlockEntityEMCLink.this.emc.add(BigInteger.valueOf(v));
                BlockEntityEMCLink.this.markDirty();
            }
            return v;
        }
    }
}

