/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.block.entity;

import cool.furry.mc.forge.projectexpansion.util.IEmcStorageBigInteger;
import cool.furry.mc.forge.projectexpansion.util.TagNames;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.IntStream;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.capability.managing.ICapabilityResolver;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public abstract class BlockEntityEMC
extends BlockEntity
implements IEmcStorageBigInteger {
    @Nullable
    private LazyOptional<IEmcStorage> emcStorageCapability;
    @Nullable
    protected ICapabilityResolver<IItemHandler> itemHandlerResolver;
    private BigInteger maximumEMC;
    private BigInteger emc = BigInteger.ZERO;
    private boolean updateComparators;
    public static final Direction[] DIRECTIONS = Direction.values();

    public BlockEntityEMC(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        this(type, pos, state, BigInteger.valueOf(Long.MAX_VALUE));
    }

    public BlockEntityEMC(BlockEntityType<?> type, BlockPos pos, BlockState state, BigInteger maximumEMC) {
        super(type, pos, state);
        this.setMaximumEMC(maximumEMC);
    }

    protected void updateComparators() {
        if (this.updateComparators) {
            BlockState state = this.m_58900_();
            if (!state.m_60795_()) {
                Objects.requireNonNull(this.f_58857_).m_46717_(this.f_58858_, state.m_60734_());
            }
            this.updateComparators = false;
        }
    }

    protected boolean emcAffectsComparators() {
        return false;
    }

    public final void setMaximumEMC(BigInteger max) {
        this.maximumEMC = max;
        if (this.getStoredEmcBigInteger().compareTo(this.getMaximumEmcBigInteger()) > 0) {
            this.emc = this.getMaximumEmcBigInteger();
            this.storedEmcChanged();
        }
    }

    @Override
    public BigInteger getStoredEmcBigInteger() {
        return this.emc;
    }

    @Override
    public BigInteger getMaximumEmcBigInteger() {
        return this.maximumEMC;
    }

    protected @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getEmcInsertLimit() {
        return this.getNeededEmc();
    }

    protected BigInteger getEmcInsertLimitBigInteger() {
        return this.getNeededEmcBigInteger();
    }

    protected @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getEmcExtractLimit() {
        return this.getStoredEmc();
    }

    protected BigInteger getEmcExtractLimitBigInteger() {
        return this.getStoredEmcBigInteger();
    }

    protected boolean canAcceptEmc() {
        return true;
    }

    protected boolean canProvideEmc() {
        return true;
    }

    @Override
    public BigInteger extractEmcBigInteger(BigInteger toExtract, IEmcStorage.EmcAction action) {
        if (toExtract.compareTo(BigInteger.ZERO) < 0) {
            return this.insertEmcBigInteger(toExtract.negate(), action);
        }
        if (this.canProvideEmc()) {
            return this.forceExtractEmcBigInteger(this.getStoredEmcBigInteger().min(toExtract), action);
        }
        return BigInteger.ZERO;
    }

    @Override
    public BigInteger insertEmcBigInteger(BigInteger toAccept, IEmcStorage.EmcAction action) {
        if (toAccept.compareTo(BigInteger.ZERO) < 0) {
            return this.extractEmcBigInteger(toAccept.negate(), action);
        }
        if (this.canAcceptEmc()) {
            return this.forceInsertEmcBigInteger(this.getEmcInsertLimitBigInteger().min(toAccept), action);
        }
        return BigInteger.ZERO;
    }

    protected long forceExtractEmc(long toExtract, IEmcStorage.EmcAction action) {
        return Util.safeLongValue(this.forceExtractEmcBigInteger(BigInteger.valueOf(toExtract), action));
    }

    protected BigInteger forceExtractEmcBigInteger(BigInteger toExtract, IEmcStorage.EmcAction action) {
        if (toExtract.compareTo(BigInteger.ZERO) < 0) {
            return this.forceInsertEmcBigInteger(toExtract.negate(), action);
        }
        BigInteger toRemove = this.getStoredEmcBigInteger().min(toExtract);
        if (action.execute()) {
            this.emc = this.emc.subtract(toRemove);
            this.storedEmcChanged();
        }
        return toRemove;
    }

    protected long forceInsertEmc(long toAccept, IEmcStorage.EmcAction action) {
        return Util.safeLongValue(this.forceInsertEmcBigInteger(BigInteger.valueOf(toAccept), action));
    }

    protected BigInteger forceInsertEmcBigInteger(BigInteger toAccept, IEmcStorage.EmcAction action) {
        if (toAccept.compareTo(BigInteger.ZERO) < 0) {
            return this.forceExtractEmcBigInteger(toAccept.negate(), action);
        }
        BigInteger toAdd = this.getNeededEmcBigInteger().min(toAccept);
        if (action.execute()) {
            this.emc = this.emc.add(toAdd);
            this.storedEmcChanged();
        }
        return toAdd;
    }

    protected void sendToAllAcceptors(BigInteger emc) {
        this.sendToAllAcceptors(emc, Long.MAX_VALUE);
    }

    protected void sendToAllAcceptors(BigInteger emc, long transferLimit) {
        if (this.f_58857_ == null || !this.canProvideEmc()) {
            return;
        }
        emc = this.getEmcExtractLimitBigInteger().min(emc);
        ArrayList<IEmcStorage> targets = new ArrayList<IEmcStorage>(1);
        for (Direction dir : DIRECTIONS) {
            BlockEntity be;
            BlockPos neighbor = this.f_58858_.m_121945_(dir);
            if (!this.f_58857_.m_46749_(neighbor) || (be = this.f_58857_.m_7702_(neighbor)) == null) continue;
            be.getCapability(PECapabilities.EMC_STORAGE_CAPABILITY, dir.m_122424_()).ifPresent(storage -> {
                if (!(this.isRelay() && storage.isRelay() || storage.insertEmc(1L, IEmcStorage.EmcAction.SIMULATE) <= 0L)) {
                    targets.add((IEmcStorage)storage);
                }
            });
        }
        BigInteger remaining = Util.spreadEMC(emc, targets, (Long)transferLimit);
        this.forceExtractEmcBigInteger(emc.subtract(remaining), IEmcStorage.EmcAction.EXECUTE);
    }

    protected void storedEmcChanged() {
        this.markDirty(this.emcAffectsComparators());
    }

    public void m_6596_() {
        this.markDirty(true);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_(TagNames.STORED_EMC, this.getStoredEmcBigInteger().toString());
    }

    public void m_142466_(CompoundTag tag) {
        BigInteger set;
        super.m_142466_(tag);
        this.emc = set = new BigInteger(tag.m_128461_(TagNames.STORED_EMC));
    }

    public void markDirty(boolean recheckComparators) {
        if (this.f_58857_ != null) {
            if (this.f_58857_.m_46805_(this.f_58858_)) {
                this.f_58857_.m_46745_(this.f_58858_).m_8092_(true);
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
            }
            if (recheckComparators && !this.f_58857_.f_46443_) {
                this.updateComparators = true;
            }
        }
    }

    public final CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == PECapabilities.EMC_STORAGE_CAPABILITY) {
            if (this.emcStorageCapability == null || !this.emcStorageCapability.isPresent()) {
                this.emcStorageCapability = LazyOptional.of(() -> this);
            }
            return this.emcStorageCapability.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER && this.itemHandlerResolver != null) {
            return this.itemHandlerResolver.getCapabilityUnchecked(cap, side);
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.emcStorageCapability != null && this.emcStorageCapability.isPresent()) {
            this.emcStorageCapability.invalidate();
            this.emcStorageCapability = null;
        }
        if (this.itemHandlerResolver != null) {
            this.itemHandlerResolver.invalidateAll();
        }
    }

    protected class CompactableStackHandler
    extends StackHandler {
        private boolean needsCompacting;
        private boolean empty;

        protected CompactableStackHandler(int size) {
            super(size);
            this.needsCompacting = true;
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            this.needsCompacting = true;
        }

        public void compact() {
            if (this.needsCompacting) {
                if (BlockEntityEMC.this.f_58857_ != null && !((BlockEntityEMC)BlockEntityEMC.this).f_58857_.f_46443_) {
                    this.empty = ItemHelper.compactInventory((IItemHandlerModifiable)this);
                }
                this.needsCompacting = false;
            }
        }

        protected void onLoad() {
            super.onLoad();
            this.empty = IntStream.range(0, this.getSlots()).allMatch(slot -> this.getStackInSlot(slot).m_41619_());
        }

        public boolean isEmpty() {
            return this.empty;
        }
    }

    protected class StackHandler
    extends ItemStackHandler {
        protected StackHandler(int size) {
            super(size);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            BlockEntityEMC.this.m_6596_();
        }
    }
}

