/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.block.entity;

import cool.furry.mc.forge.projectexpansion.block.BlockCollector;
import cool.furry.mc.forge.projectexpansion.block.BlockCompactSun;
import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityEMC;
import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityRelay;
import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.gui.container.ContainerCollector;
import cool.furry.mc.forge.projectexpansion.registries.BlockEntityTypes;
import cool.furry.mc.forge.projectexpansion.util.Fuel;
import cool.furry.mc.forge.projectexpansion.util.IGeneratesEMC;
import cool.furry.mc.forge.projectexpansion.util.IHasMatter;
import cool.furry.mc.forge.projectexpansion.util.IHasSunBonus;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.Matter;
import cool.furry.mc.forge.projectexpansion.util.TagNames;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.Optional;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.capability.managing.BasicCapabilityResolver;
import moze_intel.projecte.capability.managing.ICapabilityResolver;
import moze_intel.projecte.capability.managing.SidedItemHandlerResolver;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.gameObjs.block_entities.RelayMK1BlockEntity;
import moze_intel.projecte.gameObjs.block_entities.WrappedItemHandler;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityCollector
extends BlockEntityEMC
implements IHasMatter,
IHasSunBonus,
IGeneratesEMC,
MenuProvider {
    private final ItemStackHandler input = new BlockEntityEMC.StackHandler(this.getInvSize()){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            BlockEntityCollector.this.needsCompacting = true;
        }
    };
    private final BlockEntityEMC.StackHandler auxSlots = new BlockEntityEMC.StackHandler(3){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (slot == 0) {
                BlockEntityCollector.this.needsCompacting = true;
            }
        }
    };
    private final CombinedInvWrapper toSort = new CombinedInvWrapper(new IItemHandlerModifiable[]{new RangedWrapper((IItemHandlerModifiable)this.auxSlots, 0, 1), this.input});
    public static final int UPGRADING_SLOT = 0;
    public static final int UPGRADE_SLOT = 1;
    public static final int LOCK_SLOT = 2;
    private boolean hasChargeableItem;
    private boolean hasFuel;
    private BigDecimal unprocessedEMC = BigDecimal.ZERO;
    private boolean needsCompacting = true;
    private Matter matter;

    public BlockEntityCollector(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityTypes.COLLECTOR.get(), pos, state);
        this.itemHandlerResolver = new CollectorItemHandlerProvider();
        this.resetStackHandlers();
    }

    private void resetStackHandlers() {
        this.input.setSize(this.getInvSize());
        this.auxSlots.setSize(3);
    }

    @Override
    protected boolean canAcceptEmc() {
        return this.hasFuel || this.hasChargeableItem;
    }

    public IItemHandler getInput() {
        return this.input;
    }

    public IItemHandler getAux() {
        return this.auxSlots;
    }

    protected int getInvSize() {
        return Math.max(12, (this.getMatter().ordinal() + 1) * 4) + 4;
    }

    private ItemStack getUpgraded() {
        return this.auxSlots.getStackInSlot(1);
    }

    private ItemStack getLock() {
        return this.auxSlots.getStackInSlot(2);
    }

    private ItemStack getUpgrading() {
        return this.auxSlots.getStackInSlot(0);
    }

    public void clearLocked() {
        this.auxSlots.setStackInSlot(2, ItemStack.f_41583_);
    }

    @Override
    protected boolean emcAffectsComparators() {
        return true;
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof BlockEntityCollector) {
            BlockEntityCollector be = (BlockEntityCollector)blockEntity;
            be.tickServer(level, pos, state, be);
        }
    }

    public void tickServer(Level level, BlockPos pos, BlockState state, BlockEntityCollector blockEntity) {
        if (((Boolean)Config.enableCollectorOptimizations.get()).booleanValue() && level.m_46467_() % 20L != (long)Util.mod(this.hashCode(), 20)) {
            return;
        }
        if (this.needsCompacting) {
            ItemHelper.compactInventory((IItemHandlerModifiable)this.toSort);
            this.needsCompacting = false;
        }
        this.checkFuelOrKlein();
        this.updateEmc();
        this.rotateUpgraded();
        this.updateComparators();
    }

    private void updateEmc() {
        BigDecimal gen = this.getMatter().getCollectorOutputForTicks((Boolean)Config.enableCollectorOptimizations.get() != false ? 20 : 1);
        if (this.hasSunBonus() && this.getSunBonus() != null) {
            gen = gen.multiply(BigDecimal.valueOf(this.getSunBonus().intValue()));
        }
        BigDecimal generated = gen;
        if (!this.hasMaxedEmc()) {
            this.unprocessedEMC = this.unprocessedEMC.add(generated.multiply(BigDecimal.valueOf((float)this.getSunLevel() / 16.0f)));
            if (this.unprocessedEMC.compareTo(BigDecimal.ONE) >= 0) {
                this.unprocessedEMC = this.unprocessedEMC.subtract(new BigDecimal(this.forceInsertEmcBigInteger(this.unprocessedEMC.toBigInteger(), IEmcStorage.EmcAction.EXECUTE)));
            }
            this.markDirty(false);
        }
        if (this.getStoredEmcBigInteger().compareTo(BigInteger.ZERO) > 0) {
            ItemStack upgrading = this.getUpgrading();
            if (this.hasChargeableItem) {
                upgrading.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY).ifPresent(emcHolder -> {
                    BigInteger remaining = Util.stepBigInteger(this.getStoredEmcBigInteger().min(generated.toBigInteger()), val -> emcHolder.insertEmc(upgrading, val.longValue(), IEmcStorage.EmcAction.EXECUTE));
                    BigInteger v = this.getStoredEmcBigInteger().subtract(remaining);
                    this.forceExtractEmcBigInteger(v, IEmcStorage.EmcAction.EXECUTE);
                });
            } else if (this.hasFuel) {
                ItemStack result;
                BigInteger upgradeCost;
                if (FuelMapper.getFuelUpgrade((ItemStack)upgrading).m_41619_()) {
                    this.auxSlots.setStackInSlot(0, ItemStack.f_41583_);
                }
                if ((upgradeCost = BigInteger.valueOf(EMCHelper.getEmcValue((ItemStack)(result = this.getLock().m_41619_() ? FuelMapper.getFuelUpgrade((ItemStack)upgrading) : this.getLock().m_41777_()))).subtract(BigInteger.valueOf(EMCHelper.getEmcValue((ItemStack)upgrading)))).compareTo(BigInteger.ZERO) >= 0 && this.getStoredEmcBigInteger().compareTo(upgradeCost) >= 0) {
                    ItemStack upgrade = this.getUpgraded();
                    if (this.getUpgraded().m_41619_()) {
                        this.forceExtractEmcBigInteger(upgradeCost, IEmcStorage.EmcAction.EXECUTE);
                        this.auxSlots.setStackInSlot(1, result);
                        upgrading.m_41774_(1);
                    } else if (result.m_41720_() == upgrade.m_41720_() && upgrade.m_41613_() < upgrade.m_41741_()) {
                        this.forceExtractEmcBigInteger(upgradeCost, IEmcStorage.EmcAction.EXECUTE);
                        this.getUpgraded().m_41769_(1);
                        upgrading.m_41774_(1);
                        this.auxSlots.onContentsChanged(1);
                    }
                }
            } else {
                BigInteger toSend = this.getStoredEmcBigInteger().compareTo(generated.toBigInteger()) < 0 ? this.getStoredEmcBigInteger() : generated.toBigInteger();
                this.sendToAllAcceptors(toSend);
                this.sendRelayBonus();
            }
        }
    }

    @Override
    public BigInteger getMaximumEmcBigInteger() {
        boolean sunBonus = this.hasSunBonus();
        BigInteger max = BigInteger.valueOf(Fuel.getCollectorEMCLimit(Objects.requireNonNull(this.getMatter())));
        if (sunBonus) {
            max = max.multiply(BigInteger.valueOf(Objects.requireNonNull(this.getSunBonus()).intValue()));
        }
        return max;
    }

    public long getEmcToNextGoal() {
        ItemStack lock = this.getLock();
        ItemStack upgrading = this.getUpgrading();
        long targetEmc = lock.m_41619_() ? EMCHelper.getEmcValue((ItemStack)FuelMapper.getFuelUpgrade((ItemStack)upgrading)) : EMCHelper.getEmcValue((ItemStack)lock);
        return Math.max(targetEmc - EMCHelper.getEmcValue((ItemStack)upgrading), 0L);
    }

    public long getItemCharge() {
        ItemStack upgrading = this.getUpgrading();
        if (!upgrading.m_41619_()) {
            return upgrading.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY).map(emcHolder -> emcHolder.getStoredEmc(upgrading)).orElse(-1L);
        }
        return -1L;
    }

    public double getItemChargeProportion() {
        ItemStack upgrading = this.getUpgrading();
        long charge = this.getItemCharge();
        if (upgrading.m_41619_() || charge <= 0L) {
            return -1.0;
        }
        Optional emcHolder = upgrading.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY).resolve();
        if (emcHolder.isPresent()) {
            long max = ((IItemEmcHolder)emcHolder.get()).getMaximumEmc(upgrading);
            if (charge >= max) {
                return 1.0;
            }
            return (double)charge / (double)max;
        }
        return -1.0;
    }

    public int getSunLevel() {
        if (Objects.requireNonNull(this.f_58857_).m_6042_().f_63857_()) {
            return 16;
        }
        return this.f_58857_.m_46803_(this.f_58858_.m_7494_()) + 1;
    }

    public double getFuelProgress() {
        BigDecimal reqEmc;
        if (this.getUpgrading().m_41619_() || !FuelMapper.isStackFuel((ItemStack)this.getUpgrading())) {
            return 0.0;
        }
        if (!this.getLock().m_41619_()) {
            reqEmc = BigDecimal.valueOf(EMCHelper.getEmcValue((ItemStack)this.getLock())).subtract(BigDecimal.valueOf(EMCHelper.getEmcValue((ItemStack)this.getUpgrading())));
            if (reqEmc.compareTo(BigDecimal.ZERO) <= 0) {
                return 0.0;
            }
        } else {
            if (FuelMapper.getFuelUpgrade((ItemStack)this.getUpgrading()).m_41619_()) {
                this.auxSlots.setStackInSlot(0, ItemStack.f_41583_);
                return 0.0;
            }
            reqEmc = BigDecimal.valueOf(EMCHelper.getEmcValue((ItemStack)FuelMapper.getFuelUpgrade((ItemStack)this.getUpgrading()))).subtract(BigDecimal.valueOf(EMCHelper.getEmcValue((ItemStack)this.getUpgrading())));
        }
        if (new BigDecimal(this.getStoredEmcBigInteger()).compareTo(reqEmc) >= 0) {
            return 1.0;
        }
        return new BigDecimal(this.getStoredEmcBigInteger()).divide(reqEmc, 3, RoundingMode.HALF_UP).doubleValue();
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.input.deserializeNBT(nbt.m_128469_(TagNames.INPUT));
        this.auxSlots.deserializeNBT(nbt.m_128469_(TagNames.AUX_SLOTS));
        this.unprocessedEMC = new BigDecimal(nbt.m_128461_(TagNames.UNPROCESSED_EMC));
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(TagNames.INPUT, (Tag)this.input.serializeNBT());
        tag.m_128365_(TagNames.AUX_SLOTS, (Tag)this.auxSlots.serializeNBT());
        tag.m_128359_(TagNames.UNPROCESSED_EMC, this.unprocessedEMC.toString());
    }

    private void sendRelayBonus() {
        if (this.f_58857_ == null) {
            return;
        }
        for (Direction dir : DIRECTIONS) {
            BlockEntity be = this.f_58857_.m_7702_(this.f_58858_.m_121945_(dir));
            if (be instanceof RelayMK1BlockEntity) {
                RelayMK1BlockEntity b = (RelayMK1BlockEntity)be;
                for (int i = 0; i < 20; ++i) {
                    b.addBonus();
                }
                Util.markDirty((BlockEntity)b);
                continue;
            }
            if (!(be instanceof BlockEntityRelay)) continue;
            BlockEntityRelay b = (BlockEntityRelay)be;
            b.addBonus();
            Util.markDirty(b);
        }
    }

    private void rotateUpgraded() {
        ItemStack upgraded = this.getUpgraded();
        if (!upgraded.m_41619_() && (this.getLock().m_41619_() || upgraded.m_41720_() != this.getLock().m_41720_() || upgraded.m_41613_() >= upgraded.m_41741_())) {
            this.auxSlots.setStackInSlot(1, ItemHandlerHelper.insertItemStacked((IItemHandler)this.input, (ItemStack)upgraded.m_41777_(), (boolean)false));
        }
    }

    private void checkFuelOrKlein() {
        ItemStack upgrading = this.getUpgrading();
        if (!upgrading.m_41619_()) {
            Optional emcHolder = upgrading.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY).resolve();
            if (emcHolder.isPresent()) {
                if (((IItemEmcHolder)emcHolder.get()).getNeededEmc(upgrading) > 0L) {
                    this.hasChargeableItem = true;
                    this.hasFuel = false;
                } else {
                    this.hasChargeableItem = false;
                }
            } else {
                this.hasFuel = true;
                this.hasChargeableItem = false;
            }
        } else {
            this.hasFuel = false;
            this.hasChargeableItem = false;
        }
    }

    @Override
    @NotNull
    public Matter getMatter() {
        BlockCollector block = (BlockCollector)this.m_58900_().m_60734_();
        if (block.getMatter() != this.matter) {
            this.matter = block.getMatter();
        }
        return this.matter;
    }

    @Override
    public boolean hasSunBonus() {
        return BlockCompactSun.adjacent((BlockGetter)this.f_58857_, this.f_58858_, Direction.UP);
    }

    @Override
    public BigInteger getGeneratedEMC() {
        return new BigDecimal(this.getMatter().getCollectorOutput()).multiply(BigDecimal.valueOf(this.getSunBonus() == null ? 1L : (long)this.getSunBonus().intValue())).multiply(BigDecimal.valueOf((float)this.getSunLevel() / 16.0f)).toBigInteger();
    }

    public Component m_5446_() {
        return Lang.Blocks.COLLECTOR.translate(new Object[0]);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return switch (this.getMatter()) {
            case Matter.BASIC -> new ContainerCollector.Tier1(windowId, playerInventory, this);
            case Matter.DARK -> new ContainerCollector.Tier2(windowId, playerInventory, this);
            default -> new ContainerCollector.Tier3(windowId, playerInventory, this);
        };
    }

    private class CollectorItemHandlerProvider
    extends SidedItemHandlerResolver {
        private final ICapabilityResolver<IItemHandler> automationAuxSlots;
        private final ICapabilityResolver<IItemHandler> automationInput;
        private final ICapabilityResolver<IItemHandler> joined;

        protected CollectorItemHandlerProvider() {
            NonNullLazy automationInput = NonNullLazy.of(() -> new WrappedItemHandler((IItemHandlerModifiable)BlockEntityCollector.this.input, WrappedItemHandler.WriteMode.IN){

                @NotNull
                public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                    return SlotPredicates.COLLECTOR_INV.test(stack) ? super.insertItem(slot, stack, simulate) : stack;
                }
            });
            NonNullLazy automationAuxSlots = NonNullLazy.of(() -> new WrappedItemHandler((IItemHandlerModifiable)BlockEntityCollector.this.auxSlots, WrappedItemHandler.WriteMode.OUT){

                @NotNull
                public ItemStack extractItem(int slot, int count, boolean simulate) {
                    if (slot == 1) {
                        return super.extractItem(slot, count, simulate);
                    }
                    return ItemStack.f_41583_;
                }
            });
            this.automationInput = BasicCapabilityResolver.getBasicItemHandlerResolver((NonNullSupplier)automationInput);
            this.automationAuxSlots = BasicCapabilityResolver.getBasicItemHandlerResolver((NonNullSupplier)automationAuxSlots);
            this.joined = BasicCapabilityResolver.getBasicItemHandlerResolver(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{(IItemHandlerModifiable)automationInput.get(), (IItemHandlerModifiable)automationAuxSlots.get()}));
        }

        protected ICapabilityResolver<IItemHandler> getResolver(@Nullable Direction side) {
            if (side == null) {
                return this.joined;
            }
            if (side.m_122434_().m_122478_()) {
                return this.automationAuxSlots;
            }
            return this.automationInput;
        }

        public void invalidateAll() {
            this.joined.invalidateAll();
            this.automationInput.invalidateAll();
            this.automationAuxSlots.invalidateAll();
        }
    }
}

