/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.block.entity;

import cool.furry.mc.forge.projectexpansion.block.BlockAdvancedAlchemicalChest;
import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityOwnable;
import cool.furry.mc.forge.projectexpansion.gui.container.ContainerAdvancedAlchemicalChest;
import cool.furry.mc.forge.projectexpansion.util.AdvancedAlchemicalChest;
import cool.furry.mc.forge.projectexpansion.util.IChestLike;
import cool.furry.mc.forge.projectexpansion.util.IHasColor;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.Util;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.capabilities.IAlchBagProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.gameObjs.items.AlchemicalBag;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class BlockEntityAdvancedAlchemicalChest
extends BlockEntityOwnable
implements IChestLike,
IHasColor,
IItemHandler {
    private final ChestLidController lidController = new ChestLidController();
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11749_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11747_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int oldCount, int openCount) {
            level.m_7696_(pos, state.m_60734_(), 1, openCount);
        }

        protected boolean m_142718_(Player player) {
            ContainerAdvancedAlchemicalChest chest;
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            return abstractContainerMenu instanceof ContainerAdvancedAlchemicalChest && (chest = (ContainerAdvancedAlchemicalChest)abstractContainerMenu).blockEntityMatches(BlockEntityAdvancedAlchemicalChest.this);
        }
    };
    private final LazyOptional<IItemHandler> itemHandlerCapability = LazyOptional.of(this::getBag);
    public final DyeColor color;

    public BlockEntityAdvancedAlchemicalChest(BlockPos pos, BlockState state, BlockEntityType<BlockEntityAdvancedAlchemicalChest> blockEntityType, DyeColor color) {
        super(blockEntityType, pos, state);
        this.color = color;
    }

    @Override
    @NotNull
    public DyeColor getColor() {
        return this.color;
    }

    @Nullable
    public IItemHandler getBag() {
        ServerPlayer player = Util.getPlayer(this.f_58857_, this.owner);
        if (player == null) {
            return null;
        }
        try {
            return ((IAlchBagProvider)player.getCapability(PECapabilities.ALCH_BAG_CAPABILITY).orElseThrow(NullPointerException::new)).getBag(this.color);
        }
        catch (NullPointerException ignore) {
            return null;
        }
    }

    public InteractionResult handleActivation(Player player, InteractionHand hand) {
        if (!super.handleActivation(player, BlockEntityOwnable.ActivationType.CHECK_OWNERSHIP)) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_()) {
            player.m_5661_((Component)Lang.Blocks.ADVANCED_ALCHEMICAL_CHEST_INVALID_ITEM.translate(new Object[0]), true);
            return InteractionResult.FAIL;
        }
        Item item = stack.m_41720_();
        if (item instanceof AlchemicalBag) {
            AlchemicalBag bag = (AlchemicalBag)item;
            if (this.f_58857_ != null) {
                BlockAdvancedAlchemicalChest block = AdvancedAlchemicalChest.getBlock(bag.color);
                BlockEntityType<BlockEntityAdvancedAlchemicalChest> blockEntityType = AdvancedAlchemicalChest.getBlockEntityType(bag.color);
                BlockEntityAdvancedAlchemicalChest newBlockEntity = new BlockEntityAdvancedAlchemicalChest(this.f_58858_, this.m_58900_(), blockEntityType, bag.color);
                newBlockEntity.owner = this.owner;
                newBlockEntity.ownerName = this.ownerName;
                newBlockEntity.m_183515_(new CompoundTag());
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)((BlockState)block.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61362_))));
                this.f_58857_.m_46747_(this.f_58858_);
                this.f_58857_.m_151523_((BlockEntity)newBlockEntity);
                Util.markDirty(this.f_58857_, this.f_58858_);
            }
            player.m_5661_((Component)Lang.Blocks.ADVANCED_ALCHEMICAL_CHEST_COLOR_SET.translate(new Object[]{bag.color.m_41065_()}), true);
        } else {
            player.m_5661_((Component)Lang.Blocks.ADVANCED_ALCHEMICAL_CHEST_INVALID_ITEM.translate(new Object[0]), true);
        }
        return InteractionResult.SUCCESS;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == ForgeCapabilities.ITEM_HANDLER ? this.itemHandlerCapability.cast() : super.getCapability(cap, side);
    }

    public static void tickClient(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof BlockEntityAdvancedAlchemicalChest) {
            BlockEntityAdvancedAlchemicalChest be = (BlockEntityAdvancedAlchemicalChest)blockEntity;
            be.lidController.m_155374_();
        }
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.lidController.m_155377_(type > 0);
            return true;
        }
        return super.m_7531_(id, type);
    }

    @Override
    public void startOpen(Player player) {
        if (!this.m_58901_() && !player.m_5833_() && this.f_58857_ != null) {
            this.openersCounter.m_155452_(player, this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    @Override
    public void stopOpen(Player player) {
        if (!this.m_58901_() && !player.m_5833_() && this.f_58857_ != null) {
            this.openersCounter.m_155468_(player, this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    @Override
    public void recheckOpen() {
        if (!this.m_58901_() && this.f_58857_ != null) {
            this.openersCounter.m_155476_(this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    @Override
    public float getOpenNess(float partialTicks) {
        return this.lidController.m_155375_(partialTicks);
    }

    public int getSlots() {
        IItemHandler bag = this.getBag();
        return bag == null ? 0 : bag.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        IItemHandler bag = this.getBag();
        return bag == null ? ItemStack.f_41583_ : bag.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        IItemHandler bag = this.getBag();
        return bag == null ? stack : bag.insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        IItemHandler bag = this.getBag();
        return bag == null ? ItemStack.f_41583_ : bag.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        IItemHandler bag = this.getBag();
        return bag == null ? 0 : bag.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        IItemHandler bag = this.getBag();
        return bag != null && bag.isItemValid(slot, stack);
    }
}

