/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.block;

import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityRelay;
import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.registries.BlockEntityTypes;
import cool.furry.mc.forge.projectexpansion.util.ColorStyle;
import cool.furry.mc.forge.projectexpansion.util.EMCFormat;
import cool.furry.mc.forge.projectexpansion.util.IHasMatter;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.Matter;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockRelay
extends Block
implements IHasMatter,
EntityBlock {
    private final Matter matter;

    public BlockRelay(Matter matter) {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(10.0f, 30.0f).m_60999_().m_60953_(state -> Math.min(matter.ordinal(), 15)));
        this.matter = matter;
    }

    @Override
    @NotNull
    public Matter getMatter() {
        return this.matter;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BlockEntityRelay(pos, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @javax.annotation.Nullable BlockGetter level, List<Component> list, TooltipFlag flag) {
        super.m_5871_(stack, level, list, flag);
        list.add((Component)Lang.Blocks.RELAY_TOOLTIP.translateColored(ChatFormatting.GRAY, new Object[0]));
        list.add((Component)Lang.Blocks.RELAY_BONUS.translateColored(ChatFormatting.GRAY, new Object[]{EMCFormat.getComponent(this.getMatter().getRelayBonusForTicks((Integer)Config.tickDelay.get())).m_6270_(ColorStyle.GREEN)}));
        list.add((Component)Lang.Blocks.RELAY_TRANSFER.translateColored(ChatFormatting.GRAY, new Object[]{this.getMatter().getRelayTransferComponent().m_6270_(ColorStyle.GREEN)}));
        list.add((Component)Lang.SEE_WIKI.translateColored(ChatFormatting.AQUA, new Object[0]));
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (type == BlockEntityTypes.RELAY.get() && !level.f_46443_) {
            return BlockEntityRelay::tickServer;
        }
        return null;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public MapColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MapColor defaultColor) {
        MapColor color = this.matter.mapColor == null ? null : this.matter.mapColor.get();
        return color != null ? color : super.getMapColor(state, level, pos, defaultColor);
    }
}

