/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.block;

import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityPowerFlower;
import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.registries.BlockEntityTypes;
import cool.furry.mc.forge.projectexpansion.util.ColorStyle;
import cool.furry.mc.forge.projectexpansion.util.EMCFormat;
import cool.furry.mc.forge.projectexpansion.util.IHasMatter;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.Matter;
import java.math.BigInteger;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class BlockPowerFlower
extends Block
implements IHasMatter,
EntityBlock {
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)BlockPowerFlower.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BlockPowerFlower.m_49796_((double)3.5, (double)4.0, (double)6.5, (double)12.5, (double)13.0, (double)9.5), BlockPowerFlower.m_49796_((double)6.5, (double)1.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5), BlockPowerFlower.m_49796_((double)6.5, (double)4.0, (double)3.5, (double)9.5, (double)13.0, (double)12.5), BlockPowerFlower.m_49796_((double)6.5, (double)7.0, (double)0.5, (double)9.5, (double)10.0, (double)15.5), BlockPowerFlower.m_49796_((double)3.5, (double)7.0, (double)3.5, (double)12.5, (double)10.0, (double)12.5), BlockPowerFlower.m_49796_((double)0.5, (double)7.0, (double)6.5, (double)15.5, (double)10.0, (double)9.5)});
    private final Matter matter;

    public BlockPowerFlower(Matter matter) {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(1.5f, 30.0f).m_60953_(state -> Math.min(matter.ordinal(), 15)));
        this.matter = matter;
    }

    @Override
    @NotNull
    public Matter getMatter() {
        return this.matter;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BlockEntityPowerFlower(pos, state);
    }

    @Deprecated
    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> list, TooltipFlag flag) {
        super.m_5871_(stack, level, list, flag);
        list.add((Component)Lang.Blocks.POWER_FLOWER_TOOLTIP.translateColored(ChatFormatting.GRAY, new Object[]{Component.m_237113_((String)((Integer)Config.tickDelay.get()).toString()).m_6270_(ColorStyle.GREEN), Component.m_237113_((String)((Integer)Config.tickDelay.get() == 1 ? "" : "s")).m_6270_(ColorStyle.GRAY)}));
        list.add((Component)Lang.Blocks.POWER_FLOWER_EMC.translateColored(ChatFormatting.GRAY, new Object[]{EMCFormat.getComponent(this.getMatter().getPowerFlowerOutput()).m_6270_(ColorStyle.GREEN)}));
        if (stack.m_41613_() > 1) {
            list.add((Component)Lang.Blocks.POWER_FLOWER_STACK_EMC.translateColored(ChatFormatting.GRAY, new Object[]{EMCFormat.getComponent(this.getMatter().getPowerFlowerOutput().multiply(BigInteger.valueOf(stack.m_41613_()))).m_6270_(ColorStyle.GREEN)}));
        }
        list.add((Component)Lang.SEE_WIKI.translateColored(ChatFormatting.AQUA, new Object[0]));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BlockEntityPowerFlower) {
            BlockEntityPowerFlower be = (BlockEntityPowerFlower)blockEntity;
            player.m_5661_((Component)Component.m_237113_((String)be.ownerName), true);
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity livingEntity, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BlockEntityPowerFlower) {
            BlockEntityPowerFlower be = (BlockEntityPowerFlower)blockEntity;
            be.handlePlace(livingEntity, stack);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (type == BlockEntityTypes.POWER_FLOWER.get() && !level.f_46443_) {
            return BlockEntityPowerFlower::tickServer;
        }
        return null;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public MapColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MapColor defaultColor) {
        MapColor color = this.matter.mapColor == null ? null : this.matter.mapColor.get();
        return color != null ? color : super.getMapColor(state, level, pos, defaultColor);
    }
}

