/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.block;

import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityEMCLink;
import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityNBTFilterable;
import cool.furry.mc.forge.projectexpansion.registries.BlockEntityTypes;
import cool.furry.mc.forge.projectexpansion.util.ColorStyle;
import cool.furry.mc.forge.projectexpansion.util.IHasMatter;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.Matter;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class BlockEMCLink
extends Block
implements IHasMatter,
EntityBlock {
    private final Matter matter;

    public BlockEMCLink(Matter matter) {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(1.5f, 30.0f).m_60999_().m_60953_(state -> Math.min(matter.ordinal(), 15)));
        this.matter = matter;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockEntityNBTFilterable.FILTER, (Comparable)Boolean.valueOf(true)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BlockEntityEMCLink(pos, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> list, TooltipFlag flag) {
        super.m_5871_(stack, level, list, flag);
        list.add((Component)Lang.Blocks.EMC_LINK_TOOLTIP.translateColored(ChatFormatting.GRAY, new Object[0]));
        list.add((Component)Lang.Blocks.EMC_LINK_LIMIT_ITEMS.translateColored(ChatFormatting.GRAY, new Object[]{this.getMatter().getEMCLinkItemLimitComponent()}));
        list.add((Component)Lang.Blocks.EMC_LINK_LIMIT_FLUIDS.translateColored(ChatFormatting.GRAY, new Object[]{this.getMatter().getEMCLinkFluidLimitComponent()}));
        list.add((Component)Lang.Blocks.EMC_LINK_FLUID_EXPORT_EFFICIENCY.translateColored(ChatFormatting.GRAY, new Object[]{Component.m_237113_((String)(this.getMatter().getFluidEfficiencyPercentage() + "%")).m_6270_(ColorStyle.GREEN)}));
        list.add((Component)Lang.Blocks.EMC_LINK_LIMIT_EMC.translateColored(ChatFormatting.GRAY, new Object[]{this.getMatter().getEMCLinkEMCLimitComponent()}));
        list.add((Component)Lang.SEE_WIKI.translateColored(ChatFormatting.AQUA, new Object[0]));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BlockEntityEMCLink) {
            BlockEntityEMCLink be = (BlockEntityEMCLink)blockEntity;
            return be.handleActivation(player, hand);
        }
        return InteractionResult.PASS;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity livingEntity, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BlockEntityEMCLink) {
            BlockEntityEMCLink be = (BlockEntityEMCLink)blockEntity;
            be.handlePlace(livingEntity, stack);
        }
    }

    @Override
    @NotNull
    public Matter getMatter() {
        return this.matter;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockEntityNBTFilterable.FILTER});
        super.m_7926_(builder);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (type == BlockEntityTypes.EMC_LINK.get() && !level.f_46443_) {
            return BlockEntityEMCLink::tickServer;
        }
        return null;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public MapColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MapColor defaultColor) {
        MapColor color = this.matter.mapColor == null ? null : this.matter.mapColor.get();
        return color != null ? color : super.getMapColor(state, level, pos, defaultColor);
    }
}

