/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.block;

import cool.furry.mc.forge.projectexpansion.registries.DamageSources;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.SunExposureHelper;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class BlockCompactSun
extends Block {
    public BlockCompactSun() {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(2000000.0f, 6000000.0f).m_60999_().m_60953_(state -> 15));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> list, TooltipFlag flag) {
        super.m_5871_(stack, level, list, flag);
        list.add((Component)Lang.Blocks.COMPACT_SUN_TOOLTIP.translateColored(ChatFormatting.GRAY, new Object[0]));
        list.add((Component)Lang.Blocks.COMPACT_SUN_TOOLTIP2.translateColored(ChatFormatting.GRAY, new Object[]{Util.getSunBonus()}));
        list.add((Component)Lang.SEE_WIKI.translateColored(ChatFormatting.AQUA, new Object[0]));
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public MapColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MapColor defaultColor) {
        return MapColor.f_283832_;
    }

    public void m_141947_(Level level, BlockPos pos, BlockState blockState, Entity entity) {
        ServerPlayer player;
        DamageSources damage = DamageSources.fromLevel(level);
        if (entity instanceof ServerPlayer && !SunExposureHelper.wearingProtectiveBoots(player = (ServerPlayer)entity)) {
            float maxPlayerHealth = player.m_21233_();
            player.m_6469_(damage.walkOnSun(), maxPlayerHealth * 0.6f);
        }
        super.m_141947_(level, pos, blockState, entity);
    }

    public static boolean adjacent(@Nullable BlockGetter level, @NotNull BlockPos pos) {
        return BlockCompactSun.adjacent(level, pos, null);
    }

    public static boolean adjacent(@Nullable BlockGetter level, @NotNull BlockPos pos, @Nullable Direction filterDirection) {
        if (level == null) {
            return false;
        }
        for (Direction dir : Direction.values()) {
            if (filterDirection != null && dir != filterDirection || !(level.m_8055_(pos.m_121945_(dir)).m_60734_() instanceof BlockCompactSun)) continue;
            return true;
        }
        return false;
    }
}

