/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.block;

import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityCollector;
import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.registries.BlockEntityTypes;
import cool.furry.mc.forge.projectexpansion.util.ColorStyle;
import cool.furry.mc.forge.projectexpansion.util.EMCFormat;
import cool.furry.mc.forge.projectexpansion.util.Fuel;
import cool.furry.mc.forge.projectexpansion.util.IHasMatter;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.Matter;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.gameObjs.blocks.BlockDirection;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class BlockCollector
extends BlockDirection
implements IHasMatter,
EntityBlock {
    private final Matter matter;

    public BlockCollector(Matter matter) {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(0.3f, 0.9f).m_60999_().m_60953_(state -> Math.min(matter.ordinal(), 15)));
        this.matter = matter;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BlockEntityCollector(pos, state);
    }

    @Override
    @NotNull
    public Matter getMatter() {
        return this.matter;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> list, TooltipFlag flag) {
        super.m_5871_(stack, level, list, flag);
        list.add((Component)Lang.Blocks.COLLECTOR_TOOLTIP.translateColored(ChatFormatting.GRAY, new Object[0]));
        list.add((Component)Lang.Blocks.COLLECTOR_EMC.translateColored(ChatFormatting.GRAY, new Object[]{EMCFormat.getComponent(this.getMatter().getCollectorOutputForTicks((Integer)Config.tickDelay.get())).m_6270_(ColorStyle.GREEN)}));
        if (stack.m_41613_() > 1) {
            list.add((Component)Lang.Blocks.COLLECTOR_STACK_EMC.translateColored(ChatFormatting.GRAY, new Object[]{EMCFormat.getComponent(this.getMatter().getCollectorOutputForTicks((Integer)Config.tickDelay.get()).multiply(BigDecimal.valueOf(stack.m_41613_()))).m_6270_(ColorStyle.GREEN)}));
        }
        list.add((Component)Lang.Blocks.COLLECTOR_MAX_STORAGE.translateColored(ChatFormatting.GRAY, new Object[]{EMCFormat.getComponent(Fuel.getCollectorEMCLimit(this.getMatter())).m_6270_(ColorStyle.GREEN)}));
        list.add((Component)Lang.SEE_WIKI.translateColored(ChatFormatting.AQUA, new Object[0]));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (type == BlockEntityTypes.COLLECTOR.get() && !level.f_46443_) {
            return BlockEntityCollector::tickServer;
        }
        return null;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public MapColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MapColor defaultColor) {
        MapColor color = this.matter.mapColor == null ? null : this.matter.mapColor.get();
        return color != null ? color : super.getMapColor(state, level, pos, defaultColor);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntityCollector collector = (BlockEntityCollector)WorldHelper.getBlockEntity(BlockEntityCollector.class, (BlockGetter)level, (BlockPos)pos);
        if (collector != null) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)collector, (BlockPos)pos);
        }
        return InteractionResult.CONSUME;
    }

    @Deprecated
    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    @Deprecated
    public int m_6782_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        BlockEntityCollector collector = (BlockEntityCollector)WorldHelper.getBlockEntity(BlockEntityCollector.class, (BlockGetter)level, (BlockPos)pos, (boolean)true);
        if (collector == null) {
            return super.m_6782_(state, level, pos);
        }
        Optional cap = collector.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).resolve();
        if (cap.isEmpty()) {
            return super.m_6782_(state, level, pos);
        }
        ItemStack charging = ((IItemHandler)cap.get()).getStackInSlot(0);
        if (!charging.m_41619_()) {
            Optional holderCapability = charging.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY).resolve();
            if (holderCapability.isPresent()) {
                IItemEmcHolder emcHolder = (IItemEmcHolder)holderCapability.get();
                return Util.scaleToRedstone(emcHolder.getStoredEmc(charging), emcHolder.getMaximumEmc(charging));
            }
            return Util.scaleToRedstone(collector.getStoredEmcBigInteger(), BigInteger.valueOf(collector.getEmcToNextGoal()));
        }
        return Util.scaleToRedstone(collector.getStoredEmcBigInteger(), collector.getMaximumEmcBigInteger());
    }

    @Deprecated
    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntityCollector collector = (BlockEntityCollector)WorldHelper.getBlockEntity(BlockEntityCollector.class, (BlockGetter)level, (BlockPos)pos);
            if (collector != null) {
                collector.clearLocked();
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }
}

