/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.block;

import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityAdvancedAlchemicalChest;
import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityOwnable;
import cool.furry.mc.forge.projectexpansion.gui.container.ContainerAdvancedAlchemicalChest;
import cool.furry.mc.forge.projectexpansion.util.AdvancedAlchemicalChest;
import cool.furry.mc.forge.projectexpansion.util.IHasColor;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class BlockAdvancedAlchemicalChest
extends HorizontalDirectionalBlock
implements EntityBlock,
SimpleWaterloggedBlock,
IHasColor {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    private final DyeColor color;

    public BlockAdvancedAlchemicalChest(DyeColor color) {
        super(BlockBehaviour.Properties.m_284310_().m_60999_().m_60913_(10.0f, 3600000.0f).m_60953_(state -> 10));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.color = color;
    }

    @Override
    @NotNull
    public DyeColor getColor() {
        return this.color;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> list, TooltipFlag flag) {
        super.m_5871_(stack, level, list, flag);
        list.add((Component)Lang.Blocks.ADVANCED_ALCHEMICAL_CHEST_TOOLTIP.translateColored(ChatFormatting.GRAY, new Object[0]));
        list.add((Component)Lang.SEE_WIKI.translateColored(ChatFormatting.AQUA, new Object[0]));
    }

    public RenderShape m_7514_(BlockState p_51567_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BlockEntityAdvancedAlchemicalChest(pos, state, AdvancedAlchemicalChest.getBlockEntityType(this.color), this.color);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BlockEntityAdvancedAlchemicalChest) {
            BlockEntityAdvancedAlchemicalChest be = (BlockEntityAdvancedAlchemicalChest)blockEntity;
            if (player.m_6047_()) {
                PiglinAi.m_34873_((Player)player, (boolean)true);
                return be.handleActivation(player, hand);
            }
            if (be.handleActivation(player, BlockEntityOwnable.ActivationType.CHECK_OWNERSHIP)) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new ContainerProvider(be, hand), buf -> {
                    buf.m_130068_((Enum)hand);
                    buf.writeByte(player.m_150109_().f_35977_);
                    buf.writeBoolean(false);
                    buf.m_130064_(pos);
                });
                player.m_36220_(Stats.f_12968_);
                PiglinAi.m_34873_((Player)player, (boolean)true);
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.FAIL;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity livingEntity, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BlockEntityAdvancedAlchemicalChest) {
            BlockEntityAdvancedAlchemicalChest be = (BlockEntityAdvancedAlchemicalChest)blockEntity;
            be.handlePlace(livingEntity, stack);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (type == AdvancedAlchemicalChest.getBlockEntityType(this.color) && level.f_46443_) {
            return BlockEntityAdvancedAlchemicalChest::tickClient;
        }
        return null;
    }

    public VoxelShape m_5940_(BlockState p_51569_, BlockGetter p_51570_, BlockPos p_51571_, CollisionContext p_51572_) {
        return SHAPE;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BlockEntityAdvancedAlchemicalChest) {
            BlockEntityAdvancedAlchemicalChest be = (BlockEntityAdvancedAlchemicalChest)blockEntity;
            be.recheckOpen();
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_, WATERLOGGED});
    }

    public boolean m_7357_(BlockState p_51522_, BlockGetter p_51523_, BlockPos p_51524_, PathComputationType p_51525_) {
        return false;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BlockEntityAdvancedAlchemicalChest) {
            BlockEntityAdvancedAlchemicalChest be = (BlockEntityAdvancedAlchemicalChest)blockEntity;
            return be.getCapability(ForgeCapabilities.ITEM_HANDLER).map(ItemHandlerHelper::calcRedstoneFromInventory).orElse(0);
        }
        return 0;
    }

    @Nonnull
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)Objects.requireNonNull(super.m_5573_(context)).m_61124_((Property)f_54117_, (Comparable)(context.m_43723_() == null ? Direction.NORTH : context.m_43723_().m_6350_().m_122424_()))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nonnull
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_8133_(BlockState state, Level level, BlockPos pos, int id, int param) {
        super.m_8133_(state, level, pos, id, param);
        BlockEntity blockEntity = level.m_7702_(pos);
        return blockEntity != null && blockEntity.m_7531_(id, param);
    }

    public MapColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MapColor defaultColor) {
        return MapColor.m_284175_((int)this.color.m_41060_());
    }

    private record ContainerProvider(BlockEntityAdvancedAlchemicalChest blockEntity, InteractionHand hand) implements MenuProvider
    {
        @Nonnull
        public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
            IItemHandlerModifiable inv = (IItemHandlerModifiable)this.blockEntity.getBag();
            return new ContainerAdvancedAlchemicalChest(windowId, playerInventory, this.hand, Objects.requireNonNull(inv), playerInventory.f_35977_, false, this.blockEntity);
        }

        @Nonnull
        public Component m_5446_() {
            return Lang.ADVANCED_ALCHEMICAL_CHEST_TITLE.translate(new Object[0]);
        }
    }
}

