/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion;

import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.net.PacketHandler;
import cool.furry.mc.forge.projectexpansion.registries.BlockEntityTypes;
import cool.furry.mc.forge.projectexpansion.registries.Blocks;
import cool.furry.mc.forge.projectexpansion.registries.CreativeTabs;
import cool.furry.mc.forge.projectexpansion.registries.Enchantments;
import cool.furry.mc.forge.projectexpansion.registries.Items;
import cool.furry.mc.forge.projectexpansion.registries.MenuTypes;
import cool.furry.mc.forge.projectexpansion.registries.SoundEvents;
import cool.furry.mc.forge.projectexpansion.util.AdvancedAlchemicalChest;
import cool.furry.mc.forge.projectexpansion.util.AlchemicalCollectionCollector;
import cool.furry.mc.forge.projectexpansion.util.Fuel;
import cool.furry.mc.forge.projectexpansion.util.Matter;
import cool.furry.mc.forge.projectexpansion.util.Star;
import cool.furry.mc.forge.projectexpansion.util.TagNames;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="projectexpansion")
public class Main {
    public static final String MOD_ID = "projectexpansion";
    public static final Logger Logger = LogManager.getLogger();

    public Main() {
        PacketHandler.register();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BlockEntityTypes.Registry.register(bus);
        Blocks.Registry.register(bus);
        Enchantments.Registry.register(bus);
        Items.Registry.register(bus);
        SoundEvents.Registry.register(bus);
        MenuTypes.Registry.register(bus);
        CreativeTabs.Registry.register(bus);
        MinecraftForge.EVENT_BUS.addListener(this::serverTick);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.Spec, "project-expansion.toml");
        Fuel.registerAll();
        Matter.registerAll();
        Star.registerAll();
        AdvancedAlchemicalChest.register();
    }

    private void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        AlchemicalCollectionCollector.process();
        for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                boolean hasEnch;
                ItemStack stack = player.m_150109_().m_8020_(i);
                if (stack.m_41720_().equals(Items.INFINITE_FUEL.get())) {
                    stack.m_41784_().m_128362_(TagNames.OWNER, player.m_20148_());
                    continue;
                }
                boolean bl = hasEnch = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)Enchantments.ALCHEMICAL_COLLECTION.get()), (ItemStack)stack) > 0;
                if (!hasEnch || stack.m_41784_().m_128441_(TagNames.ALCHEMICAL_COLLECTION_ENABLED)) continue;
                stack.m_41784_().m_128379_(TagNames.ALCHEMICAL_COLLECTION_ENABLED, true);
            }
        }
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

