/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.visuality.config;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import plus.dragons.visuality.Visuality;
import plus.dragons.visuality.config.ReloadableJsonConfig;
import plus.dragons.visuality.data.ParticleWithVelocity;
import plus.dragons.visuality.data.VisualityCodecs;
import plus.dragons.visuality.particle.type.ColorParticleType;
import plus.dragons.visuality.registry.VisualityParticles;

public class BlockAmbientParticleConfig
extends ReloadableJsonConfig {
    private boolean enabled = true;
    private int interval = 10;
    private List<Entry> entries;
    private final IdentityHashMap<Block, Pair<Direction[], ParticleWithVelocity>> particles = new IdentityHashMap();

    public BlockAmbientParticleConfig() {
        super(Visuality.location("particle_emitters/block_ambient"));
        this.entries = BlockAmbientParticleConfig.createDefaultEntries();
        for (Entry entry : this.entries) {
            for (Block block : entry.blocks) {
                this.particles.put(block, (Pair<Direction[], ParticleWithVelocity>)Pair.of((Object)((Direction[])entry.directions.toArray(Direction[]::new)), (Object)entry.particle));
            }
        }
    }

    public void spawnParticles(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!this.enabled || !level.isAreaLoaded(pos, 1)) {
            return;
        }
        Block block = state.m_60734_();
        if (!this.particles.containsKey(block)) {
            return;
        }
        Pair<Direction[], ParticleWithVelocity> entry = this.particles.get(block);
        Direction[] directions = (Direction[])entry.getFirst();
        int i = random.m_188503_(this.interval);
        if (i >= directions.length) {
            return;
        }
        boolean fullBlock = state.m_60804_((BlockGetter)level, pos);
        if (fullBlock) {
            Direction direction = directions[i];
            BlockPos facePos = pos.m_121945_(direction);
            if (level.m_8055_(facePos).m_60804_((BlockGetter)level, facePos)) {
                return;
            }
            Direction.Axis axis = direction.m_122434_();
            double x = (double)pos.m_123341_() + (axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.m_122429_() : random.m_188500_());
            double y = (double)pos.m_123342_() + (axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.m_122430_() : random.m_188500_());
            double z = (double)pos.m_123343_() + (axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.m_122431_() : random.m_188500_());
            ((ParticleWithVelocity)entry.getSecond()).spawn(level, x, y, z);
        } else {
            double x = (double)pos.m_123341_() + random.m_188500_();
            double y = (double)pos.m_123342_() + random.m_188500_();
            double z = (double)pos.m_123343_() + random.m_188500_();
            ((ParticleWithVelocity)entry.getSecond()).spawn(level, x, y, z);
        }
    }

    @Override
    @Nullable
    protected JsonObject apply(JsonObject input, boolean config, String source, ProfilerFiller profiler) {
        JsonArray array;
        profiler.m_6180_(source);
        if (config) {
            this.enabled = GsonHelper.m_13855_((JsonObject)input, (String)"enabled", (boolean)true);
            this.interval = GsonHelper.m_13824_((JsonObject)input, (String)"interval", (int)10);
        }
        if ((array = GsonHelper.m_13832_((JsonObject)input, (String)"entries", null)) == null) {
            this.logger.warn("Failed to load options entries from {}: Missing JsonArray 'entries'.", (Object)source);
            profiler.m_7238_();
            return config ? this.serializeConfig() : null;
        }
        boolean save = false;
        ArrayList<Entry> newEntries = new ArrayList<Entry>();
        ArrayList elements = Lists.newArrayList((Iterable)array);
        for (JsonElement element : elements) {
            DataResult data = Entry.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
            if (data.error().isPresent()) {
                save = config;
                this.logger.warn("Error parsing {} from {}: {}", new Object[]{this.id, source, ((DataResult.PartialResult)data.error().get()).message()});
                continue;
            }
            Optional<Entry> result = data.result().filter(entry -> !entry.directions.isEmpty());
            if (result.isPresent()) {
                newEntries.add(result.get());
                continue;
            }
            this.logger.warn("Error parsing {} from {}: Directions must not be empty", (Object)this.id, (Object)source);
            save = config;
        }
        if (config) {
            this.entries = newEntries;
            this.particles.clear();
        }
        for (Entry entry2 : newEntries) {
            for (Block block : entry2.blocks) {
                this.particles.put(block, (Pair<Direction[], ParticleWithVelocity>)Pair.of((Object)((Direction[])entry2.directions.toArray(Direction[]::new)), (Object)entry2.particle));
            }
        }
        profiler.m_7238_();
        return save ? this.serializeConfig() : null;
    }

    @Override
    protected JsonObject serializeConfig() {
        JsonObject object = new JsonObject();
        object.addProperty("enabled", Boolean.valueOf(this.enabled));
        object.addProperty("interval", (Number)this.interval);
        object.add("entries", (JsonElement)Entry.LIST_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, this.entries).getOrThrow(true, msg -> this.logger.error("Failed to serialize config entries: {}", msg)));
        return object;
    }

    private static List<Entry> createDefaultEntries() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        entries.add(Entry.of((ParticleOptions)((ColorParticleType)((Object)VisualityParticles.SPARKLE.get())).withColor(16711613), Blocks.f_49995_, Blocks.f_152467_, Blocks.f_49998_));
        entries.add(Entry.of((ParticleOptions)((ColorParticleType)((Object)VisualityParticles.SPARKLE.get())).withColor(11861486), Blocks.f_50089_, Blocks.f_152474_));
        entries.add(Entry.of((ParticleOptions)((ColorParticleType)((Object)VisualityParticles.SPARKLE.get())).withColor(14286827), Blocks.f_50264_, Blocks.f_152479_));
        entries.add(Entry.of((ParticleOptions)((ColorParticleType)((Object)VisualityParticles.SPARKLE.get())).withColor(16698342), Blocks.f_152492_));
        entries.add(Entry.of((ParticleOptions)VisualityParticles.SOUL.get(), Direction.UP, Blocks.f_50135_, Blocks.f_50136_));
        return entries;
    }

    private record Entry(List<Block> blocks, EnumSet<Direction> directions, ParticleWithVelocity particle) {
        private static final EnumSet<Direction> ALL_DIRECTIONS = EnumSet.allOf(Direction.class);
        private static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VisualityCodecs.compressedListOf(ForgeRegistries.BLOCKS.getCodec()).fieldOf("block").forGetter(Entry::blocks), (App)Codec.optionalField((String)"direction", VisualityCodecs.compressedSetOf(Direction.f_175356_, EnumSet::copyOf)).xmap(optional -> optional.orElse(ALL_DIRECTIONS), set -> set.size() == 6 ? Optional.empty() : Optional.of(set)).forGetter(Entry::directions), (App)ParticleWithVelocity.CODEC.fieldOf("particle").forGetter(Entry::particle)).apply((Applicative)instance, Entry::new));
        private static final Codec<List<Entry>> LIST_CODEC = CODEC.listOf();

        private static Entry of(ParticleOptions options, EnumSet<Direction> directions, Block ... blocks) {
            return new Entry(List.of(blocks), directions, ParticleWithVelocity.ofZeroVelocity(options));
        }

        private static Entry of(ParticleOptions options, Block ... blocks) {
            return new Entry(List.of(blocks), ALL_DIRECTIONS, ParticleWithVelocity.ofZeroVelocity(options));
        }

        private static Entry of(ParticleOptions options, Direction direction, Block ... blocks) {
            return new Entry(List.of(blocks), EnumSet.of(direction), ParticleWithVelocity.ofZeroVelocity(options));
        }
    }
}

