/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.teamesync.mixins;

import cn.leomc.teamprojecte.TPTeam;
import cn.leomc.teamprojecte.TeamKnowledgeProvider;
import java.math.BigInteger;
import java.util.UUID;
import java.util.function.Supplier;
import moze_intel.projecte.api.ItemInfo;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TeamKnowledgeProvider.class}, remap=false)
public abstract class TeamKnowledgeProviderMixin {
    @Shadow
    @Final
    private Supplier<UUID> playerUUID;

    @Shadow
    protected abstract TPTeam getTeam();

    @Shadow
    public abstract BigInteger getEmc();

    @Inject(method={"deserializeNBT(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="HEAD")})
    private void deserializeNBT_teamesync(CompoundTag properties, CallbackInfo ci) {
        if (!properties.m_128471_("savedOnTeam") && properties.m_128441_("transmutationEmc")) {
            TPTeam team = this.getTeam();
            String transmutationEmc = properties.m_128461_("transmutationEmc");
            BigInteger emc = transmutationEmc.isEmpty() ? BigInteger.ZERO : new BigInteger(transmutationEmc);
            team.setEmc(emc, this.playerUUID.get());
            ListTag list = properties.m_128437_("knowledge", 10);
            for (int i = 0; i < list.size(); ++i) {
                ItemInfo info = ItemInfo.read((CompoundTag)list.m_128728_(i));
                if (info == null) continue;
                team.addKnowledge(info, this.playerUUID.get());
            }
            team.setFullKnowledge(properties.m_128471_("fullknowledge"), this.playerUUID.get());
        }
    }

    @Inject(method={"serializeNBT()Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="TAIL")})
    private void serializeNBT_teamsync(CallbackInfoReturnable<CompoundTag> cir) {
        TPTeam team = this.getTeam();
        int divider = team.getMembers().size() + 1;
        BigInteger pemc = team.getEmc(this.playerUUID.get()).divide(BigInteger.valueOf(divider));
        ((CompoundTag)cir.getReturnValue()).m_128359_("transmutationEmc", pemc.toString());
        ((CompoundTag)cir.getReturnValue()).m_128379_("savedOnTeam", true);
    }

    @Inject(method={"serializeForClient"}, at={@At(value="TAIL")})
    private void serializeForClient_teamsync(CallbackInfoReturnable<CompoundTag> cir) {
        ((CompoundTag)cir.getReturnValue()).m_128379_("savedOnTeam", true);
    }
}

