/*
 * Decompiled with CFR 0.152.
 */
package com.Pdiddy973.AllTheCompressed.overlay;

import com.Pdiddy973.AllTheCompressed.AllTheCompressed;
import com.Pdiddy973.AllTheCompressed.ModRegistry;
import com.Pdiddy973.AllTheCompressed.overlay.OverlayBlock;
import com.Pdiddy973.AllTheCompressed.overlay.OverlayPillarBlock;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class OverlayEntry {
    public final ResourceLocation parent;
    public final RegistryObject<Block> x1;
    public final RegistryObject<Block> x2;
    public final RegistryObject<Block> x3;
    public final RegistryObject<Block> x4;
    public final RegistryObject<Block> x5;
    public final RegistryObject<Block> x6;
    public final RegistryObject<Block> x7;
    public final RegistryObject<Block> x8;
    public final RegistryObject<Block> x9;
    public final List<RegistryObject<Block>> xall;
    public final RegistryObject<BlockItem> i1;
    public final RegistryObject<BlockItem> i2;
    public final RegistryObject<BlockItem> i3;
    public final RegistryObject<BlockItem> i4;
    public final RegistryObject<BlockItem> i5;
    public final RegistryObject<BlockItem> i6;
    public final RegistryObject<BlockItem> i7;
    public final RegistryObject<BlockItem> i8;
    public final RegistryObject<BlockItem> i9;
    public final List<RegistryObject<BlockItem>> iall;
    private boolean blockLoaded = false;
    private static final BlockBehaviour.Properties defaultProperties = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60978_(1.0f);

    public boolean isBlockLoaded() {
        return this.blockLoaded;
    }

    public OverlayEntry(ResourceLocation parent) {
        this.parent = parent;
        Supplier<BlockBehaviour.Properties> properties = this.getProperties(parent);
        boolean pillar = parent.m_135815_().endsWith("_log");
        this.x1 = OverlayEntry.block(parent, properties, 1, pillar);
        this.x2 = OverlayEntry.block(parent, properties, 2, pillar);
        this.x3 = OverlayEntry.block(parent, properties, 3, pillar);
        this.x4 = OverlayEntry.block(parent, properties, 4, pillar);
        this.x5 = OverlayEntry.block(parent, properties, 5, pillar);
        this.x6 = OverlayEntry.block(parent, properties, 6, pillar);
        this.x7 = OverlayEntry.block(parent, properties, 7, pillar);
        this.x8 = OverlayEntry.block(parent, properties, 8, pillar);
        this.x9 = OverlayEntry.block(parent, properties, 9, pillar);
        this.xall = List.of(this.x1, this.x2, this.x3, this.x4, this.x5, this.x6, this.x7, this.x8, this.x9);
        this.i1 = OverlayEntry.blockItem(this.x1);
        this.i2 = OverlayEntry.blockItem(this.x2);
        this.i3 = OverlayEntry.blockItem(this.x3);
        this.i4 = OverlayEntry.blockItem(this.x4);
        this.i5 = OverlayEntry.blockItem(this.x5);
        this.i6 = OverlayEntry.blockItem(this.x6);
        this.i7 = OverlayEntry.blockItem(this.x7);
        this.i8 = OverlayEntry.blockItem(this.x8);
        this.i9 = OverlayEntry.blockItem(this.x9);
        this.iall = List.of(this.i1, this.i2, this.i3, this.i4, this.i5, this.i6, this.i7, this.i8, this.i9);
    }

    private Supplier<BlockBehaviour.Properties> getProperties(ResourceLocation parent) {
        return Suppliers.memoize(() -> {
            BlockBehaviour.Properties properties = defaultProperties;
            if (ModList.get().isLoaded(parent.m_135827_())) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(parent);
                if (block != null) {
                    this.blockLoaded = true;
                    properties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)block);
                } else {
                    AllTheCompressed.LOGGER.error("Trying to register an overlay for a block that doesn't exist! {}", (Object)parent);
                }
            }
            return properties;
        });
    }

    private static RegistryObject<BlockItem> blockItem(RegistryObject<Block> registryObject) {
        return ModRegistry.ITEMS.register(registryObject.getId().m_135815_(), () -> new BlockItem((Block)registryObject.get(), new Item.Properties()));
    }

    private static RegistryObject<Block> block(ResourceLocation parent, Supplier<BlockBehaviour.Properties> properties, int level, boolean pillar) {
        Supplier<Block> supplier = pillar ? () -> new OverlayPillarBlock((BlockBehaviour.Properties)properties.get(), level) : () -> new OverlayBlock((BlockBehaviour.Properties)properties.get(), level);
        return ModRegistry.BLOCKS.register(OverlayEntry.generateName(parent, level), supplier);
    }

    private static String generateName(ResourceLocation parent, int level) {
        return String.format("%s_%dx", parent.m_135815_(), level);
    }
}

