/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.potion.effect;

import com.lothrazar.cyclic.net.PacketPlayerSyncToClient;
import com.lothrazar.cyclic.potion.CyclicMobEffect;
import com.lothrazar.cyclic.registry.PacketRegistry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;

public class FlightMayflyEffect
extends CyclicMobEffect {
    public FlightMayflyEffect(MobEffectCategory typeIn, int liquidColorIn) {
        super(typeIn, liquidColorIn);
    }

    private static void setMayFlyFromServer(LivingEntity entity, boolean mayflyIn) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            sp.m_150110_().f_35936_ = mayflyIn;
            if (!mayflyIn) {
                sp.m_150110_().f_35935_ = false;
            }
            PacketRegistry.INSTANCE.sendTo((Object)new PacketPlayerSyncToClient(mayflyIn), sp.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @Override
    public void onPotionAdded(MobEffectEvent.Added event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.m_150110_().f_35936_) {
                FlightMayflyEffect.setMayFlyFromServer(event.getEntity(), true);
            }
        }
    }

    @Override
    public void isPotionApplicable(MobEffectEvent.Applicable event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_7500_()) {
                event.setResult(Event.Result.DENY);
            }
        } else {
            event.setResult(Event.Result.DENY);
        }
    }

    @Override
    public void onPotionRemove(MobEffectEvent.Remove event) {
        FlightMayflyEffect.setMayFlyFromServer(event.getEntity(), false);
    }

    @Override
    public void onPotionExpiry(MobEffectEvent.Expired event) {
        FlightMayflyEffect.setMayFlyFromServer(event.getEntity(), false);
    }
}

