/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.net;

import com.lothrazar.cyclic.block.soundrecord.TileSoundRecorder;
import com.lothrazar.library.packet.PacketFlib;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketRecordSound
extends PacketFlib {
    private String sound;
    private BlockPos pos;

    public PacketRecordSound(String s, BlockPos n) {
        this.sound = s;
        this.pos = n;
    }

    public static PacketRecordSound decode(FriendlyByteBuf buf) {
        String s = buf.m_130277_();
        CompoundTag tags = buf.m_130260_();
        return new PacketRecordSound(s, new BlockPos(tags.m_128451_("x"), tags.m_128451_("y"), tags.m_128451_("z")));
    }

    public static void encode(PacketRecordSound msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.sound);
        CompoundTag tags = new CompoundTag();
        tags.m_128405_("x", msg.pos.m_123341_());
        tags.m_128405_("y", msg.pos.m_123342_());
        tags.m_128405_("z", msg.pos.m_123343_());
        buf.m_130079_(tags);
    }

    public static void handle(PacketRecordSound message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            BlockEntity tile = sender.m_9236_().m_7702_(message.pos);
            if (tile instanceof TileSoundRecorder) {
                ((TileSoundRecorder)tile).onSoundHeard(message.sound);
            }
        });
        message.done(ctx);
    }
}

