/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.ender;

import com.lothrazar.cyclic.registry.EntityRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;

public class EntityDungeonEye
extends ThrowableItemProjectile {
    private static final double DISTLIMIT = 0.8;
    private static final double VERT = (double)0.015f;
    private static final double HORIZ = 0.0025;
    private double targetX;
    private double targetY;
    private double targetZ;
    private boolean isLost = true;

    public EntityDungeonEye(EntityType<? extends ThrowableItemProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public EntityDungeonEye(LivingEntity livingEntityIn, Level worldIn) {
        super((EntityType)EntityRegistry.DUNGEON.get(), livingEntityIn, worldIn);
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128347_("sp_target_x", this.targetX);
        compound.m_128347_("sp_target_y", this.targetY);
        compound.m_128347_("sp_target_z", this.targetZ);
        compound.m_128405_("ticksExisted", this.f_19797_);
        compound.m_128379_("isLost", this.isLost);
        super.m_7380_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.targetX = compound.m_128459_("sp_target_x");
        this.targetY = compound.m_128459_("sp_target_y");
        this.targetZ = compound.m_128459_("sp_target_z");
        this.f_19797_ = compound.m_128451_("ticksExisted");
        this.isLost = compound.m_128471_("isLost");
    }

    public void moveTowards(BlockPos pos) {
        this.targetX = pos.m_123341_();
        this.targetY = pos.m_123342_();
        this.targetZ = pos.m_123343_();
        this.isLost = false;
        this.m_6686_(this.targetX, this.targetY, this.targetZ, this.m_7139_(), 0.01f);
    }

    public void m_8119_() {
        if (this.isLost) {
            return;
        }
        if (!this.m_9236_().f_46443_) {
            double posX = this.m_20185_();
            double posY = this.m_20186_();
            double posZ = this.m_20189_();
            this.f_19790_ = posX;
            this.f_19791_ = posY;
            this.f_19792_ = posZ;
            double motionX = this.m_20184_().f_82479_;
            double motionY = this.m_20184_().f_82480_;
            double motionZ = this.m_20184_().f_82481_;
            this.m_6034_(posX += motionX, posY += motionY, posZ += motionZ);
            double f = Math.sqrt(motionX * motionX + motionZ * motionZ);
            double distX = Math.abs(this.targetX - posX);
            double distY = Math.abs(this.targetY - posY);
            double distZ = Math.abs(this.targetZ - posZ);
            float distance = (float)Math.sqrt(distX * distX + distZ * distZ);
            float distLine = (float)Math.sqrt(distX * distX + distZ * distZ + distY * distY);
            float atan = (float)Mth.m_14136_((double)(this.targetZ - posZ), (double)(this.targetX - posX));
            double horizFactor = f + ((double)distance - f) * 0.0025;
            if (distLine < 1.0f) {
                horizFactor *= 0.8;
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            motionX = Math.cos(atan) * horizFactor;
            motionZ = Math.sin(atan) * horizFactor;
            motionY = 14.0 * distY / (double)distLine * (double)0.015f;
            this.m_20334_(motionX, motionY, motionZ);
            if (distX < 0.8 && distZ < 0.8) {
                motionX = 0.0;
                motionZ = 0.0;
                if (distY < 0.8) {
                    motionY = 0.0;
                }
            }
            if (posY < this.targetY) {
                if (motionY < 0.0) {
                    motionY *= -1.0;
                }
            } else if (motionY > 0.0) {
                motionY *= -1.0;
            }
            double speedHReduction = 1.0;
            double speedVReduction = 1.0;
            if (this.f_19797_ < 20) {
                speedHReduction = 2.2;
                speedVReduction = 12.2;
            }
            if (this.f_19797_ < 40) {
                speedHReduction = 1.8;
                speedVReduction = 10.0;
            } else if (this.f_19797_ < 100) {
                speedHReduction = 1.2;
                speedVReduction = 6.0;
            } else if (this.f_19797_ < 150) {
                speedHReduction = 1.1;
                speedVReduction = 2.0;
            } else if (this.f_19797_ < 500) {
                speedHReduction = 1.0;
                speedVReduction = 1.1;
            }
            motionX /= speedHReduction;
            motionY /= speedVReduction;
            motionZ /= speedHReduction;
            if (this.f_19797_ > 9999) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if (motionX == 0.0 && motionY == 0.0 && motionZ == 0.0) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            this.m_20334_(motionX, motionY, motionZ);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected Item m_7881_() {
        return (Item)ItemRegistry.SPAWNER_SEEKER.get();
    }

    protected void m_6532_(HitResult result) {
    }
}

