/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.builder;

import com.lothrazar.cyclic.item.ItemBaseCyclic;
import com.lothrazar.cyclic.item.builder.BuildStyle;
import com.lothrazar.cyclic.item.builder.BuilderActionType;
import com.lothrazar.cyclic.item.builder.PacketSwapBlock;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.library.util.ChatUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BuilderItem
extends ItemBaseCyclic {
    public BuildStyle style;

    public BuilderItem(Item.Properties properties, BuildStyle t) {
        super(properties.m_41487_(1).m_41503_(4096));
        this.style = t;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        String msg = ChatFormatting.GREEN + ChatUtil.lang((String)BuilderActionType.getName(stack));
        tooltip.add((Component)Component.m_237115_((String)msg));
        BlockState target = BuilderActionType.getBlockState(worldIn, stack);
        String block = "scepter.cyclic.nothing";
        if (target != null) {
            block = target.m_60734_().m_7705_();
        }
        tooltip.add((Component)Component.m_237115_((String)(ChatFormatting.AQUA + ChatUtil.lang((String)block))));
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        BuilderActionType.tickTimeout(stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        BlockPos pos = context.m_8083_();
        Direction side = context.m_43719_();
        BuildStyle buildStyle = ((BuilderItem)stack.m_41720_()).style;
        if (side != null && buildStyle.isOffset()) {
            pos = pos.m_121945_(side);
        }
        if (context.m_43725_().f_46443_) {
            BuilderActionType type = BuilderItem.getActionType(stack);
            PacketSwapBlock message = new PacketSwapBlock(pos, type, side, context.m_43724_());
            PacketRegistry.INSTANCE.sendToServer((Object)message);
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    public static BuilderActionType getActionType(ItemStack stack) {
        BuilderActionType type = BuilderActionType.values()[BuilderActionType.get(stack)];
        return type;
    }

    public static ItemStack getIfHeld(Player player) {
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof BuilderItem) {
            return heldItem;
        }
        heldItem = player.m_21206_();
        if (heldItem.m_41720_() instanceof BuilderItem) {
            return heldItem;
        }
        return ItemStack.f_41583_;
    }
}

