/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.forester;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.forester.ContainerForester;
import com.lothrazar.cyclic.data.PreviewOutlineType;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.library.cap.CustomEnergyStorage;
import com.lothrazar.library.util.ShapeUtil;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileForester
extends TileBlockEntityCyclic
implements MenuProvider {
    static final int MAX = 64000;
    static final int MAX_HEIGHT = 32;
    static final int MAX_SIZE = 12;
    public static ForgeConfigSpec.IntValue POWERCONF;
    private int height = 32;
    private int radius = 12;
    private BlockPos targetPos = null;
    CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    ItemStackHandler inventory = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return TileForester.this.isSapling(stack);
        }
    };
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private WeakReference<FakePlayer> fakePlayer;
    private int shapeIndex = 0;

    public TileForester(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.FORESTER.get(), pos, state);
        this.needsRedstone = 1;
        this.render = 0;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileForester e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileForester e) {
        e.tick();
    }

    public void tick() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        this.setLitProperty(true);
        if (this.f_58857_.f_46443_) {
            return;
        }
        int cost = (Integer)POWERCONF.get();
        if (this.energy.getEnergyStored() < cost && cost > 0) {
            return;
        }
        List<BlockPos> shape = this.getShape();
        if (shape.size() == 0) {
            return;
        }
        ++this.shapeIndex;
        this.targetPos = this.getShapeTarget(shape);
        try {
            if (this.fakePlayer == null && this.f_58857_ instanceof ServerLevel) {
                this.fakePlayer = this.setupBeforeTrigger((ServerLevel)this.f_58857_, "forester");
            }
            this.equipTool();
            ItemStack dropMe = this.inventory.getStackInSlot(0).m_41777_();
            if (this.isTree(this.targetPos)) {
                if (TileBlockEntityCyclic.tryHarvestBlock(this.fakePlayer, this.f_58857_, this.targetPos)) {
                    this.energy.extractEnergy(cost, false);
                }
            } else if (this.isSapling(dropMe)) {
                InteractionResult result = TileBlockEntityCyclic.interactUseOnBlock(this.fakePlayer, this.f_58857_, this.targetPos, InteractionHand.OFF_HAND, Direction.DOWN);
                if (result == InteractionResult.CONSUME) {
                    this.updateComparatorOutputLevel();
                }
                this.energy.extractEnergy(cost, false);
            }
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("Forester action item error", e);
        }
    }

    public AABB getRenderBoundingBox() {
        return BlockEntity.INFINITE_EXTENT_AABB;
    }

    public Component m_5446_() {
        return ((Block)BlockRegistry.FORESTER.get()).m_49954_();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerForester(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.height = tag.m_128451_("height");
        this.shapeIndex = tag.m_128451_("shapeIndex");
        this.radius = tag.m_128451_("radius");
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("height", this.height);
        tag.m_128405_("shapeIndex", this.shapeIndex);
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        tag.m_128405_("radius", this.radius);
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        super.m_183515_(tag);
    }

    private void equipTool() {
        if (this.fakePlayer == null) {
            return;
        }
        TileBlockEntityCyclic.tryEquipItem(this.inventoryCap, this.fakePlayer, 0, InteractionHand.OFF_HAND);
        if (((FakePlayer)this.fakePlayer.get()).m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            ItemStack tool = new ItemStack((ItemLike)Items.f_42391_);
            tool.m_41663_(Enchantments.f_44987_, 3);
            TileBlockEntityCyclic.tryEquipItem(tool, this.fakePlayer, InteractionHand.MAIN_HAND);
        }
    }

    private BlockPos getShapeTarget(List<BlockPos> shape) {
        if (this.shapeIndex < 0 || this.shapeIndex >= shape.size()) {
            this.shapeIndex = 0;
        }
        return shape.get(this.shapeIndex);
    }

    private int heightWithDirection() {
        Direction blockFacing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        int diff = 1;
        if (blockFacing.m_122434_().m_122478_()) {
            diff = blockFacing == Direction.UP ? 1 : -1;
        }
        return diff * this.height;
    }

    public List<BlockPos> getShape() {
        BlockPos center = this.getFacingShapeCenter(this.radius);
        List shape = ShapeUtil.cubeSquareBase((BlockPos)center, (int)this.radius, (int)0);
        int heightWithDirection = this.heightWithDirection();
        if (heightWithDirection != 0) {
            shape = ShapeUtil.repeatShapeByHeight((List)shape, (int)heightWithDirection);
        }
        return shape;
    }

    public List<BlockPos> getShapeHollow() {
        BlockPos center = this.getFacingShapeCenter(this.radius);
        List shape = ShapeUtil.squareHorizontalHollow((BlockPos)center, (int)this.radius);
        int heightWithDirection = this.heightWithDirection();
        if (heightWithDirection != 0) {
            shape = ShapeUtil.repeatShapeByHeight((List)shape, (int)heightWithDirection);
        }
        if (this.targetPos != null) {
            shape.add(this.targetPos);
        }
        return shape;
    }

    private boolean isSapling(ItemStack dropMe) {
        BlockState block = Block.m_49814_((Item)dropMe.m_41720_()).m_49966_();
        return block.m_204336_(BlockTags.f_13104_) || block.m_60734_() instanceof SaplingBlock;
    }

    private boolean isTree(BlockPos targetPos) {
        if (targetPos == null) {
            return false;
        }
        BlockState block = this.f_58857_.m_8055_(targetPos);
        return block.m_204336_(BlockTags.f_13106_) || block.m_204336_(BlockTags.f_13035_);
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
            case SIZE: {
                return this.radius;
            }
            case HEIGHT: {
                return this.height;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case RENDER: {
                this.render = value % PreviewOutlineType.values().length;
                break;
            }
            case SIZE: {
                this.radius = Math.min(value, 12);
                break;
            }
            case HEIGHT: {
                this.height = Math.min(value, 32);
            }
        }
    }

    public boolean hasSapling() {
        return !this.inventory.getStackInSlot(0).m_41619_();
    }

    static enum Fields {
        REDSTONE,
        RENDER,
        SIZE,
        HEIGHT;

    }
}

