/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.network;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.rftoolsdim.dimension.data.ClientDimensionData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public record PackagePropageDataToClients(Map<ResourceLocation, ClientDimensionData.ClientData> clientDataMap, long seed) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("rftoolsdim", "propagate_data_to_clients");

    public static PackagePropageDataToClients create(FriendlyByteBuf buf) {
        int size = buf.readInt();
        HashMap<ResourceLocation, ClientDimensionData.ClientData> clientDataMap = new HashMap<ResourceLocation, ClientDimensionData.ClientData>(size);
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = buf.m_130281_();
            clientDataMap.put(id, ClientDimensionData.ClientData.create(buf));
        }
        long seed = buf.readLong();
        return new PackagePropageDataToClients(clientDataMap, seed);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.clientDataMap.size());
        for (Map.Entry<ResourceLocation, ClientDimensionData.ClientData> entry : this.clientDataMap.entrySet()) {
            buf.m_130085_(entry.getKey());
            entry.getValue().writeToBuf(buf);
        }
        buf.writeLong(this.seed);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> ClientDimensionData.get().updateDataFromServer(this.clientDataMap, this.seed));
    }
}

