/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.integrateddynamics.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class SqueezerRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object[] itemOutput;
    public final Object fluidOutput;
    public final int fluidOutputAmount;

    public SqueezerRecipeSerializer(ResourceLocation key, Object input, Object[] itemOutput) {
        this(key, input, itemOutput, Fluids.f_76191_, 0);
    }

    public SqueezerRecipeSerializer(ResourceLocation key, Object input, Object[] itemOutput, Object fluidOutput, int fluidOutputAmount) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.itemOutput = itemOutput;
        this.fluidOutput = fluidOutput;
        this.fluidOutputAmount = fluidOutputAmount;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.input));
        }
        ArrayList<Pair> itemResults = new ArrayList<Pair>();
        int i = 0;
        while (i < this.itemOutput.length) {
            ItemStack stack;
            Object out = this.itemOutput[i];
            Integer count = 1;
            if (++i < this.itemOutput.length && this.itemOutput[i] instanceof Integer) {
                count = (Integer)this.itemOutput[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.itemOutput.length && this.itemOutput[i] instanceof Float) {
                chance = (Float)this.itemOutput[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).m_41619_()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            itemResults.add(Pair.of((Object)stack, (Object)chance));
        }
        FluidStack fluidStack = MiscHelper.INSTANCE.getFluidStack(this.fluidOutput, this.fluidOutputAmount);
        if (itemResults.isEmpty() && fluidStack.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + String.valueOf(this.key) + ": " + Arrays.deepToString(this.itemOutput) + ", " + String.valueOf(this.fluidOutput));
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "integrateddynamics:squeezer");
        json.add("item", ing.m_43942_());
        JsonObject resultJson = new JsonObject();
        JsonArray itemResultJson = new JsonArray();
        for (Pair pair : itemResults) {
            JsonObject outputJson = new JsonObject();
            outputJson.add("item", (JsonElement)MiscHelper.INSTANCE.serializeItemStack((ItemStack)pair.getLeft()));
            outputJson.addProperty("chance", (Number)pair.getRight());
            itemResultJson.add((JsonElement)outputJson);
        }
        resultJson.add("items", (JsonElement)itemResultJson);
        if (!fluidStack.isEmpty()) {
            resultJson.add("fluid", (JsonElement)MiscHelper.INSTANCE.serializeFluidStack(fluidStack));
        }
        json.add("result", (JsonElement)resultJson);
        return json;
    }
}

