/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.bloodmagic;

import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import thelm.jaopca.api.fluids.IFluidLike;
import thelm.jaopca.compat.bloodmagic.recipes.ARCRecipeSerializer;
import thelm.jaopca.compat.bloodmagic.recipes.AlchemyTableRecipeSerializer;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;
import wayoftime.bloodmagic.recipe.helper.FluidStackIngredient;

public class BloodMagicHelper {
    public static final BloodMagicHelper INSTANCE = new BloodMagicHelper();

    private BloodMagicHelper() {
    }

    public FluidStackIngredient getFluidStackIngredient(Object obj, int amount) {
        return (FluidStackIngredient)this.getFluidStackIngredientResolved(obj, amount).getLeft();
    }

    public Pair<FluidStackIngredient, Set<Fluid>> getFluidStackIngredientResolved(Object obj, int amount) {
        FluidStackIngredient ing = null;
        HashSet<Fluid> fluids = new HashSet<Fluid>();
        MiscHelper helper = MiscHelper.INSTANCE;
        if (obj instanceof Supplier) {
            Pair<FluidStackIngredient, Set<Fluid>> pair = this.getFluidStackIngredientResolved(((Supplier)obj).get(), amount);
            ing = (FluidStackIngredient)pair.getLeft();
            fluids.addAll((Collection)pair.getRight());
        } else if (obj instanceof FluidStackIngredient) {
            ing = (FluidStackIngredient)obj;
            fluids.addAll(ForgeRegistries.FLUIDS.getValues());
        } else if (obj instanceof String) {
            ResourceLocation location = new ResourceLocation((String)obj);
            ing = FluidStackIngredient.from(helper.getFluidTagKey(location), (int)amount);
            fluids.addAll(helper.getFluidTagValues(location));
        } else if (obj instanceof ResourceLocation) {
            ResourceLocation location = (ResourceLocation)obj;
            ing = FluidStackIngredient.from(helper.getFluidTagKey(location), (int)amount);
            fluids.addAll(helper.getFluidTagValues(location));
        } else if (obj instanceof TagKey) {
            TagKey key = (TagKey)obj;
            ing = FluidStackIngredient.from((TagKey)key, (int)amount);
            fluids.addAll(helper.getFluidTagValues(key.f_203868_()));
        } else if (obj instanceof FluidStack) {
            FluidStack stack = (FluidStack)obj;
            if (!stack.isEmpty()) {
                ing = FluidStackIngredient.from((FluidStack)stack);
                fluids.add(stack.getFluid());
            }
        } else if (obj instanceof FluidStack[]) {
            FluidStack[] stacks = (FluidStack[])obj;
            List<FluidStack> nonEmpty = Arrays.stream(stacks).filter(s -> !s.isEmpty()).toList();
            if (!nonEmpty.isEmpty()) {
                ing = FluidStackIngredient.createMulti((FluidStackIngredient[])((FluidStackIngredient[])nonEmpty.stream().map(FluidStackIngredient::from).toArray(FluidStackIngredient[]::new)));
                nonEmpty.stream().map(FluidStack::getFluid).forEach(fluids::add);
            }
        } else if (obj instanceof Fluid) {
            Fluid fluid = (Fluid)obj;
            if (fluid != Fluids.f_76191_) {
                ing = FluidStackIngredient.from((Fluid)fluid, (int)amount);
                fluids.add(fluid);
            }
        } else if (obj instanceof Fluid[]) {
            Fluid[] fluidz = (Fluid[])obj;
            List<Fluid> nonEmpty = Arrays.stream(fluidz).filter(f -> f != Fluids.f_76191_).toList();
            if (!nonEmpty.isEmpty()) {
                ing = FluidStackIngredient.createMulti((FluidStackIngredient[])((FluidStackIngredient[])nonEmpty.stream().map(f -> FluidStackIngredient.from((Fluid)f, (int)amount)).toArray(FluidStackIngredient[]::new)));
                fluids.addAll(nonEmpty);
            }
        } else if (obj instanceof IFluidLike) {
            IFluidLike fluid = (IFluidLike)obj;
            if (fluid.asFluid() != Fluids.f_76191_) {
                ing = FluidStackIngredient.from((Fluid)fluid.asFluid(), (int)amount);
                fluids.add(fluid.asFluid());
            }
        } else if (obj instanceof IFluidLike[]) {
            IFluidLike[] fluidz = (IFluidLike[])obj;
            List<Fluid> nonEmpty = Arrays.stream(fluidz).map(IFluidLike::asFluid).filter(f -> f != Fluids.f_76191_).toList();
            if (!nonEmpty.isEmpty()) {
                ing = FluidStackIngredient.createMulti((FluidStackIngredient[])((FluidStackIngredient[])nonEmpty.stream().map(f -> FluidStackIngredient.from((Fluid)f, (int)amount)).toArray(FluidStackIngredient[]::new)));
                fluids.addAll(nonEmpty);
            }
        } else if (obj instanceof JsonElement) {
            ing = FluidStackIngredient.deserialize((JsonElement)((JsonElement)obj));
            fluids.addAll(ForgeRegistries.FLUIDS.getValues());
        }
        fluids.remove(Fluids.f_76191_);
        return Pair.of((Object)(fluids.isEmpty() ? null : ing), fluids);
    }

    public boolean registerAlchemyTableRecipe(ResourceLocation key, Object[] input, Object output, int count, int cost, int time, int minTier) {
        return ApiImpl.INSTANCE.registerRecipe(key, new AlchemyTableRecipeSerializer(key, input, output, count, cost, time, minTier));
    }

    public boolean registerARCRecipe(ResourceLocation key, Object input, int inputCount, Object tool, Object fluidInput, int fluidInputAmount, Object[] output, Object fluidOutput, int fluidOutputAmount, boolean consumeInput) {
        return ApiImpl.INSTANCE.registerRecipe(key, new ARCRecipeSerializer(key, input, inputCount, tool, fluidInput, fluidInputAmount, output, fluidOutput, fluidOutputAmount, consumeInput));
    }

    public boolean registerARCRecipe(ResourceLocation key, Object input, int inputCount, Object tool, Object[] output, boolean consumeInput) {
        return ApiImpl.INSTANCE.registerRecipe(key, new ARCRecipeSerializer(key, input, inputCount, tool, output, consumeInput));
    }
}

