/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarEntity;
import com.hollingsworth.arsnouveau.common.event.FamiliarEvents;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class PacketDispelFamiliars {
    public PacketDispelFamiliars() {
    }

    public PacketDispelFamiliars(FriendlyByteBuf buf) {
    }

    public void toBytes(FriendlyByteBuf buf) {
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getSender() != null) {
                ServerPlayer owner = ((NetworkEvent.Context)ctx.get()).getSender();
                PacketDispelFamiliars.dispelForPlayer((Entity)owner);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static boolean dispelForPlayer(Entity owner) {
        boolean removedFamiliar = false;
        for (FamiliarEntity familiarEntity : FamiliarEvents.getFamiliars(i -> i.getOwnerID() == null || i.getOwnerID().equals(owner.m_20148_()))) {
            familiarEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            ParticleUtil.spawnPoof((ServerLevel)owner.f_19853_, familiarEntity.getThisEntity().m_20183_());
            removedFamiliar = true;
        }
        if (removedFamiliar) {
            PortUtil.sendMessage(owner, (Component)Component.m_237115_((String)"ars_nouveau.removed_familiars"));
        }
        return removedFamiliar;
    }
}

