/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.familiar;

import com.hollingsworth.arsnouveau.api.event.SpellCostCalcEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.common.entity.Whirlisprig;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarEntity;
import com.hollingsworth.arsnouveau.common.entity.familiar.FlyingFamiliarEntity;
import com.hollingsworth.arsnouveau.common.entity.familiar.ISpellCastListener;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class FamiliarWhirlisprig
extends FlyingFamiliarEntity
implements ISpellCastListener {
    public FamiliarWhirlisprig(EntityType<? extends PathfinderMob> ent, Level world) {
        super(ent, world);
    }

    public InteractionResult m_7111_(Player pPlayer, Vec3 pVec, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND || pPlayer.m_20193_().f_46443_) {
            return InteractionResult.PASS;
        }
        ItemStack stack = pPlayer.m_21120_(hand);
        String color = Whirlisprig.getColorFromStack(stack);
        if (color != null && !this.getColor().equals(color)) {
            this.setColor(color);
            stack.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        return super.m_7111_(pPlayer, pVec, hand);
    }

    @Override
    public void onCostCalc(SpellCostCalcEvent event) {
        if (!this.m_6084_()) {
            return;
        }
        if (this.getOwner() != null && this.getOwner().equals((Object)event.context.getUnwrappedCaster())) {
            int discount = 0;
            Spell spell = event.context.getSpell();
            for (AbstractSpellPart part : spell.recipe) {
                if (!SpellSchools.ELEMENTAL_EARTH.isPartOfSchool(part)) continue;
                discount = (int)((double)discount + (double)part.getCastingCost() * 0.5);
            }
            event.currentCost -= discount;
        }
    }

    public void eatEvent(LivingEntityUseItemEvent.Finish event) {
        FoodProperties food;
        if (!this.m_6084_()) {
            return;
        }
        if (!event.getEntity().f_19853_.f_46443_ && this.getOwner() != null && this.getOwner().equals((Object)event.getEntity()) && (food = event.getItem().m_41720_().getFoodProperties(event.getItem(), this.getOwner())) != null && event.getItem().m_41720_().m_41472_()) {
            float saturationModifier = food.m_38745_();
            int nutrition = food.m_38744_();
            float satAmount = (float)nutrition * saturationModifier * 2.0f;
            if (event.getEntity() instanceof Player) {
                FoodData stats = ((Player)event.getEntity()).m_36324_();
                stats.f_38697_ += satAmount * 0.4f;
            }
        }
    }

    @Override
    public PlayState walkPredicate(AnimationState event) {
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("fly"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
        }
        return PlayState.CONTINUE;
    }

    public EntityType<?> m_6095_() {
        return (EntityType)ModEntities.ENTITY_FAMILIAR_SYLPH.get();
    }

    @Override
    public ResourceLocation getTexture(FamiliarEntity entity) {
        return new ResourceLocation("ars_nouveau", "textures/entity/whirlisprig_" + (this.getColor().isEmpty() ? "summer" : this.getColor().toLowerCase()) + ".png");
    }
}

