/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.device;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import sonar.fluxnetworks.api.FluxCapabilities;
import sonar.fluxnetworks.api.device.FluxDeviceType;
import sonar.fluxnetworks.api.device.IFluxPlug;
import sonar.fluxnetworks.api.energy.IFNEnergyStorage;
import sonar.fluxnetworks.common.device.FluxPlugHandler;
import sonar.fluxnetworks.common.device.TileFluxConnector;
import sonar.fluxnetworks.common.util.FluxGuiStack;
import sonar.fluxnetworks.common.util.FluxUtils;
import sonar.fluxnetworks.register.RegistryBlockEntityTypes;

public class TileFluxPlug
extends TileFluxConnector
implements IFluxPlug {
    private final FluxPlugHandler mHandler = new FluxPlugHandler();
    private final LazyOptional<?>[] mEnergyCaps = new LazyOptional[FluxUtils.DIRECTIONS.length];

    public TileFluxPlug(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        super((BlockEntityType)RegistryBlockEntityTypes.FLUX_PLUG.get(), pos, state);
    }

    @Override
    @Nonnull
    public FluxDeviceType getDeviceType() {
        return FluxDeviceType.PLUG;
    }

    @Override
    @Nonnull
    public FluxPlugHandler getTransferHandler() {
        return this.mHandler;
    }

    @Override
    @Nonnull
    public ItemStack getDisplayStack() {
        return FluxGuiStack.FLUX_PLUG;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        int e = this.mEnergyCaps.length;
        for (int i = 0; i < e; ++i) {
            if (this.mEnergyCaps[i] == null) continue;
            this.mEnergyCaps[i].invalidate();
            this.mEnergyCaps[i] = null;
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!(this.m_58901_() || cap != ForgeCapabilities.ENERGY && cap != FluxCapabilities.FN_ENERGY_STORAGE)) {
            int index = side == null ? 0 : side.m_122411_();
            LazyOptional handler = this.mEnergyCaps[index];
            if (handler == null) {
                EnergyStorage storage = new EnergyStorage(side == null ? Direction.m_122376_((int)0) : side);
                this.mEnergyCaps[index] = handler = LazyOptional.of(() -> storage);
            }
            return handler.cast();
        }
        return super.getCapability(cap, side);
    }

    private class EnergyStorage
    implements IEnergyStorage,
    IFNEnergyStorage {
        @Nonnull
        private final Direction mSide;

        public EnergyStorage(Direction side) {
            this.mSide = side;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (TileFluxPlug.this.getNetwork().isValid()) {
                return (int)TileFluxPlug.this.mHandler.receive(maxReceive, this.mSide, simulate, TileFluxPlug.this.getNetwork().getBufferLimiter());
            }
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return (int)Math.min(this.getEnergyStoredL(), Integer.MAX_VALUE);
        }

        public int getMaxEnergyStored() {
            return (int)Math.min(this.getMaxEnergyStoredL(), Integer.MAX_VALUE);
        }

        @Override
        public boolean canExtract() {
            return false;
        }

        @Override
        public boolean canReceive() {
            return TileFluxPlug.this.getNetwork().isValid();
        }

        @Override
        public long receiveEnergyL(long maxReceive, boolean simulate) {
            if (TileFluxPlug.this.getNetwork().isValid()) {
                return TileFluxPlug.this.mHandler.receive(maxReceive, this.mSide, simulate, TileFluxPlug.this.getNetwork().getBufferLimiter());
            }
            return 0L;
        }

        @Override
        public long extractEnergyL(long maxExtract, boolean simulate) {
            return 0L;
        }

        @Override
        public long getEnergyStoredL() {
            return TileFluxPlug.this.mHandler.getBuffer();
        }

        @Override
        public long getMaxEnergyStoredL() {
            return Math.max(TileFluxPlug.this.mHandler.getBuffer(), TileFluxPlug.this.mHandler.getLimit());
        }
    }
}

