/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.energy.EnergyType;
import sonar.fluxnetworks.client.gui.EnumNavigationTab;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiTabPages;
import sonar.fluxnetworks.client.gui.button.EditButton;
import sonar.fluxnetworks.client.gui.popup.PopupConnectionEdit;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.util.FluxUtils;
import sonar.fluxnetworks.register.ClientMessages;

public class GuiTabConnections
extends GuiTabPages<IFluxDevice> {
    public final LinkedHashSet<IFluxDevice> mSelected = new LinkedHashSet();
    public boolean mSelectionMode;
    public EditButton mMultiselect;
    public EditButton mEdit;
    public EditButton mDisconnect;
    private int timer = 0;

    public GuiTabConnections(@Nonnull FluxMenu menu, @Nonnull Player player) {
        super(menu, player);
        this.mGridHeight = 19;
        this.mGridPerPage = 7;
        this.mElementWidth = 146;
        this.mElementHeight = 18;
        if (this.getNetwork().isValid()) {
            ClientMessages.updateNetwork(this.getToken(), this.getNetwork(), (byte)23);
        }
    }

    @Override
    public EnumNavigationTab getNavigationTab() {
        return EnumNavigationTab.TAB_CONNECTION;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.mGridStartX = this.f_97735_ + 15;
        this.mGridStartY = this.f_97736_ + 22;
        if (this.getNetwork().isValid()) {
            this.mMultiselect = new EditButton(this, this.f_97735_ + 146, this.f_97736_ + 9, 128, 64, FluxTranslate.BATCH_CLEAR_BUTTON.get(), FluxTranslate.BATCH_SELECT_BUTTON.get());
            this.mEdit = new EditButton(this, this.f_97735_ + 118, this.f_97736_ + 9, 192, 192, FluxTranslate.BATCH_EDIT_BUTTON.get(), FluxTranslate.BATCH_EDIT_BUTTON.get());
            this.mEdit.setClickable(false);
            this.mDisconnect = new EditButton(this, this.f_97735_ + 132, this.f_97736_ + 9, 0, 0, FluxTranslate.BATCH_DISCONNECT_BUTTON.get(), FluxTranslate.BATCH_DISCONNECT_BUTTON.get());
            this.mDisconnect.setClickable(false);
            this.mButtons.add(this.mMultiselect);
            this.mButtons.add(this.mEdit);
            this.mButtons.add(this.mDisconnect);
        }
        this.refreshPages(this.getNetwork().getAllConnections());
    }

    @Override
    protected void drawBackgroundLayer(GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        super.drawBackgroundLayer(gr, mouseX, mouseY, deltaTicks);
        if (this.getNetwork().isValid()) {
            if (this.mSelectionMode) {
                gr.m_280488_(this.f_96547_, FluxTranslate.SELECTED.format(ChatFormatting.AQUA.toString() + this.mSelected.size() + ChatFormatting.RESET), this.f_97735_ + 20, this.f_97736_ + 10, 0xFFFFFF);
            } else {
                gr.m_280488_(this.f_96547_, FluxTranslate.SORT_BY.get() + ": " + ChatFormatting.AQUA + FluxTranslate.SORTING_SMART.get(), this.f_97735_ + 19, this.f_97736_ + 10, 0xFFFFFF);
            }
        } else {
            this.renderNavigationPrompt(gr, FluxTranslate.ERROR_NO_SELECTED, EnumNavigationTab.TAB_SELECTION);
        }
    }

    @Override
    public void renderElement(GuiGraphics gr, IFluxDevice element, int x, int y) {
        int titleY;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICON);
        int color = element.getDeviceType().mColor;
        float r = FluxUtils.getRed(color);
        float g = FluxUtils.getGreen(color);
        float b = FluxUtils.getBlue(color);
        int textColor = 0xFFFFFF;
        if (this.mSelectionMode) {
            if (this.mSelected.contains(element)) {
                gr.m_280509_(x - 5, y + 1, x - 3, y + this.mElementHeight - 1, -855638017);
                gr.m_280509_(x + this.mElementWidth + 3, y + 1, x + this.mElementWidth + 5, y + this.mElementHeight - 1, -855638017);
                RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
            } else {
                gr.m_280509_(x - 5, y + 1, x - 3, y + this.mElementHeight - 1, -1436524448);
                gr.m_280509_(x + this.mElementWidth + 3, y + 1, x + this.mElementWidth + 5, y + this.mElementHeight - 1, -1436524448);
                RenderSystem.setShaderColor((float)(r * 0.5f), (float)(g * 0.5f), (float)(b * 0.5f), (float)1.0f);
                textColor = 0xD0D0D0;
            }
        } else {
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        }
        GuiTabConnections.blitF(gr, x, y, this.mElementWidth, this.mElementHeight, 0.0f, 384.0f, this.mElementWidth * 2, this.mElementHeight * 2);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (element.isChunkLoaded()) {
            gr.m_280168_().m_85836_();
            gr.m_280168_().m_85841_(0.75f, 0.75f, 1.0f);
            gr.drawString(this.f_96547_, FluxUtils.getTransferInfo(element, EnergyType.FE), (float)(x + 20) / 0.75f, (float)(y + 10) / 0.75f, textColor, true);
            gr.m_280168_().m_85849_();
            titleY = y + 2;
        } else {
            textColor = 0x808080;
            titleY = y + 5;
        }
        if (element.getCustomName().isEmpty()) {
            gr.m_280488_(this.f_96547_, Language.m_128107_().m_6834_(element.getDisplayStack().m_41720_().m_5524_()), x + 20, titleY, textColor);
        } else {
            gr.m_280488_(this.f_96547_, element.getCustomName(), x + 21, titleY, textColor);
        }
        this.renderItemStack(gr, element.getDisplayStack(), x + 2, y + 1);
    }

    @Override
    public void renderElementTooltip(GuiGraphics gr, IFluxDevice element, int mouseX, int mouseY) {
        gr.m_280666_(this.f_96547_, this.getElementTooltips(element), mouseX, mouseY);
    }

    protected List<Component> getElementTooltips(@Nonnull IFluxDevice element) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (element.getCustomName().isEmpty()) {
            components.add((Component)Component.m_237119_().m_130940_(ChatFormatting.BOLD).m_7220_(element.getDisplayStack().m_41786_()));
        } else {
            components.add((Component)Component.m_237113_((String)element.getCustomName()).m_130940_(ChatFormatting.BOLD));
        }
        if (element.isChunkLoaded()) {
            if (element.isForcedLoading()) {
                components.add((Component)FluxTranslate.FORCED_LOADING.makeComponent().m_130940_(ChatFormatting.AQUA));
            }
            components.add((Component)Component.m_237113_((String)FluxUtils.getTransferInfo(element, EnergyType.FE)));
        } else {
            components.add((Component)FluxTranslate.CHUNK_UNLOADED.makeComponent().m_130940_(ChatFormatting.RED));
        }
        if (element.getDeviceType().isStorage()) {
            components.add((Component)Component.m_237113_((String)(FluxTranslate.ENERGY_STORED.get() + ": " + ChatFormatting.BLUE + EnergyType.FE.getStorage(element.getTransferBuffer()))));
        } else {
            components.add((Component)Component.m_237113_((String)(FluxTranslate.INTERNAL_BUFFER.get() + ": " + ChatFormatting.BLUE + EnergyType.FE.getStorage(element.getTransferBuffer()))));
        }
        components.add((Component)Component.m_237113_((String)(FluxTranslate.TRANSFER_LIMIT.get() + ": " + ChatFormatting.GREEN + (element.getDisableLimit() ? FluxTranslate.UNLIMITED.get() : EnergyType.FE.getStorage(element.getRawLimit())))));
        components.add((Component)Component.m_237113_((String)(FluxTranslate.PRIORITY.get() + ": " + ChatFormatting.GREEN + (Serializable)(element.getSurgeMode() ? FluxTranslate.SURGE.get() : Integer.valueOf(element.getRawPriority())))));
        components.add((Component)Component.m_237113_((String)FluxUtils.getDisplayPos(element.getGlobalPos())).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        components.add((Component)Component.m_237113_((String)FluxUtils.getDisplayDim(element.getGlobalPos())).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        return components;
    }

    @Override
    protected void onElementClicked(IFluxDevice element, int mouseButton) {
        if (this.mSelectionMode && (mouseButton == 0 || mouseButton == 1)) {
            if (this.mSelected.remove(element)) {
                if (this.mSelected.isEmpty()) {
                    this.mEdit.setClickable(false);
                    this.mDisconnect.setClickable(false);
                }
            } else if (element.isChunkLoaded()) {
                this.mSelected.add(element);
                this.mEdit.setClickable(true);
                this.mDisconnect.setClickable(true);
            }
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, float mouseX, float mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (button instanceof EditButton) {
            if (button == this.mMultiselect) {
                if (this.mMultiselect.isChecked()) {
                    this.mMultiselect.setChecked(false);
                    this.mSelectionMode = false;
                } else {
                    this.mMultiselect.setChecked(true);
                    this.mSelectionMode = true;
                }
                this.mSelected.clear();
                this.mEdit.setClickable(false);
                this.mDisconnect.setClickable(false);
            } else if (button == this.mEdit) {
                assert (this.mSelectionMode && !this.mSelected.isEmpty());
                this.openPopup(new PopupConnectionEdit(this));
            } else if (button == this.mDisconnect) {
                assert (this.mSelectionMode && !this.mSelected.isEmpty());
                ClientMessages.disconnect(this.getToken(), this.getNetwork(), this.mSelected);
                this.mDisconnect.setClickable(false);
            }
        }
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (super.onMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (!this.getNetwork().isValid()) {
            return this.redirectNavigationPrompt(mouseX, mouseY, mouseButton, EnumNavigationTab.TAB_SELECTION);
        }
        return false;
    }

    @Override
    protected void onResponseAction(int key, int code) {
        super.onResponseAction(key, code);
        if (code == 1) {
            this.switchTab(EnumNavigationTab.TAB_HOME, false);
            return;
        }
        if (key == 8) {
            this.refreshPages(this.getNetwork().getAllConnections());
        } else if (code == -1) {
            this.closePopup();
            if (key == 10) {
                if (this.mSelected.stream().anyMatch(f -> f.getGlobalPos().equals((Object)((IFluxDevice)((FluxMenu)this.f_97732_).mProvider).getGlobalPos()))) {
                    this.switchTab(EnumNavigationTab.TAB_HOME, false);
                    return;
                }
                this.mElements.removeAll(this.mSelected);
                this.refreshCurrentPage();
            }
            this.mSelected.clear();
            this.mSelectionMode = false;
            this.mMultiselect.setChecked(false);
            this.mEdit.setClickable(false);
            this.mDisconnect.setClickable(false);
        }
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        this.timer = (this.timer + 1) % 20;
        if (this.getCurrentPopup() == null && this.timer % 5 == 0) {
            ClientMessages.updateConnections(this.getToken(), this.getNetwork(), this.mCurrent);
        }
    }

    @Override
    protected void sortGrids(GuiTabPages.SortType sortType) {
        Comparator<IFluxDevice> comparator = Comparator.comparing(f -> !f.isChunkLoaded()).thenComparing(f -> f.getDeviceType().isStorage()).thenComparing(f -> f.getDeviceType().isPlug()).thenComparing(f -> f.getDeviceType().isPoint()).thenComparingInt(p -> -p.getRawPriority());
        this.mElements.sort(comparator);
    }
}

