/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.world.predicates;

import com.craisinlord.integrated_api.modinit.IAPredicates;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;

public class PieceOriginAxisAlignedLinearPosRuleTest
extends PosRuleTest {
    public static final Codec<PieceOriginAxisAlignedLinearPosRuleTest> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("min_chance").orElse((Object)Float.valueOf(0.0f)).forGetter(ruleTest -> Float.valueOf(ruleTest.minChance)), (App)Codec.FLOAT.fieldOf("max_chance").orElse((Object)Float.valueOf(0.0f)).forGetter(ruleTest -> Float.valueOf(ruleTest.maxChance)), (App)Codec.INT.fieldOf("min_dist").orElse((Object)0).forGetter(ruleTest -> ruleTest.minDistance), (App)Codec.INT.fieldOf("max_dist").orElse((Object)0).forGetter(ruleTest -> ruleTest.maxDistance), (App)Direction.Axis.f_122447_.fieldOf("axis").orElse((Object)Direction.Axis.Y).forGetter(ruleTest -> ruleTest.axis)).apply((Applicative)instance, PieceOriginAxisAlignedLinearPosRuleTest::new));
    private final float minChance;
    private final float maxChance;
    private final int minDistance;
    private final int maxDistance;
    private final Direction.Axis axis;

    public PieceOriginAxisAlignedLinearPosRuleTest(float minChance, float maxChance, int minDistance, int maxDistance, Direction.Axis axis) {
        if (minDistance >= maxDistance) {
            throw new IllegalArgumentException("Invalid range: [" + minDistance + "," + maxDistance + "]");
        }
        this.minChance = minChance;
        this.maxChance = maxChance;
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.axis = axis;
    }

    public boolean m_213782_(BlockPos blockPos, BlockPos blockPos2, BlockPos blockPos3, RandomSource random) {
        Direction direction = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.axis);
        float xDist = Math.abs(blockPos.m_123341_() * direction.m_122429_());
        float yDist = Math.abs(blockPos.m_123342_() * direction.m_122430_());
        float zDist = Math.abs(blockPos.m_123343_() * direction.m_122431_());
        int distanceFromOrigin = (int)(xDist + yDist + zDist);
        float randomChance = random.m_188501_();
        return (double)randomChance <= (double)Mth.m_144920_((float)this.minChance, (float)this.maxChance, (float)Mth.m_184655_((float)distanceFromOrigin, (float)this.minDistance, (float)this.maxDistance));
    }

    protected PosRuleTestType<?> m_6158_() {
        return IAPredicates.PIECE_ORIGIN_AXIS_ALIGNED_LINEAR_POS_RULE_TEST.get();
    }
}

