/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.gui;

import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEKey;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.util.IConfigManager;
import appeng.core.definitions.AEItems;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.locator.MenuLocator;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.RestrictedInputSlot;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.pedroksl.advanced_ae.api.AAESettings;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.entities.QuantumCrafterEntity;
import net.pedroksl.advanced_ae.gui.OutputDirectionMenu;
import net.pedroksl.advanced_ae.gui.QuantumCrafterConfigPatternMenu;
import net.pedroksl.advanced_ae.network.AAENetworkHandler;
import net.pedroksl.advanced_ae.network.packet.PatternsUpdatePacket;

public class QuantumCrafterMenu
extends UpgradeableMenu<QuantumCrafterEntity> {
    @GuiSync(value=2)
    public YesNo meExport = YesNo.YES;
    public List<Boolean> invalidPatterns = new ArrayList<Boolean>();
    public List<Boolean> enabledPatterns = new ArrayList<Boolean>();
    private static final String CONFIGURE_OUTPUT = "configureOutput";
    private static final String CONFIG_PATTERN = "configPattern";
    private static final String TOGGLE_ENABLE_PATTERN = "toggleEnablePattern";
    private final Slot[] patternSlots = new Slot[9];

    public QuantumCrafterMenu(int id, Inventory ip, QuantumCrafterEntity host) {
        super(AAEMenus.QUANTUM_CRAFTER.get(), id, ip, (IUpgradeableObject)host);
        InternalInventory patterns = host.getPatternInventory();
        for (int x = 0; x < patterns.size(); ++x) {
            this.patternSlots[x] = this.addSlot((Slot)new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODED_PATTERN, patterns, x), SlotSemantics.MACHINE_INPUT);
        }
        InternalInventory outputs = host.getOutputInv();
        for (int x = 0; x < outputs.size(); ++x) {
            this.addSlot((Slot)new AppEngSlot(outputs, x), SlotSemantics.MACHINE_OUTPUT);
        }
        this.setInvalidPatterns(host.getInvalidPatternSlots());
        this.setEnabledPatterns(host.getEnabledPatternSlots());
        this.registerClientAction(CONFIGURE_OUTPUT, this::configureOutput);
        this.registerClientAction(CONFIG_PATTERN, Integer.class, this::configPattern);
        this.registerClientAction(TOGGLE_ENABLE_PATTERN, Integer.class, this::toggleEnablePattern);
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
        this.meExport = (YesNo)((QuantumCrafterEntity)this.getHost()).getConfigManager().getSetting(AAESettings.ME_EXPORT);
        this.setRedStoneMode((RedstoneMode)((QuantumCrafterEntity)this.getHost()).getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED));
    }

    public YesNo getMeExport() {
        return this.meExport;
    }

    public void setInvalidPatterns(List<Boolean> invalidPatterns) {
        this.setInvalidPatterns(invalidPatterns, true);
    }

    public void setInvalidPatterns(List<Boolean> invalidPatterns, boolean broadcastUpdate) {
        this.invalidPatterns = new ArrayList<Boolean>(invalidPatterns);
        if (broadcastUpdate) {
            this.m_38946_();
        }
    }

    public void setEnabledPatterns(List<Boolean> enabledPatterns) {
        this.enabledPatterns = new ArrayList<Boolean>(enabledPatterns);
        this.m_38946_();
    }

    public void m_38946_() {
        Player player;
        super.m_38946_();
        if (this.isServerSide() && (player = this.getPlayer()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            this.setInvalidPatterns(((QuantumCrafterEntity)this.getHost()).getInvalidPatternSlots(), false);
            AAENetworkHandler.INSTANCE.sendTo(new PatternsUpdatePacket(this.invalidPatterns, this.enabledPatterns), player2);
        }
    }

    public void configureOutput() {
        if (this.isClientSide()) {
            this.sendClientAction(CONFIGURE_OUTPUT);
            return;
        }
        MenuLocator locator = this.getLocator();
        if (locator != null && this.isServerSide()) {
            OutputDirectionMenu.open((ServerPlayer)this.getPlayer(), this.getLocator(), ((QuantumCrafterEntity)this.getHost()).getAllowedOutputs());
        }
    }

    public void configPattern(int index) {
        if (this.isClientSide()) {
            this.sendClientAction(CONFIG_PATTERN, index);
            return;
        }
        MenuLocator locator = this.getLocator();
        if (locator != null && this.isServerSide()) {
            LinkedHashMap<AEKey, Long> inputs = ((QuantumCrafterEntity)this.getHost()).getPatternConfigInputs(index);
            Pair<AEKey, Long> output = ((QuantumCrafterEntity)this.getHost()).getPatternConfigOutput(index);
            if (inputs == null || output == null) {
                return;
            }
            QuantumCrafterConfigPatternMenu.open((ServerPlayer)this.getPlayer(), this.getLocator(), index, inputs, output);
        }
    }

    public void toggleInvalidPattern(int index, boolean invalid) {
        this.invalidPatterns.set(index, invalid);
    }

    public void toggleEnablePattern(int index) {
        if (this.isClientSide()) {
            this.sendClientAction(TOGGLE_ENABLE_PATTERN, index);
            return;
        }
        ((QuantumCrafterEntity)this.getHost()).toggleEnablePattern(index);
        this.setEnabledPatterns(((QuantumCrafterEntity)this.getHost()).getEnabledPatternSlots());
    }

    public boolean isValidForSlot(Slot s, ItemStack is) {
        for (Slot ps : this.patternSlots) {
            if (s != ps) continue;
            return AEItems.CRAFTING_PATTERN.isSameAs(is);
        }
        return super.isValidForSlot(s, is);
    }
}

