/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.datagen;

import java.util.Iterator;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.pedroksl.advanced_ae.common.definitions.AAEBlockDefinition;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.definitions.AAEFluids;
import net.pedroksl.advanced_ae.common.definitions.AAEHotkeys;
import net.pedroksl.advanced_ae.common.definitions.AAEItemDefinition;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.definitions.FluidDefinition;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import org.jetbrains.annotations.NotNull;

public class AAELanguageProvider
extends LanguageProvider {
    public AAELanguageProvider(PackOutput output) {
        super(output, "advanced_ae", "en_us");
    }

    protected void addTranslations() {
        for (AAEItemDefinition<?> aAEItemDefinition : AAEItems.getItems()) {
            this.add((Item)aAEItemDefinition.m_5456_(), aAEItemDefinition.getEnglishName());
        }
        for (AAEBlockDefinition aAEBlockDefinition : AAEBlocks.getBlocks()) {
            this.add((Block)aAEBlockDefinition.block(), aAEBlockDefinition.getEnglishName());
        }
        for (FluidDefinition fluidDefinition : AAEFluids.getFluids()) {
            this.add(fluidDefinition.fluidType(), fluidDefinition.getEnglishName());
            this.add((Fluid)fluidDefinition.flowing(), fluidDefinition.getEnglishName());
            this.add((Fluid)fluidDefinition.source(), fluidDefinition.getEnglishName());
            this.add((Block)fluidDefinition.block(), fluidDefinition.getEnglishName());
            this.add((Item)fluidDefinition.bucketItem(), fluidDefinition.bucketItemId().getEnglishName());
        }
        for (Iterator<Object> iterator : AAEText.values()) {
            this.add(((AAEText)((Object)iterator)).getTranslationKey(), ((AAEText)((Object)iterator)).getEnglishText());
        }
        for (Iterator<Object> iterator : AAEHotkeys.Keys.values()) {
            this.add("key.advanced_ae." + ((AAEHotkeys.Keys)((Object)iterator)).getId(), ((AAEHotkeys.Keys)((Object)iterator)).getEnglishTranslation());
        }
        for (Iterator<Object> iterator : UpgradeType.values()) {
            this.add(((UpgradeType)((Object)iterator)).getTranslationKey(), ((UpgradeType)((Object)iterator)).name);
        }
        this.generateLocalizations();
    }

    private void generateLocalizations() {
        this.add("key.advanced_ae.category", "Advanced AE");
        this.add("curios.identifier.adv_pattern_encoder", "Pattern Encoder");
    }

    public void add(FluidType key, String englishName) {
        this.add(Util.m_137492_((String)"fluid_type", (ResourceLocation)((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getKey((Object)key)), englishName);
    }

    public void add(Fluid key, String englishName) {
        this.add(Util.m_137492_((String)"fluid", (ResourceLocation)BuiltInRegistries.f_257020_.m_7981_((Object)key)), englishName);
    }

    @NotNull
    public String m_6055_() {
        return "Language";
    }
}

