/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.definitions;

import appeng.api.features.HotkeyAction;
import appeng.hotkeys.InventoryHotkeyAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.level.ItemLike;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.helpers.ArmorHotkeyAction;
import net.pedroksl.advanced_ae.common.helpers.ToggleUpgradeCardAction;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;

public final class AAEHotkeys {
    public static final Map<String, List<HotkeyAction>> REGISTRY = new HashMap<String, List<HotkeyAction>>();

    public static void init() {
        AAEHotkeys.registerArmorAction(AAEItems.QUANTUM_HELMET, (player, slot, stack) -> AAEItems.QUANTUM_HELMET.get().openFromEquipmentSlot(player, slot, stack), Keys.ARMOR_CONFIG.id);
        AAEHotkeys.registerArmorAction(AAEItems.QUANTUM_CHESTPLATE, (player, slot, stack) -> AAEItems.QUANTUM_CHESTPLATE.get().openFromEquipmentSlot(player, slot, stack), Keys.ARMOR_CONFIG.id);
        AAEHotkeys.registerArmorAction(AAEItems.QUANTUM_LEGGINGS, (player, slot, stack) -> AAEItems.QUANTUM_LEGGINGS.get().openFromEquipmentSlot(player, slot, stack), Keys.ARMOR_CONFIG.id);
        AAEHotkeys.registerArmorAction(AAEItems.QUANTUM_BOOTS, (player, slot, stack) -> AAEItems.QUANTUM_BOOTS.get().openFromEquipmentSlot(player, slot, stack), Keys.ARMOR_CONFIG.id);
        AAEHotkeys.register(AAEItems.ADV_PATTERN_ENCODER, (player, locator) -> AAEItems.ADV_PATTERN_ENCODER.get().openFromInventory(player, locator), Keys.PATTERN_ENCODER.id);
        AAEHotkeys.registerToggleUpgradeAction(AAEItems.QUANTUM_HELMET, (player, stack) -> AAEItems.QUANTUM_HELMET.get().toggleUpgrade(stack, UpgradeType.MAGNET, player), Keys.QUANTUM_MAGNET_UPGRADE.id);
        AAEHotkeys.registerToggleUpgradeAction(AAEItems.QUANTUM_HELMET, (player, stack) -> AAEItems.QUANTUM_HELMET.get().toggleUpgrade(stack, UpgradeType.AUTO_STOCK, player), Keys.QUANTUM_AUTO_STOCK_UPGRADE.id);
        AAEHotkeys.registerToggleUpgradeAction(AAEItems.QUANTUM_HELMET, (player, stack) -> AAEItems.QUANTUM_HELMET.get().toggleUpgrade(stack, UpgradeType.NIGHT_VISION, player), Keys.QUANTUM_NIGHT_VISION_UPGRADE.id);
        AAEHotkeys.registerArmorAction(AAEItems.QUANTUM_HELMET, (player, slot, stack) -> AAEItems.QUANTUM_HELMET.get().openPortableWorkbench(player, slot, stack), Keys.PORTABLE_WORKBENCH.id);
        AAEHotkeys.registerArmorAction(AAEItems.QUANTUM_CHESTPLATE, (player, slot, stack) -> AAEItems.QUANTUM_CHESTPLATE.get().attemptCraftingTarget(player, slot, stack), Keys.PICK_CRAFT.id);
    }

    public static void register(ItemLike item, InventoryHotkeyAction.Opener opener, String id) {
        AAEHotkeys.register((HotkeyAction)new InventoryHotkeyAction(stack -> stack.m_150930_(item.m_5456_()), opener), id);
    }

    public static void registerArmorAction(ItemLike item, ArmorHotkeyAction.Opener opener, String id) {
        AAEHotkeys.register(new ArmorHotkeyAction(item, opener), id);
    }

    public static void registerToggleUpgradeAction(ItemLike item, ToggleUpgradeCardAction.Opener opener, String id) {
        AAEHotkeys.register(new ToggleUpgradeCardAction(item, opener), id);
    }

    public static synchronized void register(HotkeyAction hotkeyAction, String id) {
        if (REGISTRY.containsKey(id)) {
            REGISTRY.get(id).add(0, hotkeyAction);
        } else {
            REGISTRY.put(id, new ArrayList<HotkeyAction>(List.of(hotkeyAction)));
            AdvancedAE.instance().registerHotkey(id);
        }
    }

    public static int getDefaultHotkey(String id) {
        try {
            return Keys.valueOf(id).getDefaultHotkey();
        }
        catch (IllegalArgumentException ignored) {
            return -1;
        }
    }

    public static enum Keys {
        ARMOR_CONFIG("quantum_armor_config", "Open Quantum Armor Configuration", 78),
        PATTERN_ENCODER("pattern_encoder_action", "Open Advanced Pattern Encoder"),
        QUANTUM_MAGNET_UPGRADE("quantum_magnet_upgrade", "Toggle Quantum Armor Magnet", 71),
        QUANTUM_AUTO_STOCK_UPGRADE("quantum_auto_stock_upgrade", "Toggle Quantum Armor Auto Stock", 74),
        QUANTUM_NIGHT_VISION_UPGRADE("quantum_night_vision_upgrade", "Toggle Quantum Armor Night Vision"),
        PORTABLE_WORKBENCH("portable_workbench", "Open Portable Workbench", 67),
        PICK_CRAFT("pick_craft", "Attempt crafting targeted block", 86);

        private final String id;
        private final String englishTranslation;
        private final int defaultHotkey;

        private Keys(String id, String englishTranslation) {
            this(id, englishTranslation, -1);
        }

        private Keys(String id, String englishTranslation, int defaultHotekey) {
            this.id = id;
            this.englishTranslation = englishTranslation;
            this.defaultHotkey = defaultHotekey;
        }

        public String getId() {
            return this.id;
        }

        public String getEnglishTranslation() {
            return this.englishTranslation;
        }

        public int getDefaultHotkey() {
            return this.defaultHotkey;
        }
    }
}

