/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.definitions;

import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.AEBaseBlockEntity;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.DeferredRegister;
import net.pedroksl.advanced_ae.common.definitions.AAEBlockDefinition;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.entities.AdvCraftingBlockEntity;
import net.pedroksl.advanced_ae.common.entities.AdvPatternProviderEntity;
import net.pedroksl.advanced_ae.common.entities.QuantumCrafterEntity;
import net.pedroksl.advanced_ae.common.entities.ReactionChamberEntity;
import net.pedroksl.advanced_ae.common.entities.SmallAdvPatternProviderEntity;

public final class AAEBlockEntities {
    public static final DeferredRegister<BlockEntityType<?>> DR = DeferredRegister.create((ResourceKey)Registries.f_256922_, (String)"advanced_ae");
    public static final Supplier<BlockEntityType<AdvCraftingBlockEntity>> QUANTUM_COMPUTER_CORE = AAEBlockEntities.create("quantum_core", AdvCraftingBlockEntity.class, AdvCraftingBlockEntity::new, AAEBlocks.QUANTUM_UNIT, AAEBlocks.QUANTUM_CORE, AAEBlocks.DATA_ENTANGLER, AAEBlocks.QUANTUM_STORAGE_128M, AAEBlocks.QUANTUM_STORAGE_256M, AAEBlocks.QUANTUM_ACCELERATOR, AAEBlocks.QUANTUM_MULTI_THREADER, AAEBlocks.QUANTUM_STRUCTURE);
    public static final Supplier<BlockEntityType<AdvPatternProviderEntity>> ADV_PATTERN_PROVIDER = AAEBlockEntities.create("adv_pattern_provider", AdvPatternProviderEntity.class, AdvPatternProviderEntity::new, AAEBlocks.ADV_PATTERN_PROVIDER);
    public static final Supplier<BlockEntityType<SmallAdvPatternProviderEntity>> SMALL_ADV_PATTERN_PROVIDER = AAEBlockEntities.create("small_adv_pattern_provider", SmallAdvPatternProviderEntity.class, SmallAdvPatternProviderEntity::new, AAEBlocks.SMALL_ADV_PATTERN_PROVIDER);
    public static final Supplier<BlockEntityType<ReactionChamberEntity>> REACTION_CHAMBER = AAEBlockEntities.create("reaction_chamber", ReactionChamberEntity.class, ReactionChamberEntity::new, AAEBlocks.REACTION_CHAMBER);
    public static final Supplier<BlockEntityType<QuantumCrafterEntity>> QUANTUM_CRAFTER = AAEBlockEntities.create("quantum_craft", QuantumCrafterEntity.class, QuantumCrafterEntity::new, AAEBlocks.QUANTUM_CRAFTER);

    @SafeVarargs
    private static <T extends AEBaseBlockEntity> Supplier<BlockEntityType<T>> create(String id, Class<T> entityClass, BlockEntityFactory<T> factory, AAEBlockDefinition<? extends AEBaseEntityBlock<?>> ... blockDefs) {
        if (blockDefs.length == 0) {
            throw new IllegalArgumentException();
        }
        return DR.register(id, () -> {
            AEBaseEntityBlock[] blocks = (AEBaseEntityBlock[])Arrays.stream(blockDefs).map(AAEBlockDefinition::block).toArray(AEBaseEntityBlock[]::new);
            AtomicReference<BlockEntityType> typeHolder = new AtomicReference<BlockEntityType>();
            BlockEntityType type = BlockEntityType.Builder.m_155273_((pos, state) -> factory.create((BlockEntityType)typeHolder.get(), pos, state), (Block[])blocks).m_58966_(null);
            typeHolder.set(type);
            AEBaseBlockEntity.registerBlockEntityItem((BlockEntityType)type, (Item)blockDefs[0].asItem());
            for (AEBaseEntityBlock block : blocks) {
                block.setBlockEntity(entityClass, type, null, null);
            }
            return type;
        });
    }

    private static interface BlockEntityFactory<T extends AEBaseBlockEntity> {
        public T create(BlockEntityType<T> var1, BlockPos var2, BlockState var3);
    }
}

