/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.blocks;

import appeng.block.AEBaseEntityBlock;
import appeng.block.crafting.ICraftingUnitType;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.entities.AdvCraftingBlockEntity;
import org.jetbrains.annotations.NotNull;

public abstract class AAEAbstractCraftingUnitBlock<T extends AEBaseBlockEntity>
extends AEBaseEntityBlock<T> {
    public static final BooleanProperty FORMED = BooleanProperty.m_61465_((String)"formed");
    public static final BooleanProperty POWERED = BooleanProperty.m_61465_((String)"powered");
    public static final IntegerProperty LIGHT_LEVEL = IntegerProperty.m_61631_((String)"light_level", (int)0, (int)15);
    public final ICraftingUnitType type;

    public AAEAbstractCraftingUnitBlock(BlockBehaviour.Properties props, ICraftingUnitType type) {
        super(props);
        this.type = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FORMED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED});
        builder.m_61104_(new Property[]{FORMED});
        builder.m_61104_(new Property[]{LIGHT_LEVEL});
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BlockEntity te = level.m_7702_(currentPos);
        if (te != null) {
            te.requestModelDataUpdate();
        }
        return super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    @ParametersAreNonnullByDefault
    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        AdvCraftingBlockEntity cp = (AdvCraftingBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (cp != null) {
            cp.updateMultiBlock(fromPos);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.m_60734_() == state.m_60734_()) {
            return;
        }
        AdvCraftingBlockEntity cp = (AdvCraftingBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (cp != null) {
            cp.breakCluster();
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        AdvCraftingBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AdvCraftingBlockEntity && (be = (AdvCraftingBlockEntity)blockEntity).isFormed() && be.isActive()) {
            if (!level.m_5776_()) {
                MenuOpener.open(AAEMenus.QUANTUM_COMPUTER.get(), (Player)player, (MenuLocator)MenuLocators.forBlockEntity((BlockEntity)be));
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }
}

