/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.utils;

import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.compat.DawnEraHelper;
import com.shiftthedev.pickablepets.compat.DomesticationHelper;
import com.shiftthedev.pickablepets.compat.GoetyHelper;
import com.shiftthedev.pickablepets.mixins.WalkAnimationStateAccessor;
import dev.architectury.platform.Platform;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.level.Level;

public class PetInfo {
    private LivingEntity petEntity;
    private boolean inAltar;
    private boolean inItem;
    private boolean isAlive;
    private boolean wasRevived;
    private String ownerName;
    private AttributeMap attributeMap;
    private boolean updated;

    public PetInfo(LivingEntity entity) {
        this.petEntity = entity;
        this.inAltar = false;
        this.inItem = false;
        this.isAlive = true;
        this.wasRevived = false;
        this.trySetOwner();
        this.attributeMap = entity.m_21204_();
        this.setupPose();
    }

    public PetInfo(LivingEntity entity, String ownerName) {
        this.petEntity = entity;
        this.inAltar = false;
        this.inItem = false;
        this.isAlive = true;
        this.wasRevived = false;
        this.ownerName = ownerName;
        this.attributeMap = entity.m_21204_();
        this.setupPose();
    }

    public PetInfo() {
    }

    public void setInItem(boolean flag) {
        this.inItem = flag;
    }

    public boolean isInItem() {
        return this.inItem;
    }

    public LivingEntity getPetEntity() {
        return this.petEntity;
    }

    public Component getName() {
        if (this.petEntity == null) {
            return Component.m_237119_();
        }
        return this.petEntity.m_5446_();
    }

    public ListTag getAttributes() {
        if (this.attributeMap != null) {
            return this.attributeMap.m_22180_();
        }
        return new ListTag();
    }

    public LivingEntity getRender() {
        return this.petEntity;
    }

    public String getOwner() {
        if (this.ownerName == null || this.ownerName.isEmpty()) {
            this.trySetOwner();
        }
        return this.ownerName;
    }

    private void trySetOwner() {
        if (this.petEntity == null) {
            this.ownerName = "";
            return;
        }
        boolean isException = false;
        if (Platform.isForge()) {
            if (PickablePets.FoundDomestication && DomesticationHelper.isFromMod(this.petEntity)) {
                isException = true;
                this.ownerName = DomesticationHelper.getOwnerName(this.petEntity);
            }
            if (PickablePets.FoundDawnEra && DawnEraHelper.isFromMod(this.petEntity)) {
                isException = true;
                this.ownerName = DawnEraHelper.getOwnerName(this.petEntity);
            }
            if (PickablePets.FoundGoety && GoetyHelper.isFromMod(this.petEntity)) {
                isException = true;
                this.ownerName = GoetyHelper.getOwnerName(this.petEntity);
            }
        }
        if (!isException) {
            Component name;
            LivingEntity ownerEntity = ((OwnableEntity)this.petEntity).m_269323_();
            this.ownerName = ownerEntity != null ? ((name = ownerEntity.m_5446_()) != null ? name.getString() : "") : "";
        }
    }

    public void updateEntity(LivingEntity newEntity) {
        this.petEntity = newEntity;
    }

    public void updateAttributes(LivingEntity entity) {
        this.attributeMap = entity.m_21204_();
    }

    public void markDead() {
        this.isAlive = false;
    }

    public void revive() {
        this.petEntity.f_19789_ = 0.0f;
        this.petEntity.m_7910_(0.0f);
        this.isAlive = true;
        this.wasRevived = true;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated() {
        this.updated = true;
    }

    public boolean wasRevived() {
        return this.wasRevived;
    }

    public CompoundTag save(CompoundTag tag) {
        if (this.petEntity != null) {
            tag = this.petEntity.m_20240_(tag);
            tag.m_128359_("pp_type", EntityType.m_20613_((EntityType)this.petEntity.m_6095_()).toString());
            tag.m_128379_("pp_altar", this.inAltar);
            tag.m_128379_("pp_item", this.inItem);
            tag.m_128379_("pp_alive", this.isAlive);
            tag.m_128379_("pp_revived", this.wasRevived);
            tag.m_128359_("pp_owner", this.ownerName);
            if (this.attributeMap != null) {
                tag.m_128365_("pp_attributes", (Tag)this.attributeMap.m_22180_());
            }
            tag.m_128379_("pp_updated", this.updated);
        }
        return tag;
    }

    public void load(UUID petId, CompoundTag tag, Level level) {
        if (!tag.m_128441_("pp_type")) {
            return;
        }
        Optional entityType = EntityType.m_20632_((String)tag.m_128461_("pp_type"));
        if (entityType.isEmpty()) {
            return;
        }
        this.petEntity = (LivingEntity)((EntityType)entityType.get()).m_20615_(level);
        if (this.petEntity == null) {
            return;
        }
        this.petEntity.m_20258_(tag);
        this.petEntity.m_20084_(petId);
        this.inAltar = tag.m_128441_("pp_altar") && tag.m_128471_("pp_altar");
        this.inItem = tag.m_128441_("pp_item") && tag.m_128471_("pp_item");
        this.isAlive = tag.m_128441_("pp_alive") && tag.m_128471_("pp_alive");
        this.wasRevived = tag.m_128441_("pp_revived") && tag.m_128471_("pp_revived");
        String string = this.ownerName = tag.m_128441_("pp_owner") ? tag.m_128461_("pp_owner") : "";
        if (tag.m_128441_("pp_attributes")) {
            this.attributeMap = this.petEntity.m_21204_();
            this.attributeMap.m_22168_(tag.m_128437_("pp_attributes", 10));
        }
        if (tag.m_128441_("pp_updated")) {
            this.updated = tag.m_128471_("pp_updated");
        }
        this.setupPose();
        level.m_46473_().m_7238_();
    }

    private void setupPose() {
        if (this.petEntity == null) {
            return;
        }
        this.petEntity.f_20883_ = 0.0f;
        this.petEntity.f_20884_ = 0.0f;
        this.petEntity.f_19859_ = 0.0f;
        this.petEntity.f_19860_ = 0.0f;
        this.petEntity.m_146922_(0.0f);
        this.petEntity.m_146926_(0.0f);
        this.petEntity.f_20885_ = 0.0f;
        this.petEntity.f_20886_ = 0.0f;
        this.petEntity.f_20919_ = 0;
        ((WalkAnimationStateAccessor)this.petEntity.f_267362_).setSpeedOld(0.0f);
        this.petEntity.m_7910_(0.0f);
        ((WalkAnimationStateAccessor)this.petEntity.f_267362_).setPosition(0.0f);
        this.petEntity.f_19854_ = 0.0;
        this.petEntity.f_19856_ = 0.0;
        this.petEntity.f_20921_ = 0.0f;
        this.petEntity.m_9236_().m_46473_().m_7238_();
    }
}

