/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.network;

import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.compat.HamstersCompat;
import com.shiftthedev.pickablepets.utils.Helper;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class PickupPacket {
    private static final ResourceLocation PACKET_ID = new ResourceLocation("pickablepets", "input");

    public static void sendToServer(UUID petUUID, float distance) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.m_130077_(petUUID);
        buffer.writeFloat(distance);
        NetworkManager.sendToServer((ResourceLocation)PACKET_ID, (FriendlyByteBuf)buffer);
    }

    public static class Server {
        public static void register() {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)PACKET_ID, Server::receive);
        }

        public static void receive(FriendlyByteBuf buffer, NetworkManager.PacketContext context) {
            if (!PickablePets.CONFIG.KeyShortcut) {
                return;
            }
            Player player = context.getPlayer();
            UUID petUUID = buffer.m_130259_();
            float distance = buffer.readFloat();
            player.m_9236_().m_6443_(LivingEntity.class, player.m_20191_().m_82400_((double)distance), entity -> entity.m_20148_().equals(petUUID)).stream().findAny().ifPresent(livingEntity -> {
                String entityKey = EntityType.m_20613_((EntityType)livingEntity.m_6095_()).toString();
                if (PickablePets.CONFIG.BlacklistedPets.contains(entityKey) || PickablePets.CONFIG.BlacklistedMods.contains(entityKey.split(":")[0])) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.pickablepets.blacklist"), true);
                } else if (PickablePets.FoundHamsters) {
                    if (!HamstersCompat.isFromMod(livingEntity)) {
                        Helper.Pickup(livingEntity, (LivingEntity)player);
                    }
                } else {
                    Helper.Pickup(livingEntity, (LivingEntity)player);
                }
            });
        }
    }
}

