/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.mixins;

import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.compat.HamstersCompat;
import com.shiftthedev.pickablepets.utils.Helper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    @Shadow
    public abstract void m_5661_(Component var1, boolean var2);

    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"interactOn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;", shift=At.Shift.BEFORE)}, cancellable=true)
    private void interactImpl(Entity entity, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResult> cir) {
        if (PickablePets.CONFIG.SneakRightClick && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!this.m_9236_().f_46443_ && this.m_6047_()) {
                String entityKey = EntityType.m_20613_((EntityType)entity.m_6095_()).toString();
                if (PickablePets.CONFIG.BlacklistedPets.contains(entityKey) || PickablePets.CONFIG.BlacklistedMods.contains(entityKey.split(":")[0])) {
                    this.m_5661_((Component)Component.m_237115_((String)"message.pickablepets.blacklist"), true);
                }
                if (PickablePets.FoundHamsters) {
                    if (!HamstersCompat.isFromMod(livingEntity) && Helper.Pickup(livingEntity, this)) {
                        cir.setReturnValue((Object)InteractionResult.SUCCESS);
                        cir.cancel();
                    }
                } else if (Helper.Pickup(livingEntity, this)) {
                    cir.setReturnValue((Object)InteractionResult.SUCCESS);
                    cir.cancel();
                }
            }
        }
    }
}

