/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.mixins;

import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.utils.CachedPets;
import com.shiftthedev.pickablepets.utils.Helper;
import com.shiftthedev.pickablepets.utils.PlayerPets;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractHorse.class})
public abstract class AbstractHorseMixin
extends Animal {
    @Shadow
    @Nullable
    public abstract UUID m_21805_();

    protected AbstractHorseMixin(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"doPlayerRide"}, at={@At(value="RETURN")})
    private void doPlayerRide_fixOwner(Player player, CallbackInfo ci) {
        if (player instanceof ServerPlayer) {
            Helper.fixHorse((AbstractHorse)this, (ServerPlayer)player);
        }
    }

    @Inject(method={"openCustomInventoryScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;openHorseInventory(Lnet/minecraft/world/entity/animal/horse/AbstractHorse;Lnet/minecraft/world/Container;)V")})
    private void openInventory_fixOwner(Player player, CallbackInfo ci) {
        if (player instanceof ServerPlayer) {
            Helper.fixHorse((AbstractHorse)this, (ServerPlayer)player);
        }
    }

    @Inject(method={"tameWithName"}, at={@At(value="INVOKE", target="Lnet/minecraft/advancements/critereon/TameAnimalTrigger;trigger(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/entity/animal/Animal;)V", shift=At.Shift.AFTER)})
    private void tameWithName_pets(Player player, CallbackInfoReturnable<Boolean> cir) {
        String entityKey;
        if (!(this.m_9236_().f_46443_ || PickablePets.CONFIG.BlacklistedPets.contains(entityKey = EntityType.m_20613_((EntityType)this.m_6095_()).toString()) || PickablePets.CONFIG.BlacklistedMods.contains(entityKey.split(":")[0]))) {
            UUID owner = this.m_21805_();
            if (owner == null) {
                return;
            }
            Path path = ((ServerLevel)this.m_9236_()).m_7654_().m_129843_(new LevelResource("data/pets"));
            path = path.resolve(owner.toString() + ".pets");
            PlayerPets.addPetAsync(path, this.m_20148_());
            CachedPets.addPet((LivingEntity)((AbstractHorse)this));
            CachedPets.setUpdated(this.m_20148_());
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    private void readAdditionalSaveData_pets(CompoundTag compoundTag, CallbackInfo ci) {
        String entityKey;
        if (!(this.m_9236_().f_46443_ || PickablePets.CONFIG.BlacklistedPets.contains(entityKey = EntityType.m_20613_((EntityType)this.m_6095_()).toString()) || PickablePets.CONFIG.BlacklistedMods.contains(entityKey.split(":")[0]) || CachedPets.isPetUpdated(this.m_20148_()) || !compoundTag.m_128403_("Owner"))) {
            PlayerPets.saveOldPet(this.m_20148_().toString(), compoundTag.m_128342_("Owner").toString(), (ServerLevel)this.m_9236_());
            CachedPets.addPet((LivingEntity)((AbstractHorse)this));
            CachedPets.setUpdated(this.m_20148_());
        }
    }

    public void m_21463_(Entity entity, boolean bl) {
        super.m_21463_(entity, bl);
        if (entity instanceof ServerPlayer) {
            Helper.fixHorse((AbstractHorse)this, (ServerPlayer)entity);
        }
    }
}

