/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.items;

import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.compat.DawnEraHelper;
import com.shiftthedev.pickablepets.compat.DoggyHelper;
import com.shiftthedev.pickablepets.compat.DomesticationHelper;
import com.shiftthedev.pickablepets.compat.GoetyHelper;
import com.shiftthedev.pickablepets.utils.CachedPets;
import dev.architectury.platform.Platform;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class PetItem
extends Item {
    public static final int VERSION = 2;

    public PetItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Player player = ctx.m_43723_();
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Level level = ctx.m_43725_();
        if (ctx.m_43724_() != InteractionHand.MAIN_HAND) {
            return InteractionResult.FAIL;
        }
        ItemStack itemStack = ctx.m_43722_();
        CompoundTag tag = itemStack.m_41698_("pet_info");
        BlockPos blockPos = ctx.m_8083_();
        Direction direction = ctx.m_43719_();
        BlockState blockState = level.m_8055_(blockPos);
        return this.placePet((Player)player2, level, blockState, blockPos, direction, itemStack, tag);
    }

    private InteractionResult placePet(Player player, Level level, BlockState blockState, BlockPos blockPos, Direction direction, ItemStack itemStack, CompoundTag tag) {
        UUID petUUID = tag.m_128342_("UUID");
        LivingEntity cachedPet = CachedPets.getPet(petUUID);
        if (cachedPet == null) {
            return InteractionResult.FAIL;
        }
        boolean isException = false;
        if (Platform.isForge()) {
            if (PickablePets.FoundDomestication && DomesticationHelper.isFromMod(cachedPet) && !DomesticationHelper.isOwner(cachedPet, (ServerPlayer)player)) {
                return InteractionResult.FAIL;
            }
            if (PickablePets.FoundDawnEra && DawnEraHelper.isFromMod(cachedPet) && !DawnEraHelper.isOwner(cachedPet, (LivingEntity)player)) {
                return InteractionResult.FAIL;
            }
            if (PickablePets.FoundGoety && GoetyHelper.isFromMod(cachedPet) && !GoetyHelper.isOwner(cachedPet, (LivingEntity)player)) {
                return InteractionResult.FAIL;
            }
        }
        if (!(isException || cachedPet instanceof Allay || player.m_20148_().equals(((OwnableEntity)cachedPet).m_21805_()))) {
            return InteractionResult.FAIL;
        }
        if (!blockState.m_60812_((BlockGetter)level, blockPos).m_83281_()) {
            blockPos = direction == Direction.DOWN ? blockPos.m_5484_(direction, 2) : blockPos.m_121945_(direction);
        }
        BlockPos finalBlockPos = blockPos;
        level.m_7654_().execute(() -> {
            if (PickablePets.FoundDoggy && DoggyHelper.isFromMod(cachedPet)) {
                LivingEntity pet = DoggyHelper.reviveDog(cachedPet, petUUID, player, (ServerLevel)level, finalBlockPos);
                if (pet == null) {
                    return;
                }
                if (player.m_7500_()) {
                    player.m_150109_().m_36057_(itemStack);
                } else {
                    itemStack.m_41764_(0);
                }
            } else {
                LivingEntity pet = (LivingEntity)cachedPet.m_6095_().m_20615_(level);
                if (pet == null) {
                    return;
                }
                pet.m_20361_((Entity)cachedPet);
                pet.m_21204_().m_22168_(CachedPets.getPetAttributes(petUUID));
                pet.m_146884_(Vec3.m_82512_((Vec3i)finalBlockPos));
                if (!level.m_7967_((Entity)pet)) {
                    return;
                }
                if (player.m_7500_()) {
                    player.m_150109_().m_36057_(itemStack);
                } else {
                    itemStack.m_41764_(0);
                }
                CachedPets.addPet(pet);
                CachedPets.sendPetsToPlayers(level, petUUID);
            }
            CachedPets.setPetItem(petUUID, false);
            level.m_46473_().m_7238_();
        });
        return InteractionResult.SUCCESS;
    }

    public void m_142023_(ItemEntity itemEntity) {
        CompoundTag tag = itemEntity.m_32055_().m_41698_("pet_info");
        if (!tag.m_128441_("UUID")) {
            return;
        }
        CachedPets.killPet(tag.m_128342_("UUID"));
    }

    public Component m_7626_(ItemStack itemStack) {
        if (itemStack.m_41788_()) {
            return itemStack.m_41786_();
        }
        CompoundTag tag = itemStack.m_41698_("pet_info");
        return CachedPets.getPetName(tag.m_128342_("UUID"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, list, tooltipFlag);
        CompoundTag tag = itemStack.m_41698_("pet_info");
        if (!tag.m_128441_("UUID")) {
            list.add((Component)Component.m_237115_((String)"tooltip.pickablepets.empty"));
            return;
        }
        list.add((Component)Component.m_237110_((String)"tooltip.pickablepets.owner", (Object[])new Object[]{CachedPets.getOwner(tag.m_128342_("UUID"))}));
    }
}

